/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.MathMLEntityMap;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.WmiUnicodeMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class WmiMathEntityNameMapper {
    public static final char NULL_CHARACTER = '\u0000';
    public static final String TAB = "Tab";
    public static final String NEW_LINE = "NewLine";
    public static final String INDENTING_NEW_LINE = "IndentingNewLine";
    public static final String NO_BREAK = "NoBreak";
    public static final String GOOD_BREAK = "GoodBreak";
    public static final String BAD_BREAK = "BadBreak";
    public static final String SPACE = "Space";
    public static final String NON_BREAKING_SPACE = "NonBreakingSpace";
    public static final String NBSP = "nbsp";
    public static final String ZERO_WIDTH_SPACE = "ZeroWidthSpace";
    public static final String VERY_THIN_SPACE = "VeryThinSpace";
    public static final String THIN_SPACE = "ThinSpace";
    public static final String THIN_SP = "thinsp";
    public static final String MEDIUM_SPACE = "MediumSpace";
    public static final String THICK_SPACE = "ThickSpace";
    public static final String NEGATIVE_VERY_THIN_SPACE = "NegativeVeryThinSpace";
    public static final String NEGATIVE_THIN_SPACE = "NegativeThinSpace";
    public static final String NEGATIVE_MEDIUM_SPACE = "NegativeMediumSpace";
    public static final String NEGATIVE_THICK_SPACE = "NegativeThickSpace";
    private static Set spaceEntities = new HashSet();
    private static Set emptyEntities = new HashSet();
    private static Set nonMarkingEntities = new HashSet();
    private static MathMLEntityMap entityNameMap = MathMLEntityMap.getInstance();
    private static WmiUnicodeMapper preferredEntityNames = new WmiUnicodeMapper();
    private static String internalDTDSubset = null;

    private static void createSpaceMappings() {
        spaceEntities.add("InvisibleTimes");
        spaceEntities.add("it");
        emptyEntities.add("InvisibleComma");
        emptyEntities.add("ic");
    }

    private static void createEmptyMappings() {
        emptyEntities.add("ApplyFunction");
        emptyEntities.add("af");
    }

    private static void createNonMarkingMappings() {
        nonMarkingEntities.add(TAB);
        nonMarkingEntities.add(NEW_LINE);
        nonMarkingEntities.add(INDENTING_NEW_LINE);
        nonMarkingEntities.add(NO_BREAK);
        nonMarkingEntities.add(GOOD_BREAK);
        nonMarkingEntities.add(BAD_BREAK);
        nonMarkingEntities.add(SPACE);
        nonMarkingEntities.add(NBSP);
        nonMarkingEntities.add(ZERO_WIDTH_SPACE);
        nonMarkingEntities.add(VERY_THIN_SPACE);
        nonMarkingEntities.add(THIN_SPACE);
        nonMarkingEntities.add(THIN_SP);
        nonMarkingEntities.add(MEDIUM_SPACE);
        nonMarkingEntities.add(THICK_SPACE);
        nonMarkingEntities.add(NEGATIVE_VERY_THIN_SPACE);
        nonMarkingEntities.add(NEGATIVE_THIN_SPACE);
        nonMarkingEntities.add(NEGATIVE_MEDIUM_SPACE);
        nonMarkingEntities.add(NEGATIVE_THICK_SPACE);
    }

    private static void createPreferredUnicodeMappings() {
        preferredEntityNames.put('\u2061', "ApplyFunction");
        preferredEntityNames.put('\u212d', "Cayleys");
        preferredEntityNames.put('\u21ad', "leftrightsquigarrow");
        preferredEntityNames.put('\u2261', "equiv");
        preferredEntityNames.put('\u2228', "or");
        preferredEntityNames.put('\u2329', "lang");
        preferredEntityNames.put('\u22a8', "DoubleRightTee");
        preferredEntityNames.put('\u2267', "gE");
        preferredEntityNames.put('`', "grave");
        preferredEntityNames.put('\u219b', "nrightarrow");
        preferredEntityNames.put('\u2111', "Im");
        preferredEntityNames.put('\u2299', "CircleDot");
        preferredEntityNames.put('\u2309', "rceil");
        preferredEntityNames.put('\u2265', "ge");
        preferredEntityNames.put('\u02dd', "DiacriticalDoubleAcute");
        preferredEntityNames.put('\u2274', "NotLessTilde");
        preferredEntityNames.put('\u2026', "hellip");
        preferredEntityNames.put('\u27e6', "lobrk");
        preferredEntityNames.put('\u03dd', "digamma");
        preferredEntityNames.put('\u2208', "in");
        preferredEntityNames.put('\u2226', "nparallel");
        preferredEntityNames.put('\u03b5', "varepsilon");
        preferredEntityNames.put('\u2929', "tosa");
        preferredEntityNames.put('\u2115', "naturals");
        preferredEntityNames.put('\u2720', "malt");
        preferredEntityNames.put('\u22de', "curlyeqprec");
        preferredEntityNames.put('\u2a8a', "gnapprox");
        preferredEntityNames.put('\u2204', "nexists");
        preferredEntityNames.put('\u226f', "ngt");
        preferredEntityNames.put('\u22d4', "fork");
        preferredEntityNames.put('\u21a9', "hookleftarrow");
        preferredEntityNames.put('\u21da', "Lleftarrow");
        preferredEntityNames.put('\u22da', "LessEqualGreater");
        preferredEntityNames.put('\u2665', "hearts");
        preferredEntityNames.put('\u2233', "CounterClockwiseContourIntegral");
        preferredEntityNames.put('\u2a95', "eqslantless");
        preferredEntityNames.put('\u227c', "preccurlyeq");
        preferredEntityNames.put('\u22d6', "lessdot");
        preferredEntityNames.put('\u2a06', "bigsqcup");
        preferredEntityNames.put('\u2276', "LessGreater");
        preferredEntityNames.put('\u2202', "PartialD");
        preferredEntityNames.put('\u2a8c', "gEl");
        preferredEntityNames.put('\u220c', "NotReverseElement");
        preferredEntityNames.put('\u229d', "circleddash");
        preferredEntityNames.put('\u229f', "boxminus");
        preferredEntityNames.put('\u211d', "reals");
        preferredEntityNames.put('\u231e', "llcorner");
        preferredEntityNames.put('\u21cc', "Equilibrium");
        preferredEntityNames.put('\u2a00', "bigodot");
        preferredEntityNames.put('\u02d9', "dot");
        preferredEntityNames.put('\u2237', "Colon");
        preferredEntityNames.put('\u03c6', "varphi");
        preferredEntityNames.put('\u25bd', "triangledown");
        preferredEntityNames.put('\u231c', "ulcorner");
        preferredEntityNames.put('\u211b', "realine");
        preferredEntityNames.put('\u2272', "LessTilde");
        preferredEntityNames.put('\u2272', "LessTilde");
        preferredEntityNames.put('\u2ab0', "SucceedsEqual");
        preferredEntityNames.put('\u2235', "Because");
        preferredEntityNames.put('\u22b5', "trianglerighteq");
        preferredEntityNames.put('\u25ca', "lozenge");
        preferredEntityNames.put('\u200a', VERY_THIN_SPACE);
        preferredEntityNames.put('\u25b2', "blacktriangle");
        preferredEntityNames.put('\u2260', "ne");
        preferredEntityNames.put('\u22c3', "bigcup");
        preferredEntityNames.put('\u21b6', "curvearrowleft");
        preferredEntityNames.put('\u228a', "subsetneq");
        preferredEntityNames.put('\u2ab5', "precneqq");
        preferredEntityNames.put('\u21ca', "downdownarrows");
        preferredEntityNames.put('\u22e0', "NotPrecedesSlantEqual");
        preferredEntityNames.put('\u21bf', "LeftUpVector");
        preferredEntityNames.put('\u2663', "clubs");
        preferredEntityNames.put('\u224d', "CupCap");
        preferredEntityNames.put('\u2660', "spades");
        preferredEntityNames.put('\u25b6', "blacktriangleright");
        preferredEntityNames.put('\u21c4', "rightleftarrows");
        preferredEntityNames.put('\u2063', "InvisibleComma");
        preferredEntityNames.put('\u22e9', "succnsim");
        preferredEntityNames.put('\u00b4', "acute");
        preferredEntityNames.put('\u2278', "NotLessGreater");
        preferredEntityNames.put('\u2022', "bullet");
        preferredEntityNames.put('\u296e', "UpEquilibrium");
        preferredEntityNames.put('\u2286', "sube");
        preferredEntityNames.put('\u21c6', "leftrightarrows");
        preferredEntityNames.put('\u21c8', "upuparrows");
        preferredEntityNames.put('\u2210', "coprod");
        preferredEntityNames.put('\u00b7', "middot");
        preferredEntityNames.put('\u00b7', "middot");
        preferredEntityNames.put('\u2211', "Sum");
        preferredEntityNames.put('\u22c1', "bigvee");
        preferredEntityNames.put('\u21bd', "DownLeftVector");
        preferredEntityNames.put('\u2119', "primes");
        preferredEntityNames.put('\u2a88', "gne");
        preferredEntityNames.put('\u2224', "NotVerticalBar");
        preferredEntityNames.put('\u22ed', "NotRightTriangleEqual");
        preferredEntityNames.put('\u229b', "circledast");
        preferredEntityNames.put('\u22eb', "NotRightTriangle");
        preferredEntityNames.put('\u21c2', "RightDownVector");
        preferredEntityNames.put('\u2010', "hyphen");
        preferredEntityNames.put('\u2a86', "gtrapprox");
        preferredEntityNames.put('\u2245', "TildeFullEqual");
        preferredEntityNames.put('\u03d6', "varpi");
        preferredEntityNames.put('\u2288', "NotSubsetEqual");
        preferredEntityNames.put('{', "lcub");
        preferredEntityNames.put('\u2247', "NotTildeFullEqual");
        preferredEntityNames.put('\u2308', "lceil");
        preferredEntityNames.put('\u21bc', "LeftVector");
        preferredEntityNames.put('\u21ce', "nLeftrightarrow");
        preferredEntityNames.put('\ue20c', "nsubE");
        preferredEntityNames.put('\u2a01', "bigoplus");
        preferredEntityNames.put('\u25bc', "blacktriangledown");
        preferredEntityNames.put('\u21ba', "circlearrowleft");
        preferredEntityNames.put('\u2212', "minus");
        preferredEntityNames.put('\u21d1', "DoubleUpArrow");
        preferredEntityNames.put('\u224e', "Bumpeq");
        preferredEntityNames.put('\ue206', "nlE");
        preferredEntityNames.put('\u21d0', "DoubleLeftArrow");
        preferredEntityNames.put('\u2249', "napprox");
        preferredEntityNames.put('\u2243', "TildeEqual");
        preferredEntityNames.put('\u2925', "searhk");
        preferredEntityNames.put('\u00f7', "divide");
        preferredEntityNames.put('\u228b', "supsetneq");
        preferredEntityNames.put('\u03c2', "varsigma");
        preferredEntityNames.put('\u2194', "LeftRightArrow");
        preferredEntityNames.put('\u2a7d', "LessSlantEqual");
        preferredEntityNames.put('\u2216', "setmn");
        preferredEntityNames.put('\u2279', "NotGreaterLess");
        preferredEntityNames.put('\u21e4', "LeftArrowBar");
        preferredEntityNames.put('\u2131', "Fouriertrf");
        preferredEntityNames.put('\u2133', "Mellintrf");
        preferredEntityNames.put('\u228f', "sqsubset");
        preferredEntityNames.put('\u22ce', "curlyvee");
        preferredEntityNames.put('\u2214', "dotplus");
        preferredEntityNames.put('\u21a5', "mapstoup");
        preferredEntityNames.put('\u21d3', "DoubleDownArrow");
        preferredEntityNames.put('\u22d7', "gtdot");
        preferredEntityNames.put('}', "rcub");
        preferredEntityNames.put('\u2016', "Vert");
        preferredEntityNames.put('\u2250', "doteq");
        preferredEntityNames.put('\u2306', "Barwed");
        preferredEntityNames.put('\u25a1', "Square");
        preferredEntityNames.put('\u03f0', "kappav");
        preferredEntityNames.put('\u2ac5', "subE");
        preferredEntityNames.put('\u02c7', "Hacek");
        preferredEntityNames.put('\u2ab8', "succapprox");
        preferredEntityNames.put('\u22b4', "LeftTriangleEqual");
        preferredEntityNames.put('\u227b', "Succeeds");
        preferredEntityNames.put('\u2251', "eDot");
        preferredEntityNames.put('\u2253', "risingdotseq");
        preferredEntityNames.put('\u2282', "subset");
        preferredEntityNames.put('\u2201', "complement");
        preferredEntityNames.put('\u2acc', "supnE");
        preferredEntityNames.put('\u219e', "twoheadleftarrow");
        preferredEntityNames.put('\ue202', "NotHumpDownHump");
        preferredEntityNames.put('\u2255', "eqcolon");
        preferredEntityNames.put('\u22c0', "bigwedge");
        preferredEntityNames.put('\u2240', "VerticalTilde");
        preferredEntityNames.put('\u21a0', "twoheadrightarrow");
        preferredEntityNames.put('\u03dc', "Gammad");
        preferredEntityNames.put('\u2a96', "eqslantgtr");
        preferredEntityNames.put('\u00af', "OverBar");
        preferredEntityNames.put('\u2292', "SquareSupersetEqual");
        preferredEntityNames.put('\u2018', "lsquo");
        preferredEntityNames.put('\u21f5', "DownArrowUpArrow");
        preferredEntityNames.put('\u210d', "quaternions");
        preferredEntityNames.put('\u2218', "compfn");
        preferredEntityNames.put('\u2192', "rarr");
        preferredEntityNames.put('\u21ab', "looparrowleft");
        preferredEntityNames.put('\u22e3', "NotSquareSupersetEqual");
        preferredEntityNames.put('\u210b', "HilbertSpace");
        preferredEntityNames.put('\u22e1', "NotSucceedsSlantEqual");
        preferredEntityNames.put('\u201c', "ldquo");
        preferredEntityNames.put('\ue208', "NotPrecedesEqual");
        preferredEntityNames.put('\u21a3', "rightarrowtail");
        preferredEntityNames.put('\u2296', "CircleMinus");
        preferredEntityNames.put('\u22d0', "Subset");
        preferredEntityNames.put('\u2196', "UpperLeftArrow");
        preferredEntityNames.put('\u2aba', "succnapprox");
        preferredEntityNames.put('\u2269', "gnE");
        preferredEntityNames.put('\u2257', "circeq");
        preferredEntityNames.put('\u21a7', "mapstodown");
        preferredEntityNames.put('\u22a2', "RightTee");
        preferredEntityNames.put('\u2118', "weierp");
        preferredEntityNames.put('\u210f', "hslash");
        preferredEntityNames.put('\u227d', "SucceedsSlantEqual");
        preferredEntityNames.put('\u221a', "Sqrt");
        preferredEntityNames.put('\u2241', "NotTilde");
        preferredEntityNames.put('\u22cc', "rightthreetimes");
        preferredEntityNames.put('\u219a', "nleftarrow");
        preferredEntityNames.put('\u22ba', "intercal");
        preferredEntityNames.put('[', "lsqb");
        preferredEntityNames.put('\u222e', "conint");
        preferredEntityNames.put('\u227f', "SucceedsTilde");
        preferredEntityNames.put('\u22a4', "DownTee");
        preferredEntityNames.put('\u226b', "gg");
        preferredEntityNames.put('\u232a', "rang");
        preferredEntityNames.put('\u2268', "lnE");
        preferredEntityNames.put('\u22e8', "precnsim");
        preferredEntityNames.put('\u212c', "bernou");
        preferredEntityNames.put('\u2207', "nabla");
        preferredEntityNames.put('\u2062', "InvisibleTimes");
        preferredEntityNames.put('\u2227', "and");
        preferredEntityNames.put('\u00a0', NBSP);
        preferredEntityNames.put('\u21c5', "UpArrowDownArrow");
        preferredEntityNames.put('\u2262', "NotCongruent");
        preferredEntityNames.put('\u21c7', "leftleftarrows");
        preferredEntityNames.put('\u21db', "Rrightarrow");
        preferredEntityNames.put('\u2225', "par");
        preferredEntityNames.put('\u22a5', "UpTee");
        preferredEntityNames.put('\u22d9', "Gg");
        preferredEntityNames.put('\u2232', "ClockwiseContourIntegral");
        preferredEntityNames.put('\u2130', "expectation");
        preferredEntityNames.put('\u2112', "Laplacetrf");
        preferredEntityNames.put('\u2264', "le");
        preferredEntityNames.put('\u21b0', "lsh");
        preferredEntityNames.put('\u2209', "notin");
        preferredEntityNames.put('\u22db', "GreaterEqualLess");
        preferredEntityNames.put('\u03f5', "epsilon");
        preferredEntityNames.put('\u2266', "lE");
        preferredEntityNames.put('\u222b', "int");
        preferredEntityNames.put('\u00a8', "Dot");
        preferredEntityNames.put('\u21b1', "rsh");
        preferredEntityNames.put('\u2a89', "lnapprox");
        preferredEntityNames.put('\u25b3', "triangle");
        preferredEntityNames.put('\u230a', "lfloor");
        preferredEntityNames.put('\u2294', "SquareUnion");
        preferredEntityNames.put('\u22b8', "multimap");
        preferredEntityNames.put('\u27e7', "robrk");
        preferredEntityNames.put(']', "rsqb");
        preferredEntityNames.put('\u2198', "LowerRightArrow");
        preferredEntityNames.put('\ue204', "ngE");
        preferredEntityNames.put('\u2205', "empty");
        preferredEntityNames.put('\u2203', "exist");
        preferredEntityNames.put('\u2666', "diamondsuit");
        preferredEntityNames.put('\u2145', "DD");
        preferredEntityNames.put('\u25aa', "blacksquare");
        preferredEntityNames.put('\u226e', "nlt");
        preferredEntityNames.put('\u2605', "bigstar");
        preferredEntityNames.put('\u2220', "ang");
        preferredEntityNames.put('\u2234', "therefore");
        preferredEntityNames.put('\u2270', "nle");
        preferredEntityNames.put('\u21ae', "nharr");
        preferredEntityNames.put('\u22d1', "Sup");
        preferredEntityNames.put('\u231f', "lrcorner");
        preferredEntityNames.put('\u03f1', "varrho");
        preferredEntityNames.put('\u200b', ZERO_WIDTH_SPACE);
        preferredEntityNames.put('\u21c9', "rightrightarrows");
        preferredEntityNames.put('\u21be', "RightUpVector");
        preferredEntityNames.put('\u223e', "mstpos");
        preferredEntityNames.put('\u25c0', "blacktriangleleft");
        preferredEntityNames.put('\u25c1', "triangleleft");
        preferredEntityNames.put('\u21d5', "DoubleUpDownArrow");
        preferredEntityNames.put('\u225f', "questeq");
        preferredEntityNames.put('\u22df', "curlyeqsucc");
        preferredEntityNames.put('\u2a8b', "lEg");
        preferredEntityNames.put('\u2035', "backprime");
        preferredEntityNames.put('\u2ab6', "scnE");
        preferredEntityNames.put('\u21c3', "LeftDownVector");
        preferredEntityNames.put('\u22b2', "LeftTriangle");
        preferredEntityNames.put('\u2275', "NotGreaterTilde");
        preferredEntityNames.put('\u25b7', "triangleright");
        preferredEntityNames.put('\u220b', "ReverseElement");
        preferredEntityNames.put('\u2289', "NotSupersetEqual");
        preferredEntityNames.put('\u22c4', "diamond");
        preferredEntityNames.put('\u231d', "urcorner");
        preferredEntityNames.put('\u223c', "Tilde");
        preferredEntityNames.put('\u03a5', "Upsilon");
        preferredEntityNames.put('\u211c', "real");
        preferredEntityNames.put('\u21c0', "RightVector");
        preferredEntityNames.put('\u2009', THIN_SPACE);
        preferredEntityNames.put('\u2a77', "ddotseq");
        preferredEntityNames.put('\u2273', "GreaterTilde");
        preferredEntityNames.put('\u2021', "Dagger");
        preferredEntityNames.put('\u2aaf', "PrecedesEqual");
        preferredEntityNames.put('e', "ExponentialE");
        preferredEntityNames.put('\u2124', "integers");
        preferredEntityNames.put('\u2221', "measuredangle");
        preferredEntityNames.put('\u00b1', "plusmn");
        preferredEntityNames.put('\u220f', "prod");
        preferredEntityNames.put('\u2238', "dotminus");
        preferredEntityNames.put('\u22ea', "NotLeftTriangle");
        preferredEntityNames.put('\u21cf', "nRightarrow");
        preferredEntityNames.put('*', "ast");
        preferredEntityNames.put('\u22ec', "NotLeftTriangleEqual");
        preferredEntityNames.put('\u224c', "backcong");
        preferredEntityNames.put('\u211a', "rationals");
        preferredEntityNames.put('\u2a85', "lessapprox");
        preferredEntityNames.put('\u229a', "circledcirc");
        preferredEntityNames.put('\u02dc', "tilde");
        preferredEntityNames.put('\u229e', "boxplus");
        preferredEntityNames.put('\u2277', "GreaterLess");
        preferredEntityNames.put('\u2271', "nge");
        preferredEntityNames.put('\u296f', "ReverseUpEquilibrium");
        preferredEntityNames.put('\u21c1', "DownRightVector");
        preferredEntityNames.put('\u2223', "VerticalBar");
        preferredEntityNames.put('\u22a0', "boxtimes");
        preferredEntityNames.put('\u2a87', "lne");
        preferredEntityNames.put('\u21cb', "ReverseEquilibrium");
        preferredEntityNames.put('\u2713', "checkmark");
        preferredEntityNames.put('\u00b8', "Cedilla");
        preferredEntityNames.put('\u22c2', "bigcap");
        preferredEntityNames.put('\u2248', "approx");
        preferredEntityNames.put('\u22c7', "divideontimes");
        preferredEntityNames.put('\u2287', "SupersetEqual");
        preferredEntityNames.put('|', "verbar");
        preferredEntityNames.put('\u21e5', "RightArrowBar");
        preferredEntityNames.put('\u00bd', "half");
        preferredEntityNames.put('\u22c6', "Star");
        preferredEntityNames.put('\u21bb', "circlearrowright");
        preferredEntityNames.put('\u21cd', "nLeftarrow");
        preferredEntityNames.put('\u2244', "NotTildeEqual");
        preferredEntityNames.put('\u21a6', "map");
        preferredEntityNames.put('\u21d2', "Implies");
        preferredEntityNames.put('\u224a', "approxeq");
        preferredEntityNames.put('\ue209', "NotSucceedsEqual");
        preferredEntityNames.put('\u2213', "mnplus");
        preferredEntityNames.put('\u21d4', "iff");
        preferredEntityNames.put('\u2928', "nesear");
        preferredEntityNames.put('\u2305', "barwedge");
        preferredEntityNames.put('\u22cd', "backsimeq");
        preferredEntityNames.put('\u2254', "Assign");
        preferredEntityNames.put('\u224f', "HumpEqual");
        preferredEntityNames.put('\u2193', "DownArrow");
        preferredEntityNames.put('\u2926', "swarhk");
        preferredEntityNames.put('\u2134', "order");
        preferredEntityNames.put('\u2290', "SquareSuperset");
        preferredEntityNames.put('\u2281', "NotSucceeds");
        preferredEntityNames.put('\u2128', "Zfr");
        preferredEntityNames.put('\u2a02', "bigotimes");
        preferredEntityNames.put('\u2190', "larr");
        preferredEntityNames.put('\u2a7e', "GreaterSlantEqual");
        preferredEntityNames.put('\u03c5', "upsilon");
        preferredEntityNames.put('\u21b7', "curvearrowright");
        preferredEntityNames.put('\u2200', "forall");
        preferredEntityNames.put('\u2283', "Superset");
        preferredEntityNames.put('\u2a04', "biguplus");
        preferredEntityNames.put('\u2ac6', "supE");
        preferredEntityNames.put('\u2ab7', "precapprox");
        preferredEntityNames.put('\u223d', "backsim");
        preferredEntityNames.put('\u2102', "complexes");
        preferredEntityNames.put('\u22b3', "RightTriangle");
        preferredEntityNames.put('\u227a', "Precedes");
        preferredEntityNames.put('\ue20d', "nsupE");
        preferredEntityNames.put('\u210c', "Poincareplane");
        preferredEntityNames.put('\u2256', "eqcirc");
        preferredEntityNames.put('\u201d', "rdquo");
        preferredEntityNames.put('\u21ac', "looparrowright");
        preferredEntityNames.put('\u219d', "rightsquigarrow");
        preferredEntityNames.put('\u225c', "triangleq");
        preferredEntityNames.put('\u228e', "UnionPlus");
        preferredEntityNames.put('\u2280', "NotPrecedes");
        preferredEntityNames.put('\u2acb', "subnE");
        preferredEntityNames.put('\u22e2', "NotSquareSubsetEqual");
        preferredEntityNames.put('\u21aa', "hookrightarrow");
        preferredEntityNames.put('\u266e', "natural");
        preferredEntityNames.put('\u2252', "fallingdotseq");
        preferredEntityNames.put('\ue203', "NotEqualTilde");
        preferredEntityNames.put('\u2ab9', "precnapprox");
        preferredEntityNames.put('\u2191', "UpArrow");
        preferredEntityNames.put('\u230b', "rfloor");
        preferredEntityNames.put('\u2197', "UpperRightArrow");
        preferredEntityNames.put('\u2500', "HorizontalLine");
        preferredEntityNames.put('\u2293', "SquareIntersection");
        preferredEntityNames.put('\u221d', "Proportional");
        preferredEntityNames.put('\u02d8', "breve");
        preferredEntityNames.put('\u0131', "imath");
        preferredEntityNames.put('\u22a1', "dotsquare");
        preferredEntityNames.put('\ue207', "NotLessSlantEqual");
        preferredEntityNames.put('\u227e', "PrecedesTilde");
        preferredEntityNames.put('\u21a4', "LeftTeeArrow");
        preferredEntityNames.put('\u2295', "CirclePlus");
        preferredEntityNames.put('\u2195', "UpDownArrow");
        preferredEntityNames.put('\ue205', "NotGreaterSlantEqual");
        preferredEntityNames.put('\u226a', "ll");
        preferredEntityNames.put('\u222f', "DoubleContourIntegral");
        preferredEntityNames.put('\u21a2', "leftarrowtail");
        preferredEntityNames.put('\u22cf', "curlywedge");
        preferredEntityNames.put('\u2297', "CircleTimes");
        preferredEntityNames.put('\u03d1', "vartheta");
        preferredEntityNames.put('\u222d', "tint");
        preferredEntityNames.put('\u226c', "between");
        preferredEntityNames.put('\u2110', "imagline");
        preferredEntityNames.put('\u2199', "LowerLeftArrow");
        preferredEntityNames.put('\u2019', "rsquo");
        preferredEntityNames.put('\u22a3', "LeftTee");
        preferredEntityNames.put('\u03d5', "phi");
        preferredEntityNames.put('\u22cb', "leftthreetimes");
        preferredEntityNames.put('\u2242', "EqualTilde");
        preferredEntityNames.put('\u2291', "SquareSubsetEqual");
        preferredEntityNames.put('\u00ae', "circledR");
        preferredEntityNames.put('d', "DifferentialD");
    }

    public static char getUnicodeCharacter(String string) {
        char c = '\u0000';
        if (spaceEntities.contains(string)) {
            c = ' ';
        } else if (nonMarkingEntities.contains(string)) {
            c = '\u0000';
        } else if (emptyEntities.contains(string)) {
            c = '\u0000';
        } else {
            String string2 = (String)entityNameMap.get(string);
            if (string2 != null && string2.length() == 1) {
                c = string2.charAt(0);
            }
        }
        return c;
    }

    public static String getUnicodeCharacterAsString(String string) {
        String string2 = "\u0000";
        string2 = spaceEntities.contains(string) ? " " : (nonMarkingEntities.contains(string) ? "\u0000" : (emptyEntities.contains(string) ? "\u0000" : (String)entityNameMap.get(string)));
        return string2;
    }

    public static boolean isNonMarkingEntity(String string) {
        return nonMarkingEntities.contains(string);
    }

    public static boolean isEmptyEntity(String string) {
        return emptyEntities.contains(string);
    }

    public static boolean isGreekLetter(char c) {
        return '\u0370' <= c && c <= '\u03ff';
    }

    public static boolean isMathEntity(char c) {
        return !RuntimeLocale.isGreek() && WmiMathEntityNameMapper.isGreekLetter(c) || WmiMathEntityNameMapper.checkRange(c, '\u00bc', '\u00be') || WmiMathEntityNameMapper.checkRange(c, '\u2000', '\u27ff') || WmiMathEntityNameMapper.checkRange(c, '\u2900', '\u2bff') || WmiMathEntityNameMapper.checkRange(c, '\ue201', '\ue20e') || WmiMathEntityNameMapper.checkRange(c, '\ue504', '\ue537') || WmiMathEntityNameMapper.checkRange(c, '\ue538', '\ue551') || WmiMathEntityNameMapper.checkRange(c, '\ue49c', '\ue4cf') || c == '\u00ac' || c == '\u00b1' || c == '\u00b7' || c == '\u00d7' || c == '\u00f7' || c == '\u300a' || c == '\u300b' || c == '\ufe37' || c == '\ufe38';
    }

    private static boolean checkRange(char c, char c2, char c3) {
        return c2 <= c && c <= c3;
    }

    public static String getEntityName(char c) {
        String string = (String)preferredEntityNames.get(c);
        if (string == null || string.length() == 0) {
            string = MathMLEntityMap.getMathMLName(c);
        }
        return string;
    }

    public static String getInternalDTDSubset() {
        return internalDTDSubset;
    }

    public static HashMap getDuplicateUnicodeMappings() {
        return entityNameMap.getDuplicateUnicodeMappings();
    }

    public static WmiUnicodeMapper getPreferredEntityMappings() {
        return preferredEntityNames;
    }

    private WmiMathEntityNameMapper() {
    }

    static {
        WmiMathEntityNameMapper.createSpaceMappings();
        WmiMathEntityNameMapper.createNonMarkingMappings();
        WmiMathEntityNameMapper.createEmptyMappings();
        WmiMathEntityNameMapper.createPreferredUnicodeMappings();
    }
}

