/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.encoder;

import com.maplesoft.util.encoder.AbstractStringEncoder;
import com.maplesoft.util.encoder.codepage.AbstractCodePage;

public class DefaultEncoder
extends AbstractStringEncoder {
    private static final char PUNCTUATION_LOWER_BOUND = '\u2000';
    private static final char PUNCTUATION_UPPER_BOUND = '\u206f';
    private static final char ASCII8 = '\u00ff';
    private static final char[] MINUS = new char[]{'\u2010', '\u2012', '\u2013'};
    private static final char[] SINGLE_QUOTE = new char[]{'\u2018', '\u2019', '\u201b', '\u2032'};
    private static final char[] DOUBLE_QUOTE = new char[]{'\u201c', '\u201d', '\u201f', '\u2033', '\u2036'};
    private static final char[] MISC_MAPPING = new char[]{'\u2024', '.', '\u201a', ',', '\u2035', '`', '\u2039', '<', '\u203a', '>', '\u204e', '*', '\u2052', '%', '\u2053', '~', '\u2044', '/'};

    public DefaultEncoder() {
        super("iso8859-1");
    }

    public String fromUnicode(String string) {
        boolean bl = false;
        int n = string.length();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c <= '\u00ff') {
                cArray[i] = c;
                continue;
            }
            bl = true;
            if (c >= '\u2000' && c <= '\u206f') {
                if (this.contains(MINUS, c)) {
                    c = '-';
                } else if (this.contains(SINGLE_QUOTE, c)) {
                    c = '\'';
                } else if (this.contains(DOUBLE_QUOTE, c)) {
                    c = '\"';
                } else {
                    for (int j = 0; j < MISC_MAPPING.length; j += 2) {
                        if (c != MISC_MAPPING[j]) continue;
                        c = MISC_MAPPING[j + 1];
                        break;
                    }
                }
            }
            cArray[i] = c;
        }
        return bl ? new String(cArray) : string;
    }

    public boolean contains(char[] cArray, char c) {
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected AbstractCodePage[] getCodePages() {
        return null;
    }

    public String toUnicode(String string) {
        return string;
    }

    public int getType() {
        return 0;
    }

    protected String[] getPageRefs() {
        return null;
    }
}

