/*
 * Decompiled with CFR 0.152.
 */
package applets.proctoredTest;

import applets.MessageUtilities;
import applets.util.WarningDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.util.Formatter;
import java.util.Locale;
import javax.swing.JApplet;
import javax.swing.JLabel;

public class Timer
extends JApplet {
    private static final long serialVersionUID = 845228335797500677L;
    Locale mtaLocale = new Locale("en", "US");
    private long remainingTime;
    Frame holderFrame = new Frame();
    private String displayCountdown = "";
    private JLabel theLabel = new JLabel("", 4);

    public void destroy() {
        this.holderFrame.dispose();
        this.holderFrame = null;
    }

    public void init() {
        String[] locale;
        try {
            locale = this.getParameter("mtalocale").split("_");
        }
        catch (Exception e) {
            locale = "en_US".split("_");
        }
        if (locale.length == 1) {
            this.mtaLocale = new Locale(locale[0]);
        } else if (locale.length == 2) {
            this.mtaLocale = new Locale(locale[0], locale[1]);
        } else if (locale.length == 3) {
            this.mtaLocale = new Locale(locale[0], locale[1], locale[2]);
        }
        this.remainingTime = Long.parseLong(this.getParameter("remainingTime"));
        this.setBackground(Color.white);
        this.setForeground(new Color(29, 54, 104));
        this.setLayout(new BorderLayout());
        this.setFont(new Font("SansSerif", 0, 10));
        this.theLabel.setOpaque(true);
        this.theLabel.setBackground(Color.white);
        this.add(this.theLabel);
    }

    private int getSeconds(long time) {
        int secNum = (int)(time % 3600L) % 60;
        return secNum;
    }

    private int getMinutes(long time) {
        int minNum = (int)(time % 3600L) / 60;
        return minNum;
    }

    private int getHours(long time) {
        int hourNum = (int)(time / 3600L);
        return hourNum;
    }

    public void start() {
        String fiveMinutesMessage = MessageUtilities.getMessage(this.mtaLocale, "Timer.FiveMinutesMessage");
        String expiredMessage = MessageUtilities.getMessage(this.mtaLocale, "Timer.ExpiredMessage");
        while (true) {
            int hours = this.getHours(this.remainingTime);
            int mins = this.getMinutes(this.remainingTime);
            int secs = this.getSeconds(this.remainingTime);
            Formatter formatter = new Formatter();
            this.displayCountdown = String.valueOf(MessageUtilities.getMessage(this.mtaLocale, "Common.RemainingTime.Label")) + formatter.format(" %1$02d:%2$02d:%3$02d", hours, mins, secs).toString();
            this.theLabel.setText(this.displayCountdown);
            this.repaint();
            if (this.remainingTime == 300L) {
                new WarningDialog(this.holderFrame, fiveMinutesMessage, this.mtaLocale).setVisible(true);
            } else if (this.remainingTime == 0L) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --this.remainingTime;
        }
        new WarningDialog(this.holderFrame, expiredMessage, this.mtaLocale).setVisible(true);
    }
}

