var	daFmt=Calendar._TT["DEF_DATE_FORMAT"]+" [%I:%M %p]";
	
function onLoad() {
	refreshInSessionMenu();
	setForceGradeAllowed();
	initDateControl();
}

function initDateControl() {	
	// Create a Calenar object
	window.calendar = new Calendar();
	window.calendar.showsTime = true;
	window.calendar.time24 = false;
	window.calendar.create(); 
}

function calInit(ifStr, daStr) {
	var displayArea = document.getElementById(daStr);
	var inputField = document.getElementById(ifStr);
	if (inputField && inputField.value) {
		var i = parseInt(inputField.value);
		if (i > 0) {
			var d = new Date(parseInt(inputField.value));
			displayArea.value = d.print(daFmt);
		}
	}
}

function setForceGradeAllowed() {
	var objEndDate = document.getElementById("endDatePresent");
	var enabled = objEndDate.checked;

	var objForceGrade = document.getElementById("forceGrade");
	
	if (!enabled) {
		objForceGrade.checked = false;
	}

	objForceGrade.disabled = !enabled;
}


function modeClicked(k) {
	if (k == 0) {
		document.AssignmentEditForm.startAuthorizationRequired.checked = true;
	} else {
		document.AssignmentEditForm.startAuthorizationRequired.checked = false;
	}
	if (k != 1) {
		document.AssignmentEditForm.reworkable.checked = false;
		document.AssignmentEditForm.printable.checked = false;
	}
}

function reworkableClicked() {
	if (document.AssignmentEditForm.reworkable.checked) {
		e = document.AssignmentEditForm.elements;
		for (i=0; i<e.length; i++) {
			v = e[i];
			if (v.name == "modeOrdinal" && v.value == 1) {
				v.checked = true;
				modeClicked(1);
			}
		}
	}
}

function printableClicked() {
	if (document.AssignmentEditForm.printable.checked) {
		e = document.AssignmentEditForm.elements;
		for (i=0; i<e.length; i++) {
			v = e[i];
			if (v.name == "modeOrdinal" && v.value == 1) {
				v.checked = true;
				modeClicked(1);
			}
		}
	}
}

function startAuthorizationRequiredClicked() {
	if (document.AssignmentEditForm.startAuthorizationRequired.checked) {
		e = document.AssignmentEditForm.elements;
		for (i=0; i<e.length; i++) {
			v = e[i];
			if (v.name == "modeOrdinal" && v.value == 0) {
				v.checked = true;
				modeClicked(0);
			}
		}
	}
}

  function inSessionGradeReportChanged() {
    if (document.AssignmentEditForm.inSessionGradeReported.checked) {
      var message = msgInSessionGradeReportedNote;
      alert(message);
    }
    refreshInSessionMenu();
  }
  
  function refreshInSessionMenu() {
    var f = document.AssignmentEditForm;
    var isInSessionGradeReported = f.inSessionGradeReported.checked;
    if (isInSessionGradeReported) {
      f.showInSessionAnswer.style.color = "black";
      f.showInSessionComment.style.color = "black";
    } else {
      f.showInSessionAnswer.style.color = "gray";
      f.showInSessionComment.style.color = "gray";
    }
  }
  
  function inSessionMenuChanged() {
    var f =  document.AssignmentEditForm;
    var checked = f.inSessionGradeReported.checked;
    if (! checked) {
      f.inSessionGradeReported.checked = true;
      inSessionGradeReportChanged();
    }
  }
  
function setSchedDate(elem, ifStr, daStr) {
	var inputField = document.getElementById(ifStr);
	var displayArea = document.getElementById(daStr);		
	if (!elem.checked) {
		inputField.value="";
		displayArea.value="";
	} else {
		var cal = window.calendar;
		inputField.value = cal.date.print("%s") + "000"; // Use milliseconds since Epoch
		displayArea.value = cal.date.print(daFmt);
	}
}

function emailNotifiedClicked() {
	var notifButt = document.AssignmentEditForm.emailNotified;
	var e = document.AssignmentEditForm.elements;
	if (! notifButt.checked) {
		return;
	}
	for (var i=0; i<e.length; i++) {
		v = e[i];
		if (v.name == "modeOrdinal" && v.checked && (v.value == 2 || v.value == 4)) {
			var yes = confirm(msgEmailNotificationWarning);
			if (! yes) {
				notifButt.checked = false;
			}
		}
	}
}

function clearClicked(date_if, date_da, datePresent) {
	document.getElementById(date_if).value='';
	document.getElementById(date_da).value='';
	document.getElementById(datePresent).checked=false;
}

// Event handler for when the popup button is clicked
function calOnClick(clicker, ifStr, daStr, chkbox, checked) {
	var cal = window.calendar;
	var inputField = document.getElementById(ifStr);
	var displayArea = document.getElementById(daStr);
	var myCheckBox = document.getElementById(chkbox);	
	var isChecked = (checked == 'true');

	// Event handler to perform when a date is selected.
	// Note that the action performed will target the 
	// inputField and displayArea of the selector that was
	// last clicked.
	cal.onSelected = function (cal, date) {
		//toggle the checkbox
		myCheckBox.checked = isChecked;
		inputField.value = cal.date.print("%s") + "000"; // Use milliseconds since Epoch
		displayArea.value = cal.date.print(daFmt);
		if (cal.dateClicked) {
			cal.hide(); // one-click behavior on date selection
		}
		setForceGradeAllowed();
	};

	// Event handler for when the calendar is closed. Since a shared
	// calendar is cached, merely hide it.
	cal.onClose = function (cal) {
		cal.hide();
	};

	// Set the calendar to the date carried by the form bean, if any
	if (inputField.value) {
		var i = parseInt(inputField.value);
		if (i > 0) {
			cal.setDate(new Date(i));
		} else {
			cal.setDate(new Date());
		}
	}
	cal.showAtElement(clicker, "Br");
	return false;
}

function mastery() {
	var e = document.AssignmentEditForm.elements;
	for (var i=0; i<e.length; i++) {
		v = e[i];
		if (v.name == "modeOrdinal" && v.value == 3) {
			if (v.checked) {
				doAction("EditMastery",TAB_SET_POLICIES_MASTERY);
			} else {
				if (confirm(msgMasteryEditWarning)) {
					v.checked = true;
					doAction("EditMastery",TAB_SET_POLICIES_MASTERY);
				} else {
					return;
				}
			}
		}
	}
}

function gradeFeedback() {
	doAction("EditGradeFeedback", TAB_SET_POLICIES_GRADE_FEEDBACK);
}

function customFeedback() {
	doAction("EditFeedback", TAB_SET_POLICIES_FEEDBACK);
}

function isPositiveInteger(v) {
	var s = "" + v;
	//don't accept 0 as a positive integer 
	if (s.charAt(0) == "0" && s.length == 1) {
		return false;
	}
	for (var i=0; i<s.length; i++) {
		var c = s.charAt(i);
		if (c < "0" || c > "9") {
			return false;
		}
	}
	return true;
}


  function onSubmit() {
    var f = document.AssignmentEditForm;

    if (f.passingScore.value.length > 0 && ! isPositiveInteger(f.passingScore.value)) {
      alert(msgPassingScoreRestrictions);
      return false;
    }

    if (f.timeLimit.value.length > 0 && ! isPositiveInteger(f.timeLimit.value)) {
      alert(msgTimeLimitRules);
      return false;
    }

    if (f.quPerPage.value.length == 0 || ! isPositiveInteger(f.quPerPage.value)) {
      alert(msgNumberOfQuestionsRules);
      return false;
    }
    
    if (f.quPerPage.value > 5) {
      var message = msgNumberOfQuestionsTooBig;
      if (! confirm(message)) {
        return false;
      }
    }

    var startStr = document.getElementById('startDate_if');
    var endStr = document.getElementById('endDate_if');
    if (startStr.value && endStr.value) {
       var startTime = parseInt(startStr.value);
       var endTime = parseInt(endStr.value);
       if (startTime > 0 && endTime > 0) {
	       if (endTime <= startTime) {
				endTime.value = startTime.value;
				document.getElementById("endDate_da").value = document.getElementById("startDate_da").value;
				alert(msgStartAndEndDates);
				return false;
			} else {
		       var FIVE_MIN = 300000;
	    	   var asgDur = endTime - startTime;
		       if (asgDur < FIVE_MIN) { 
	    	       var msg = msgAssignmentDurationTooSmall;
	       			if (! confirm(msg)) {
	       				return false;
		      		}
	    	   }      
	    	}
       	}
    }
    	
    return true;
  }
