<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<%-- Import the JSCalendar --%>
<style type="text/css">@import url(jscalendar-1.0/skins/aqua/theme.css);</style>
<script type="text/javascript" src="jscalendar-1.0/calendar.js"></script>
<script type="text/javascript" src="jscalendar-1.0/lang/calendar-en.js"></script>
<script type="text/javascript" src="jscalendar-1.0/lang/calendar-${MTA_LOCALE}-utf8.js"></script>
<script type="text/javascript" src="jscalendar-1.0/calendar-setup.js"></script>

<table>
	<tr>
		<td><fmt:message key="label.dateRangeStart"/></td>
		<td>
			<html:hidden property="dateRangeStart" styleId="dateRangeStart_if" />
			<input type="text" readonly="true" id="dateRangeStart_da" size="15">
			<img src="jscalendar-1.0/img.gif" id="dateRangeStart_trigger">
		</td>
		<td>
			<a href="#" onclick="clearDate('dateRangeStart_if','dateRangeStart_da');return false;"><fmt:message key="label.clear"/></a>
		</td>
	</tr>
	<tr>
		<td><fmt:message key="label.dateRangeEnd"/></td>
		<td>
			<html:hidden property="dateRangeEnd" styleId="dateRangeEnd_if" />
			<input type="text" readonly="true" id="dateRangeEnd_da" size="15">
			<img src="jscalendar-1.0/img.gif" id="dateRangeEnd_trigger">
		</td>
		<td>
			<a href="#" onclick="clearDate('dateRangeEnd_if','dateRangeEnd_da');return false;"><fmt:message key="label.clear"/></a>
		</td>
	</tr>
</table>

<script type="text/javascript">
	<%-- Simple i18n of date format --%>
	var daFmt=Calendar._TT["DEF_DATE_FORMAT"];
		
	// Create a Calenar object 
	// create this onload so that it works in IE, there is a known race condition
	// with timeouts in IE that throws exception if this is not created on page load
	window.onload=function() {
		window.calendar = new Calendar();
		window.calendar.create();
	}
	
	// When the page is loaded, use the epoch timestamp that was
	// provided by the form bean, if any, to initialize the display. 
	function calInit(ifStr, daStr) {
		var displayArea = document.getElementById(daStr);
		var inputField = document.getElementById(ifStr);
		
		if (inputField.value) {
			var i = parseInt(inputField.value);
			if (i > 0) {
				var d = new Date(parseInt(inputField.value));
				displayArea.value = d.print(daFmt);
			}
		}
	}
	calInit("dateRangeStart_if", "dateRangeStart_da");
	calInit("dateRangeEnd_if", "dateRangeEnd_da");
	
	// Event handler for when the popup button is clicked
	function calOnClick(clicker, ifStr, daStr) {
		var cal = window.calendar;
		var inputField = document.getElementById(ifStr);
		var displayArea = document.getElementById(daStr);
		
		// Event handler to perform when a date is selected.
		// Note that the action performed will target the 
		// inputField and displayArea of the selector that was
		// last clicked.
		cal.onSelected = function (cal, date) {
		
			inputField.value = cal.date.print("%s") + "000"; // Use milliseconds since Epoch
			displayArea.value = cal.date.print(daFmt);
		
			cal.hide(); // one-click behavior
		};
		
		// Event handler for when the calendar is closed. Since a shared
		// calendar is cached, merely hide it.
		cal.onClose = function (cal) {
			cal.hide();
		};
		
		// Set the calendar to the date carried by the form bean, if any
		if (inputField.value) {
			var i = parseInt(inputField.value);
			if (i > 0) {
				cal.setDate(new Date(i));
			} else {
				cal.setDate(new Date());
			}
		}
		cal.showAtElement(clicker);
	}
	
	function clearDate(ifStr, daStr) {
		var inputField = document.getElementById(ifStr);
		var displayArea = document.getElementById(daStr);
		inputField.value="";
		displayArea.value="";	
	}
	
	document.getElementById("dateRangeStart_trigger").onclick = function () {
		calOnClick(this, "dateRangeStart_if", "dateRangeStart_da");
	};
	
	document.getElementById("dateRangeEnd_trigger").onclick = function () {
		calOnClick(this, "dateRangeEnd_if", "dateRangeEnd_da");
	};
</script>
