<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@page import="com.maplesoft.mapleta.gbk.Constants"%>

<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic" %>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<script type="text/javascript" src="<%= request.getContextPath() %>/modules/classEditor/scripts.js"></script>

<tiles:useAttribute name="gradesTable"/>
<tiles:useAttribute name="quGroup" ignore="true"/>

<c:set var="module"><%= request.getContextPath() %></c:set>
<c:set var="NUMERIC" value="<%= new Integer(Constants.NUMERIC_CODE) %>" scope="page"/>
<c:set var="LETTER" value="<%= new Integer(Constants.LETTER_CODE) %>" scope="page"/>
<c:set var="PERCENTAGE" value="<%= new Integer(Constants.PERCENTAGE_CODE) %>" scope="page"/>
<c:set var="IN_PROGRESS" value="<%= Constants.ACTIVE_ASGN_CODE %>" scope="page"/>

<c:set var="SORT_GRADE"><%= Constants.SORT_GRADE %></c:set>
<c:set var="SORT_GRADE_DESC"><%= Constants.SORT_GRADE_DESC %></c:set>
<c:set var="SORT_TOTAL"><%= Constants.SORT_TOTAL %></c:set>
<c:set var="SORT_TOTAL_DESC"><%= Constants.SORT_TOTAL_DESC %></c:set>
<c:set var="AVG"><%= Constants.AVG_CODE %></c:set>

<logic:messagesPresent>
<br/>
<html:messages id="msg" message="false">
	<span class="errorStyle1"><c:out value='${msg}' escapeXml="false"/></span>
	<br>
</html:messages>
</logic:messagesPresent>
<br/>
<em class=divider><fmt:message key="label.grades.assignment"/>: ${gradesTable.assignment.name}
<c:if test="${not empty quGroup}"> - Question ${quGroup+1}</c:if>
</em>

<c:choose>
<c:when test="${not empty quGroup}">
	<input type="hidden" id="refreshView" value="refresh.qugroup"/>
</c:when>
<c:otherwise>
	<input type="hidden" id="refreshView" value="refresh.assignment"/>
</c:otherwise>
</c:choose>
<br/>

<c:choose>
<c:when test="${fn:length(viewSearchForm.assignmentSelection) <= 0 && fn:length(viewSearchForm.externalSelection) <= 0 }">
<div>
	<em class="title"><fmt:message key="ViewSearchForm.noassigments.msg"/></em>
</div>
</c:when>
<c:otherwise>

<tiles:insert definition=".gbk.assignment.info"/>
<br/>
<c:set var="total" value="0"/>

<!-- ** put the Labels onto the screen ** -->

<!-- ** put the Labels onto the screen ** -->
<tiles:insert definition=".gbk.page.labels">
	<tiles:put name="gradesTable" beanName="gradesTable"/>
</tiles:insert>

<table class="gradesTable" cellpadding="0" cellspacing="0">
	<thead>
		<tr class="asgnHeader">

			<c:if test="${viewSearchForm.showExtraData || viewSearchForm.showClassName}"><td class="invisible">&nbsp;</td></c:if>
			<c:if test="${viewSearchForm.showUid}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showLastName}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showMi}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showGivenName}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showEmail}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showStudentId}"><td class="invisible"></td></c:if>

			<c:if test="${viewSearchForm.showStartTime || viewSearchForm.showStartDate || viewSearchForm.showEndTime || 
						viewSearchForm.showEndDate || viewSearchForm.showNumAttempts || viewSearchForm.showDuration}">
				<td class="invisible"></td>
			</c:if>

		<c:forEach var="header1" items="${gradesTable.headers}">
			<td class="asgnGradeColumn yellow">
			<c:choose>
				<c:when test="${header1.questionGroup}">
					<a class="header gradeColumn" href="javascript:action('QGroup','quGroup=${header1.id}&')" title="${header1.title}">
						${header1.shortName}<fmt:message key="label.decorator.questionGroup"/>
					</a>
				</c:when>
				<c:otherwise>
					<a class="header" href="javascript:displayQuestion(${header1.qid});" title="${header1.title}">
						<img class="question" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/preview.gif" title="<fmt:message key='QuestionRepositoryActionForm.preview.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.preview.title'/>"/>
					</a>
					<a href="javascript:action('QuestionDetails','assignmentSelection=${viewSearchForm.singleAssignmentSelection}&quGroup=${header1.qGroup}&quRef=${header1.qRef}');" title="${header1.title}">
						${header1.shortName}
					<%--<fmt:message key="label.responses.all"/>--%>
					</a>
				</c:otherwise>
			</c:choose>
			</td>
		</c:forEach>
			<td></td>
		</tr>

		<tr class="header">
		<c:if test="${viewSearchForm.showExtraData && not viewSearchForm.showClassName}">
			<td>&nbsp;</td>
		</c:if>

			<!-- ** user data headers ** -->
<tiles:insert definition=".gbk.common.userheaders"/>

	<c:if test="${viewSearchForm.showStartTime || viewSearchForm.showStartDate || viewSearchForm.showEndTime || 
				viewSearchForm.showEndDate || viewSearchForm.showNumAttempts || viewSearchForm.showDuration}">
		<td>
		<table class="gradeData" cellpadding="0" cellspacing="0">					
			<tr>
		
		<tiles:insert definition=".gbk.common.gradeDataHeader">
			<tiles:put name="id" value="0"/>
		</tiles:insert>
			</tr>
		</table>
		</td>
	</c:if>

	<c:forEach var="header1" items="${gradesTable.headers}" varStatus="c">

	
			<c:set var="id">${header1.id}</c:set>
			<c:choose>
				<c:when test="${viewSearchForm.sort eq SORT_GRADE && viewSearchForm.sortId == id}">
					<td class="asgnGradeColumn sorted borderLeft">
						<a class="sort sorted" href="javascript:sortGrade('${SORT_GRADE_DESC}','${header1.id}')"><fmt:message key="label.grade"/></a>
					</td>
				</c:when>
				<c:when test="${viewSearchForm.sort eq SORT_GRADE_DESC && viewSearchForm.sortId == id}">
					<td class="asgnGradeColumn sorted borderLeft">
						<a class="sort sorted" href="javascript:sortGrade('${SORT_GRADE}','${header1.id}')"><fmt:message key="label.grade"/></a>
					</td>
				</c:when>
				<c:otherwise>
					<td class="asgnGradeColumn borderLeft">
						<a class="sort" href="javascript:sortGrade('${SORT_GRADE}','${header1.id}')"><fmt:message key="label.grade"/></a>
					</td>
				</c:otherwise>
			</c:choose>
<%--
			<td class="asgnGradeColumn"><a class="sort" href="javascript:sort('${header1.id}')"><fmt:message key="label.grade"/></a></td>
--%>
	</c:forEach>
		
			<!-- ** total header ** -->
			<c:choose>
				<c:when test="${viewSearchForm.sort eq SORT_TOTAL}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_TOTAL_DESC %>')"><fmt:message key="label.total"/></a></td>
				</c:when>
				<c:when test="${viewSearchForm.sort eq SORT_TOTAL_DESC}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_TOTAL %>')"><fmt:message key="label.total"/></a></td>
				</c:when>
				<c:otherwise>
					<td class="total totalHeader"><a class="sort" href="javascript:sort('<%= Constants.SORT_TOTAL %>')"><fmt:message key="label.total"/></a></td>
				</c:otherwise>
			</c:choose>
		</tr>		
	</thead>
	<tbody>
	
<c:if test="${viewSearchForm.showExtraData}">
	<tiles:insert definition=".gbk.common.extraData">
		<tiles:put name="gradesTable" beanName="gradesTable"/>
		<tiles:put name="showGradeData" value="true"/>
		<tiles:put name="alwaysShowTotals" value="true"/>
	</tiles:insert>
</c:if>

<c:set var="lastId" value="0"/>
<c:forEach var="gradeLine" items="${gradesTable.gradeLines}" varStatus="c">
	<c:set var="maxAttempts">${gradeLine.maxAttempts}</c:set>

	<c:set var="rowClass">
		<c:choose>
			<c:when test="${c.count mod 2 == 0}">even</c:when>
			<c:otherwise>odd</c:otherwise>
		</c:choose>
	</c:set>
		<tr class="${rowClass}">
	<c:choose>
		<c:when test="${viewSearchForm.showClassName}"><td class="top className"><span class="className">${gradeLine.className}</span></td></c:when>	
		<c:when test="${viewSearchForm.showExtraData}"><td></td></c:when>
	</c:choose>
	<c:choose>
		<c:when test="${lastId != gradeLine.user.id}">
			<c:if test="${viewSearchForm.showUid}"><td class="top userInfo"><a class="block userLink" href="javascript:action('User','userId=${gradeLine.user.uid}')">${gradeLine.user.uid}</a></td></c:if>
			<c:if test="${viewSearchForm.showLastName}"><td class="top userInfo"><a class="block userLink" href="javascript:action('User','userId=${gradeLine.user.uid}')">${gradeLine.user.sn}</a></td></c:if>
			<c:if test="${viewSearchForm.showMi}"><td class="top userInfo"><a class="block userLink" href="javascript:action('User','userId=${gradeLine.user.uid}')">${gradeLine.user.mi}</a></td></c:if>
			<c:if test="${viewSearchForm.showGivenName}"><td class="top userInfo"><a class="block userLink" href="javascript:action('User','userId=${gradeLine.user.uid}')">${gradeLine.user.givenName}</a></td></c:if>
			<c:if test="${viewSearchForm.showEmail}"><td class="top userInfo"><a class="block userLink" href="javascript:action('User','userId=${gradeLine.user.uid}')">${gradeLine.user.email}</a></td></c:if>
			<c:if test="${viewSearchForm.showStudentId}"><td class="top userInfo"><a class="block userLink" href="javascript:action('User','userId=${gradeLine.user.uid}')">${gradeLine.user.studentID}</a></td></c:if>		
		</c:when>
		<c:otherwise>
			<c:if test="${viewSearchForm.showUid}"><td class="top userInfo"></td></c:if>
			<c:if test="${viewSearchForm.showLastName}"><td class="top userInfo"></td></c:if>
			<c:if test="${viewSearchForm.showMi}"><td class="top userInfo"></td></c:if>
			<c:if test="${viewSearchForm.showGivenName}"><td class="top userInfo"></td></c:if>
			<c:if test="${viewSearchForm.showEmail}"><td class="top userInfo"></td></c:if>
			<c:if test="${viewSearchForm.showStudentId}"><td class="top userInfo"></td></c:if>		
		</c:otherwise>
	</c:choose>

	<c:if test="${viewSearchForm.showStartTime || viewSearchForm.showStartDate || viewSearchForm.showEndTime || 
				viewSearchForm.showEndDate || viewSearchForm.showNumAttempts || viewSearchForm.showDuration}">
	<c:choose>
		<c:when test="${empty gradeLine.data}">
		<td class="start">
			<fmt:message key="label.decorator.number.empty"/>
		</c:when>
		<c:otherwise>
		<td>
			<table class="gradeData" cellpadding="0" cellspacing="0">					
				<c:set var="attempt">0</c:set>
			<c:forEach var="data" items="${gradeLine.data}">	
				<tr>
					<tiles:insert definition=".gbk.common.gradeData">
						<tiles:put name="grade" beanName="data"/>
						<tiles:put name="attempt" value="${attempt}"/>
						<tiles:put name="attempts" value="1"/>
					</tiles:insert>
				</tr>
				<c:set var="attempt">${attempt+1}</c:set>
			</c:forEach>
			</table>
		</c:otherwise>
	</c:choose>	
		</td>
	</c:if>
		<c:forEach var="gradeWrapper" items="${gradeLine.grades}">
			<c:set var="attempts">${fn:length(gradeWrapper.grades)}</c:set>
			<c:set var="attempt">0</c:set>

			<td class="borderLeft">			

<table class="gradeData" cellpadding="0" cellspacing="0">					

			<c:forEach var="grade" items="${gradeWrapper.grades}">
	<tr>
				<c:set var="styleClass"><c:if test="${attempt > 0}">extraAttempt</c:if></c:set>
				
			<c:choose>
				<c:when test="${grade.emptyGrade}"><td class="${styleClass}" id="grade${grade.id}"></c:when>
				<c:otherwise><td class="${styleClass}" id="grade${grade.id}"  title="${grade.grade}/${grade.total}"></c:otherwise>
			</c:choose>

				<c:choose>
					<c:when test="${grade.emptyGrade}">
						<fmt:message key="label.decorator.number.empty"/>
					</c:when>
					<c:when test="${viewSearchForm.gradingStyle == PERCENTAGE}">
						<c:choose>
							<c:when test="${viewSearchForm.resultType != AVG}">
								<a class="grade" href="javascript:action('QuestionDetails','assignmentSelection=${viewSearchForm.singleAssignmentSelection}&quGroup=${grade.quGroup}&quRef=${grade.quRef}&uid=${gradeLine.user.uid}');">
									${grade.percent}
									<c:if test="${viewSearchForm.active == IN_PROGRESS && not grade.emptyGrade}"><fmt:message key="label.decorator.number.inProgress"/></c:if>
								</a>
							</c:when>
							<c:otherwise>
								${grade.percent}
								<c:if test="${viewSearchForm.active == IN_PROGRESS && not grade.emptyGrade}"><fmt:message key="label.decorator.number.inProgress"/></c:if>
							</c:otherwise>
						</c:choose>
					</c:when>
					<c:when test="${viewSearchForm.gradingStyle == LETTER}">
						<c:choose>
							<c:when test="${viewSearchForm.resultType != AVG}">
								<a class="grade" href="javascript:action('QuestionDetails','assignmentSelection=${viewSearchForm.singleAssignmentSelection}&quGroup=${grade.quGroup}&quRef=${grade.quRef}&uid=${gradeLine.user.uid}');">
									${grade.letter}
									<c:if test="${viewSearchForm.active == IN_PROGRESS && not grade.emptyGrade}"><fmt:message key="label.decorator.number.inProgress"/></c:if>
								</a>
							</c:when>
							<c:otherwise>
								${grade.letter}
								<c:if test="${viewSearchForm.active == IN_PROGRESS && not grade.emptyGrade}"><fmt:message key="label.decorator.number.inProgress"/></c:if>
							</c:otherwise>
						</c:choose>
					</c:when>
					<c:otherwise>
						<c:choose>
							<c:when test="${viewSearchForm.resultType != AVG}">
								<a class="grade" href="javascript:action('QuestionDetails','assignmentSelection=${viewSearchForm.singleAssignmentSelection}&quGroup=${grade.quGroup}&quRef=${grade.quRef}&uid=${gradeLine.user.uid}');">
									${grade}
									<c:if test="${viewSearchForm.active == IN_PROGRESS && not grade.emptyGrade}"><fmt:message key="label.decorator.number.inProgress"/></c:if>
								</a>
							</c:when>
							<c:otherwise>
								${grade}
								<c:if test="${viewSearchForm.active == IN_PROGRESS && not grade.emptyGrade}"><fmt:message key="label.decorator.number.inProgress"/></c:if>
							</c:otherwise>
						</c:choose>
					</c:otherwise>
				</c:choose>
				</td>
				<c:set var="attempt">${attempt+1}</c:set>
	</tr>				
			</c:forEach>
</table>
			<c:set var="diff">${maxAttempts-attempts}</c:set>

			<c:if test="${diff >= 0}">		
				<c:forEach begin="1" end="${diff}">
					<c:set var="styleClass"><c:if test="${attempt > 0}">extraAttempt</c:if></c:set>
					<span class="block ${styleClass}"><fmt:message key="label.decorator.number.empty"/></span>
					<c:set var="attempt">${attempt+1}</c:set>
				</c:forEach>
			</c:if>
			</td>			
		</c:forEach>


	<c:set var="attempt">0</c:set>
	<c:set var="attempts">${fn:length(gradeLine.totals)}</c:set>
		<td class="total">

<table class="gradeData" cellpadding="0" cellspacing="0">					
			<c:forEach var="grade" items="${gradeLine.totals}" varStatus="c">
	<tr>
				<c:set var="styleClass"><c:if test="${attempt > 0}">extraAttempt</c:if></c:set>
			<c:choose>
				<c:when test="${grade.emptyGrade}"><td class="block ${styleClass}" id="grade${grade.id}"></c:when>
				<c:otherwise><td class="block ${styleClass}" id="grade${grade.id}"  title="${grade.grade}/${grade.total}"></c:otherwise>
			</c:choose>
				<c:choose>
					<c:when test="${grade.emptyGrade}">
						<fmt:message key="label.decorator.number.empty"/>
					</c:when>
					<c:when test="${viewSearchForm.gradingStyle == PERCENTAGE}">
						${grade.percent}
					</c:when>
					<c:when test="${viewSearchForm.gradingStyle == LETTER}">
						${grade.letter}
					</c:when>
					<c:otherwise>
						<fmt:formatNumber maxFractionDigits="2" value="${grade.grade}"/>
					</c:otherwise>
				</c:choose>
				<c:if test="${viewSearchForm.active == IN_PROGRESS && not grade.emptyGrade}"><fmt:message key="label.decorator.number.inProgress"/></c:if>
				</td>
				<c:set var="attempt">${attempt+1}</c:set>
		</tr>
			</c:forEach>
	</table>
			<c:set var="diff">${maxAttempts-attempts}</c:set>		
			<c:if test="${diff >= 0}">		
				<c:forEach begin="1" end="${diff}">
					<c:set var="styleClass"><c:if test="${attempt > 0}">extraAttempt</c:if></c:set>
					<span class="block ${styleClass}"><fmt:message key="label.decorator.number.empty"/></span>
					<c:set var="attempt">${attempt+1}</c:set>
				</c:forEach>
			</c:if>
		</td>				
	
		</tr>
<c:set var="lastId">${gradeLine.user.id}</c:set>
</c:forEach>
	</tbody>

</table>

<!-- ** put the Labels onto the screen ** -->
<tiles:insert definition=".gbk.page.labels">
	<tiles:put name="gradesTable" beanName="gradesTable"/>
</tiles:insert>

</c:otherwise>
</c:choose>
