<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ page import="com.maplesoft.mapleta.qbeditor.repository.Questions.struts.actionform.QuestionSearchActionForm" %>

<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>

<tiles:useAttribute name="action"/>

<c:set var="searchByGroups"><%=QuestionSearchActionForm.SEARCH_BY_GROUPS%></c:set>
<c:set var="searchByAuthors"><%=QuestionSearchActionForm.SEARCH_BY_AUTHORS%></c:set>
<c:set var="searchByKeyword"><%=QuestionSearchActionForm.SEARCH_BY_KEYWORD%></c:set>
<c:set var="searchByModes"><%=QuestionSearchActionForm.SEARCH_BY_MODE%></c:set>
<c:set var="searchByTree"><%=QuestionSearchActionForm.SEARCH_BY_TREE%></c:set>
<c:set var="publicSearch"><%=QuestionSearchActionForm.PUBLIC_SEARCH%></c:set>
<c:set var="privateSearch"><%=QuestionSearchActionForm.PRIVATE_SEARCH%></c:set>

<c:set var="orderByName"><%= QuestionSearchActionForm.ORDER_BY_NAME %></c:set>
<c:set var="orderByAuthor"><%= QuestionSearchActionForm.ORDER_BY_AUTHOR %></c:set>
<c:set var="orderByCreated"><%= QuestionSearchActionForm.ORDER_BY_CREATED %></c:set>
<c:set var="orderByMode"><%= QuestionSearchActionForm.ORDER_BY_MODE %></c:set>
<c:set var="orderByModified"><%= QuestionSearchActionForm.ORDER_BY_MODIFIED %></c:set>

<c:set var="stringPublic" value="Public"/>
<c:set var="stringPrivate" value="Private" />

<fmt:bundle	basename="com.maplesoft.mapleta.application.ApplicationResources">

<script>
function refresh() {
	document.QuestionRepositoryForm.action='qbeditor/${action}Pager.do';
	document.QuestionRepositoryForm.submit();
}
</script>


<html:form action="/${action}Questions.do">
<!-- 
<html:hidden styleId="searchBy" property="searchBy"/>
<html:hidden styleId="searchFor" property="searchFor"/>
 -->

<c:choose>
	<c:when test="${action == stringPublic}">
		<a href="<%= request.getContextPath() %>/qbeditor/PrivateQuestions.do?searchBy=search.groups&searchFor=search.private"><fmt:message key="QuestionRepositoryActionForm.private_questions.label"/></a>
		&nbsp;|&nbsp; 
		<strong><fmt:message key="QuestionRepositoryActionForm.public_questions.label"/></strong>
	</c:when>
	<c:otherwise>
		<strong><fmt:message key="QuestionRepositoryActionForm.private_questions.label"/></strong>
		&nbsp;|&nbsp; 
		<a href="<%= request.getContextPath() %>/qbeditor/PublicQuestions.do?searchBy=search.authors&searchFor=search.public"><fmt:message key="QuestionRepositoryActionForm.public_questions.label"/></a>
	</c:otherwise>
</c:choose>

<div style="padding-top: 5px;">
<tiles:insert attribute="content" flush="false"/>
</div>

<table>
<tr>
	<td class="info"><fmt:message key="QuestionRepositoryActionForm.questionsPerPage.label"/></td>
	<td>
	<%--
		<html:text property="questionsPerPage" size="1"></html:text>
		--%>
		<html:select property="questionsPerPage">
			<html:option value="0"><fmt:message key="Search.All.Label" /></html:option>
		<c:forEach var="option" begin="5" end="100" step="5">
			<html:option value="${option}">${option}</html:option>
		</c:forEach>
		<c:forEach var="option" begin="200" end="1000" step="100">
			<html:option value="${option}">${option}</html:option>
		</c:forEach>
		</html:select>
		<a href="javascript:refresh();"><fmt:message key="Search.Refresh.Label" /></a>
	</td>
</tr>
<tr>
	<td><fmt:message key="QuestionRepositoryActionForm.orderBy.label"/></td>
	<td colspan="1">
		<html:select property="orderBy">
			<html:option value="${orderByName}"><fmt:message key="QuestionRepositoryActionForm.name.label"/></html:option>
			<html:option value="${orderByAuthor}"><fmt:message key="QuestionRepositoryActionForm.author.label"/></html:option>
			<html:option value="${orderByCreated}"><fmt:message key="QuestionRepositoryActionForm.created.label"/></html:option>
			<html:option value="${orderByModified}"><fmt:message key="QuestionRepositoryActionForm.modified.label"/></html:option>
			<html:option value="${orderByMode}"><fmt:message key="QuestionRepositoryActionForm.modeDescription.label"/></html:option>
		</html:select>
		<a href="javascript:refresh();"><fmt:message key="Search.Refresh.Label" /></a>
	</td>
</tr>
<tr>
	<td colspan="2"><html:submit styleClass="button"><fmt:message key="QuestionRepositoryActionForm.search.label"/></html:submit></td>
</tr>
</table>

</html:form>

</fmt:bundle>
