<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>

<tiles:useAttribute name="menu" ignore="true" />
<tiles:useAttribute name="menu_id" ignore="true" />
<tiles:useAttribute name="assignmentMenu" ignore="true" />

<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">

	<table class="menubar" id="${menu_id}">
		<tr>
			<c:forEach var="item" items="${menu}" varStatus="status">
				<td class="menuitem" name="${item.label}" nowrap="nowrap">
					<c:choose>
						<c:when test="${item.disabled}">
							<c:set var="element_class" value="disabled" />
						</c:when>
						<c:otherwise>
							<c:set var="element_class" value="enabled" />
						</c:otherwise>
					</c:choose>

						<div name="${element_class}" class="${element_class}" 
							<c:if test="${!assignmentMenu}"> onmouseover="hover(this);" onmouseout="hoverOff(this);" </c:if> >

						<c:choose>
							<c:when test="${empty item.url || item.disabled}">
								<c:if test="${assignmentMenu}"><span class="disabled"></c:if>
								<fmt:message key="${item.label}" />
								<c:if test="${assignmentMenu}"></span></c:if>
							</c:when>
							<c:otherwise>
								<a style="text-decoration:none;" href="${item.url}" 
									<c:if test="${assignmentMenu}">class="disabled" onclick="return false;"</c:if> >
								<fmt:message key="${item.label}" /> </a>
							</c:otherwise>
						</c:choose>
						<c:if test="${item.parent && !item.disabled}">
							<div class="subMenu1">
								<div class="subMenu2">
									<tiles:insert page="/WEB-INF/tiles/mainMenu/subMenu.jsp"
										flush="false">
										<tiles:put name="subItems" beanName="item"
											beanProperty="subItems" />
									</tiles:insert>
								</div>
							</div>
						</c:if>
					</div>
				</td>
				<td width="10px">&nbsp;</td>
			</c:forEach>
		</tr>
	</table>

</fmt:bundle>
