<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>

<%@ page import="com.maplesoft.mapleta.proctor.Constants"%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>

<%-- Import the JSCalendar --%>
<style type="text/css">
@import url(jscalendar-1.0/skins/aqua/theme.css);
</style>
<script type="text/javascript" src="jscalendar-1.0/calendar.js"></script>
<script type="text/javascript" src="jscalendar-1.0/lang/calendar-en.js"></script>
<script type="text/javascript" src="jscalendar-1.0/lang/calendar-${MTA_LOCALE}-utf8.js"></script>
<script type="text/javascript" src="jscalendar-1.0/calendar-setup.js"></script>


<c:set scope="page" var="AUTHORIZE_STUDENT"
	value="<%=Integer.valueOf(Constants.ProctorAction.AUTHORIZE_STUDENT
					.getMode())%>" />


<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">

	<c:set var="uid">
		<fmt:message key="UserAdmin.uid.label" />
	</c:set>
	<c:set var="firstname">
		<fmt:message key="UserAdmin.firstname.label" />
	</c:set>
	<c:set var="lastname">
		<fmt:message key="UserAdmin.lastname.label" />
	</c:set>
	<c:set var="email">
		<fmt:message key="UserAdmin.email.label" />
	</c:set>
	<c:set var="studentID">
		<fmt:message key="UserAdmin.studentID.label" />
	</c:set>

</fmt:bundle>
<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">

	<c:set var="select_assignment">
		<fmt:message key="ProctorToolsActionForm.assignment.select.msg" />
	</c:set>
	<c:set var="select_student">
		<fmt:message key="ProctorToolsActionForm.student.select.msg" />
	</c:set>
	<c:set var="authorize_button">
		<fmt:message key="ProctorToolsActionForm.authorize.button" />
	</c:set>
	<c:set var="authorize_toggle">
		<fmt:message key="ProctorToolsActionForm.authorize.label" />
	</c:set>
	<c:set var="asgn_chooser_label">
		<fmt:message key="ProctorToolsActionForm.assignment.authorize.label" />
	</c:set>
	<c:set var="permission_chooser_label">
		<fmt:message key="ProctorToolsActionForm.assignment.permission.label" />
	</c:set>
	<c:set var="permission_flag_label">
		<fmt:message
			key="ProctorToolsActionForm.assignment.permission.permission.flag.label" />
	</c:set>
	<c:set var="assignment_name_label">
		<fmt:message key="ProctorToolsActionForm.assignment.label" />
	</c:set>
	<c:set var="time_limit_label">
		<fmt:message key="ProctorToolsActionForm.time_limit.label" />
	</c:set>
	<c:set var="end_time_label">
		<fmt:message key="ProctorToolsActionForm.end_time.label" />
	</c:set>
</fmt:bundle>

<a href="#" onClick="toggleItem('search'); this.blur(); return false;">
	<span class="toggle"> <img
		src="modules/configureClasses/images/closeDirIcon.gif" border="0"
		id="searchTwisty"> <fmt:bundle
			basename="com.maplesoft.mapleta.application.ApplicationResources">
			<fmt:message key="ProctorToolsActionForm.student.search.panel.label" />
		</fmt:bundle>
</span>
</a>

<div class="search" id="searchTable">
	<tiles:insert definition=".user.search" flush="false" />
</div>
<script>
	initTwisty();
</script>

<script>
	var submitted = 0;

	function doAuthorize() {
		if (submitted != 0) {
			return false;
		}
		submitted = 1;

		var form = document.getElementById("authForm");
		var asgnChooserObj = form.assignmentSelection;
		if (asgnChooserObj) {
			if (!(asgnChooserObj.options[asgnChooserObj.selectedIndex].value > 0)) {
				alert("${select_assignment}");
				submitted = 0;
				return false;
			}
		}
		var els = document.getElementsByName("selectedItems");
		for ( var i = 0; i < els.length; i++) {
			if (els[i].checked == true) {
				doSubmit();
				return true;
			}
		}

		submitted = 0;
		alert("${select_student}");
	}

	function doSubmit() {
		document.getElementById("authForm").submit();
		return true;
	}
</script>

<script
	src="<%=request.getContextPath()%>/modules/scripts/proctorTools.js"></script>

<html:form action="/ProctorAuthorize" method="post" styleId="authForm">

	<html:hidden property="dispatch" />

	<c:if test="${(fn:length(users) > 0)}">

		<bean:define id="authorize_toggle" toScope="page">
			<input type="checkbox" onclick="selectAllItems(this);" id="selectAll" />
			<label for="selectAll">&nbsp;${authorize_toggle}</label>
		</bean:define>






		<h2>${asgn_chooser_label}</h2>



		<%-- If the user has performed a search with an asgn filter, set it as the asgn to authorize --%>
		<c:choose>
			<c:when test="${!empty ProctorActionForm.assignmentName}">
				<html:hidden property="asgn_id" />
						${ProctorActionForm.assignmentName}
					</c:when>
			<c:otherwise>
				<tiles:insert definition=".proctor.assignment.chooser" flush="false">
					<tiles:put name="showReset" value="false" />
				</tiles:insert>
			</c:otherwise>
		</c:choose>


		
		<tiles:insert definition=".proctor.permission.chooser" flush="false" />


		<p>
			<html:button property="authorize" styleClass="button"
				value="${authorize_button}" onclick="doAuthorize();" />
		</p>


		<logic:present name="users">
			<display:table id="row" name="${users}" defaultsort="1"
				requestURI="/proctor/ProctorTools.do" pagesize="${pageLimit}"
				class="simple" sort="list">

				<%@ include file="/WEB-INF/jsp/displaytag_defaultProperties.jsp"%>

				<display:setProperty name="paging.banner.placement" value="bottom" />

				<display:column title="${authorize_toggle}">
					<html:multibox property="selectedItems" value="${row.id}" />
				</display:column>
				<display:column title="${uid}" sortable="true">
					<html:link action="/UserInfo.do?uid=${row.uid}">${row.uid}</html:link>
				</display:column>
				<display:column property="givenName" sortable="true"
					title="${firstname}" />
				<display:column property="sn" sortable="true" title="${lastname}" />
				<display:column property="email" sortable="true" title="${email}" />
				<display:column property="studentID" sortable="true"
					title="${studentID}" />
				<%-- 			<display:column property="permissionFlagDescription" sortable="true" title="${permission_flag_label}" /> --%>
				<display:column sortable="true" title="${permission_flag_label}">
					<c:choose>
						<c:when test="${row.permissionMode == 1}">
							<fmt:message key="ALLOW_NOTHING" />
						</c:when>
						<c:when test="${row.permissionMode == 2}">
							<fmt:message key="ALLOW_NEW_TEST" />
						</c:when>
						<c:when test="${row.permissionMode == 3}">
							<fmt:message key="ALLOW_RE_ENTRY" />
						</c:when>
						<c:when test="${row.permissionMode == 4}">
							<fmt:message key="ALLOW_GRADING" />
						</c:when>
						<c:when test="${row.permissionMode == 5}">
							<fmt:message key="ALLOW_START_AND_GRADE" />
						</c:when>
						<c:when test="${row.permissionMode == 6}">
							<fmt:message key="ALLOW_RE_ENTRY_AND_GRADE" />
						</c:when>
						<c:when test="${row.permissionMode != 0}">Unknown permission mode ${row.permissionMode}</c:when>
					</c:choose>

				</display:column>
				<display:column title="${end_time_label}" >
					<c:choose>
						<c:when test="${row.endTime > 0}">
							<fmt:formatDate value="${row.endTimeDate}" dateStyle="short" timeStyle="short" type="both"/> 
						</c:when>
					</c:choose>
				</display:column>
				<display:column title="${time_limit_label}">
					<c:choose>
						<c:when test="${row.timeLimit > 0}">
							${row.timeLimit}
						</c:when>
					</c:choose>
				</display:column>
				<display:column property="assignmentName" sortable="true"
					title="${assignment_name_label}" />
			</display:table>
		</logic:present>



		<p>
			<html:button property="authorize" styleClass="button"
				value="${authorize_button}" onclick="doAuthorize();" />
		</p>

	</c:if>
	<%-- end testing if number of users > 0 --%>

</html:form>
