package applets.clickableImage;

import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

import applets.util.URLEncoder;

/**
 * Applet to accept user clicks on an image and send these back to the server via
 * util.PersistResponse Implemented in the Java 1.02 API.
 * 
 * parameters are:
 * <ul>
 * <li> key -- the server persistant memory key for recording the user's selectionn
 * <li> imageURL -- full URL of image to be displayed
 * <li> mode = [select|display] -- select allows user selection; display just displays region.1
 * <li> active -- region number of initial region to be selected
 * <li> region.1 ... region.n -- lists x1,y1,x2,y2,...,xk,yk of vertices of each region
 * </ul>
 * 
 * @see util.PersistResponse
 * @see gateway.question.ClickableImageQuestion
 */
public class ClickableImageApplet extends Applet implements Runnable {

	/**
	 * 
	 */
	private static final long	serialVersionUID	= 1L;
	Image image;
	Vector<Polygon> regions;
	Polygon activeRegion;
	Polygon currentRegion;
	boolean interact;
	String loadingStatus;
	boolean gotImage = false;
	private Frame holderFrame;
	private String baseURL = "";
	private String id;
	private String sessionId="";

	/* The user's session locale. Initialize to en_US, update in init() method */
	Locale mtaLocale = new Locale("en", "US");	
	
	// make an absolute URL from an URL relative to where the document was served from.
	private URL completeURL(String tail) throws MalformedURLException {

		try {
			return new URL(URLEncoder.encode(tail));
		} catch (Exception e) {
			try {
				return new URL(new URL(this.getParameter("baseURL")), URLEncoder.encode(tail));
			} catch(Exception e1) {
				return new URL(getDocumentBase(), URLEncoder.encode(tail));
			}
		}
	}

	public void destroy() {

		this.holderFrame.dispose();
	}

	public void dialog(Exception e) {

		showStatus(loadingStatus = applets.MessageUtilities.getMessage(mtaLocale, "ClickableImageApplet.LoadingStatus.ErrorLoadingImage"));

		System.out.println("Exception: " + e.toString());
		e.printStackTrace();

		new applets.util.WarningDialog(
				this.holderFrame,
				applets.MessageUtilities.getMessage(mtaLocale, "ClickableImageApplet.LoadingClickableImage.Error.Part1")+"\n \n"
						+ "   "
						+ this.getParameter("imageURL")
						+ "\n \n"
						+ applets.MessageUtilities.getMessage(mtaLocale, "ClickableImageApplet.LoadingClickableImage.Error.Part2"), mtaLocale).setVisible(true);
	}

	public void drawActiveRegion(Graphics g, Polygon p) {

		if (p == null || p.npoints == 0)
			return;
		
		Graphics2D g2d = (Graphics2D) g.create();
		
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
		                     RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION,
			                    RenderingHints.VALUE_INTERPOLATION_BICUBIC);
//		g2d.setXORMode(new Color(0.3f,0.3f,0.3f));
		g2d.setPaintMode();
		g2d.setColor(Color.green);
		g2d.setStroke(new BasicStroke(2.0f));
		g2d.drawPolygon(p);

//		int i;
//		for (i = 0; i < p.npoints - 1; i++)
//			drawThickLine(g2d, p.xpoints[i], p.ypoints[i], p.xpoints[i + 1],
//					p.ypoints[i + 1]);
//		drawThickLine(g2d, p.xpoints[i], p.ypoints[i], p.xpoints[0], p.ypoints[0]);

		g2d.setColor(new Color(0.1f,0.1f,0.1f,0.6f));
		g2d.fillPolygon(p.xpoints, p.ypoints, p.npoints);
	}

	public void drawPassiveRegion(Graphics g, Polygon p) {

		if (p == null || p.npoints == 0)
			return;

		Graphics2D g2d = (Graphics2D) g.create();
		
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
		                     RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION,
		                    RenderingHints.VALUE_INTERPOLATION_BICUBIC);
//		g2d.setXORMode(new Color(0.83f,0.67f,0.27f));
		g2d.setPaintMode();
		g2d.setColor(new Color(0.9f,0.50f,0.02f));
		g2d.setStroke(new BasicStroke(2.0f));
		g2d.drawPolygon(p);
		g2d.setColor(new Color(0.6f,0.6f,0.6f,0.6f));
		g2d.fillPolygon(p.xpoints, p.ypoints, p.npoints);
	}

	private void drawThickLine(Graphics g, int x1, int y1, int x2, int y2) {

		g.drawLine(x1, y1, x2, y2);
		g.drawLine(x1 + 1, y1, x2 + 1, y2);
		g.drawLine(x1, y1 + 1, x2, y2 + 1);
	}

	public Polygon findRegion(int x, int y) {

		for (int i = 0; i < regions.size(); i++) {
			Polygon p = (Polygon) regions.elementAt(i);
			if (p.contains(x, y))
				return p;
		}
		return null;
	}

	public void init() {

		String[] locale; 
		
		try
		{
			locale = getParameter("mtalocale").split("_");
		}
		catch (Exception e)
		{
			locale = "en_US".split("_");
		};
		
		if (locale.length==1)
			mtaLocale = new Locale(locale[0]);
		else if (locale.length==2)
			mtaLocale = new Locale(locale[0], locale[1]);
		else if (locale.length==3)
			mtaLocale = new Locale(locale[0], locale[1], locale[2]);		
		
		this.id = getParameter("id");
		this.sessionId = getParameter("sessionId");
		
		this.holderFrame = new Frame();

		try {
			setBackground(Color.white);

			new Thread(this).start();

			// the elements of regions are polygons that contain the points for that region
			regions = new Vector<Polygon>();

			// get the region parameter info...
			String region;
			for (int i = 1; (region = this.getParameter("region." + i)) != null; i++) {
				StringTokenizer stz = new StringTokenizer(region, ",\n\t ");
				int numPoints = stz.countTokens() / 2;

				Polygon p = new Polygon();

				for (int j = 0; j < numPoints; j++)
					p.addPoint(Integer.parseInt(stz.nextToken()),
							Integer.parseInt(stz.nextToken()));

				regions.addElement(p);
			}

			// interact iff mode is "select"; this goofy line avoids null pointer exceptions from
			// missing mode
			interact = "select".equals(this.getParameter("mode"));
			if (!interact)
				activeRegion = (Polygon) regions.elementAt(0);

			// if specified, select initial active region
			String activeStr = this.getParameter("active");
			if (activeStr != null) {
				try {
					int comma = activeStr.indexOf(',');
					int x = Integer.parseInt(activeStr.substring(0, comma));
					int y = Integer.parseInt(activeStr.substring(comma + 1));
					activeRegion = findRegion(x, y);
					// send that value back to the server, since it most likely forgot the last time
					// it read the value...
					sendClick(x, y);
				} catch (Exception e) {
					activeRegion = null;
				}
			}
			
		} catch (Exception e) {
			dialog(e);
		}
	}

	public boolean mouseDrag(Event evt, int x, int y) {

		return mouseMove(evt, x, y);
	}

	public boolean mouseEnter(Event event, int x, int y) {

		this.showStatus(loadingStatus);
		return true;
	}

	public boolean mouseMove(Event evt, int x, int y) {

		if (!(interact && gotImage))
			return true;
		Polygon p = currentRegion;
		if (currentRegion == null || !currentRegion.contains(x, y))
			currentRegion = findRegion(x, y);
		if (p != currentRegion)
			update(this.getGraphics());
		return true;
	}

	public boolean mouseUp(Event evt, int x, int y) {

		if (!(interact && gotImage))
			return true;
		if (currentRegion != null) {
			// should do something about graying...
			activeRegion = currentRegion;
			sendClick(x, y);
			update(this.getGraphics());
		}
		return true;
	}

	public void paint(Graphics g) {

		if (gotImage) {
			super.paint(g);
			g.drawImage(image, 0, 0, this);
		} else {
			g.drawString(applets.MessageUtilities.getMessage(mtaLocale, "ClickableImageApplet.LoadingStatus.LoadingImage"), 4, 34);
		}

		drawPassiveRegion(g, currentRegion);
		drawActiveRegion(g, activeRegion);
	}

	public void run() { // loader...

		try {

			showStatus(loadingStatus = applets.MessageUtilities.getMessage(mtaLocale, "ClickableImageApplet.LoadingStatus.LoadingImage"));

			MediaTracker tracker = new MediaTracker(this);
			image = this.getImage(completeURL(this.getParameter("imageURL")));
			tracker.addImage(image, 0);

			while (tracker.statusID(0, true) == MediaTracker.LOADING) {

				showStatus(applets.MessageUtilities.getMessage(mtaLocale, "ClickableImageApplet.LoadingStatus.LoadingImage"));
				try {
					Thread.sleep(500);
				} catch (InterruptedException e) {
				}
				showStatus("");
				try {
					Thread.sleep(500);
				} catch (InterruptedException e) {
				}
			}
			if (tracker.isErrorID(0))
				throw new Exception(applets.MessageUtilities.getMessage(mtaLocale, "ClickableImageApplet.LoadingStatus.ErrorLoadingImage"));

			// fix transparent pixels by painting onto blank image...
			Image tempImage = this.createImage(image.getWidth(this),
					image.getHeight(this));
			tempImage.getGraphics().drawImage(image, 0, 0, Color.white, this);

			// Netscape doesn't like me to do this...
			// image.flush();

			image = tempImage;

			gotImage = true;
			showStatus(loadingStatus = applets.MessageUtilities.getMessage(mtaLocale, "ClickableImageApplet.LoadingStatus.MakeSelection"));
			repaint();
		} catch (Exception e) {
			dialog(e);
		}
	}

	private void sendClick(int x, int y) {

		showStatus(loadingStatus = applets.MessageUtilities.getMessage(mtaLocale, "ClickableImageApplet.LoadingStatus.RecordingSelection"));
		String urlStr = getBaseURL() + "modules/util.PersistResponse?slash=/" + "&"
				+ ClickableImageCreator.TEST_KEY + "="
				+ getParameter(ClickableImageCreator.TEST_KEY) + "&response="
				+ x + "," + y
				+ "&id=" + id;
		try {
			HttpURLConnection connection = (HttpURLConnection) completeURL(urlStr).openConnection();
			connection.addRequestProperty("Cookie", "JSESSIONID=" + sessionId);
			BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
//			 in
//         = new BufferedReader(new InputStreamReader(new DataInputStream(completeURL(urlStr).openStream())));

			String line = in.readLine();
			in.close();

			if ("OK".equals(line))
				showStatus(loadingStatus = applets.MessageUtilities.getMessage(mtaLocale, "ClickableImageApplet.LoadingStatus.SelectionRecorded"));
			else
				showStatus(loadingStatus = applets.MessageUtilities.getMessage(mtaLocale, "ClickableImageApplet.LoadingStatus.UnexpectedServerResponse"));
			return;
		} catch (Exception e) {
			System.out.println("Exception: " + e.toString());
			e.printStackTrace();
		}
		// if we caught an exception or got a "FAIL" or whatever:
		
		showStatus(loadingStatus = applets.MessageUtilities.getMessage(mtaLocale, "ClickableImageApplet.LoadingStatus.SelectionNotRecorded"));
		activeRegion = null;
	}

	public void update(Graphics g) {

		paint(g); // no need to clear for an update
	}
	
	private String getBaseURL() {
		
		if( baseURL == null || baseURL.trim().length() == 0 ) {
			baseURL = this.getParameter("baseURL");
		}
		
		return baseURL;
	}
	
}
