package applets.grapher;

import java.applet.*;
import java.awt.*;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.Locale;

import applets.util.URLEncoder;

public class Graph extends Applet {

	/* The user's session locale. Initialize to en_US, update in init() method */
	public Locale mtaLocale = new Locale("en", "US");	

	public void init() {

	String[] locale;
		
	try
	{
		locale = getParameter("mtalocale").split("_");
	}
	catch (Exception e)
	{
		locale = "en_US".split("_");
	}
		
	if (locale.length==1)
		mtaLocale = new Locale(locale[0]);
	else if (locale.length==2)
		mtaLocale = new Locale(locale[0], locale[1]);
	else if (locale.length==3)
		mtaLocale = new Locale(locale[0], locale[1], locale[2]);		
		
	double xMin = Double.valueOf(getParameter("xMin", "-5")).doubleValue();
	double xMax = Double.valueOf(getParameter("xMax", "5")).doubleValue();

	double yMin = Double.valueOf(getParameter("yMin", "-5")).doubleValue();
	double yMax = Double.valueOf(getParameter("yMax", "5")).doubleValue();

	double xScale, yScale;
	double numGridLines = Double.valueOf(getParameter("gridLines", "10")).doubleValue();
	String p;
	
	if ( (p = getParameter("xScale")) == null ) {
		xScale = (xMax-xMin)/numGridLines;
	} else {
		xScale = Double.valueOf(p).doubleValue();
	}
	
	if ( (p = getParameter("yScale")) == null ) {
		yScale = (yMax-yMin)/numGridLines;
	} else {
		yScale = Double.valueOf(p).doubleValue();
	}

	GraphWindow g = new GraphWindow(xMin, xMax, xScale, yMin, yMax, yScale);

	setLayout(new BorderLayout());
	add("Center", g);

	if ((p = getParameter("background")) != null) {	    
		try {
		URL u;
		try {
			u = new URL(URLEncoder.encode(p));
		} catch (MalformedURLException e) {
			u = new URL(getDocumentBase(), URLEncoder.encode(p));
		}
		g.setBackground(getImage(u));
		} catch (MalformedURLException e) { }
	}
	
	if ((p = getParameter("xfmt")) != null) {
		g.setXFmt(p);
	}
	
	if ((p = getParameter("yfmt")) != null) {
		g.setYFmt(p);
	}

	String formulaString;
	for (int i=1; (formulaString = getParameter("y"+i)) != null; i++) {
		Parser prs = new Parser(mtaLocale);
		prs.parse(formulaString);
		g.addFunction(prs);
	} 
	
	String labelString;
		Double dWork;
	for (int i=1; (labelString = getParameter("label." + i)) != null; i++) {
				dWork = new Double(getParameter("label." + i + ".x"));
		double x = dWork.doubleValue();
				dWork = new Double(getParameter("label." + i + ".y"));
		double y = dWork.doubleValue();
		g.addLabel(x, y, labelString);
	}
	}

	String getParameter(String name, String def) {
	String p = getParameter(name);
	return p != null ? p : def;
	}
	
}
