package applets.labelImage;

import java.applet.Applet;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

import applets.util.URLEncoder;

public class LabelImage extends Applet {

    private static final String LEFT_STR = "left";
    private static final String CENTER_STR = "center";
    private static final String RIGHT_STR = "right";

    private static final int LEFT = 0;
    private static final int CENTER = 1;
    private static final int RIGHT = 2;

    private Image img;
    private String[] labels;
    private Point[] positions;
    private int[] align;

	private Frame holderFrame;

	/* The user's session locale. Initialize to en_US, update in init() method */
	Locale mtaLocale = new Locale("en", "US");
	
    public void init() {

	String[] locale;
	
	try
	{
		locale = getParameter("mtalocale").split("_");
	}
	catch (Exception e)
	{
		locale = "en_US".split("_");
	}
		
	if (locale.length==1)
		mtaLocale = new Locale(locale[0]);
	else if (locale.length==2)
		mtaLocale = new Locale(locale[0], locale[1]);
	else if (locale.length==3)
		mtaLocale = new Locale(locale[0], locale[1], locale[2]);    	
    	
	this.holderFrame = new Frame();
	try {
	img = getImage(completeURL(getParameter("image")));
	}
	catch (Exception e) {
		dialog(getParameter("image"));
		e.printStackTrace();
	}
	int k = Integer.parseInt(getParameter("size"));
	positions = new Point[k];
	labels = new String[k];
	align = new int[k];

	for (int i=0; i<k; i++) {
	    String name = "label." + (i + 1);
	    int x = Integer.parseInt(getParameter(name + ".x"));
	    int y = Integer.parseInt(getParameter(name + ".y"));
	    positions[i] = new Point(x, y);
	    labels[i] = parseEntities(getParameter(name + ".text"));
	    
	    String s = getParameter(name + ".align");
	    if (s == null || s.equals(LEFT_STR)) {
		align[i] = LEFT;
	    } else if (s.equals(CENTER_STR)) {
		align[i] = CENTER;
	    } else if (s.equals(RIGHT_STR)) {
		align[i] = RIGHT;
	    } else {
		align[i] = LEFT;
	    }
	}
    }

	// make an absolute URL from an URL relative to where the document was served from.
	private URL completeURL(String tail) throws MalformedURLException {

		try {
			return new URL(URLEncoder.encode(tail));
		} catch (Exception e) {
			URL rep = new URL(URLEncoder.encode(getDocumentBase().toString().replaceAll("/([^/])+$","")));
			URL db = new URL( rep, URLEncoder.encode(tail));
			return db;

		}
	}

	public void dialog(String img) {

		showStatus("Error loading image..." + img);

		new applets.util.WarningDialog(
				this.holderFrame,
				applets.MessageUtilities.getMessage(mtaLocale, "LabelImage.LoadingImage.Error") + "\n \n"
						+ "   "
						+ img, mtaLocale).show();
	}
    
    public void paint(Graphics g) {
	Font theFont = new Font("TimesRoman", Font.PLAIN, 14);
	FontMetrics fm = g.getFontMetrics(theFont);
	g.drawImage(img, 0, 0, this);
	g.setFont(theFont);

	for (int i=0; i<labels.length; i++) {
	    String label = labels[i];
	    int x, y;
	    switch (align[i]) {
	    case CENTER:
		x = positions[i].x;
		break;
	    case RIGHT:
		x = positions[i].x - fm.stringWidth(label);
		break;
	    case LEFT:
	    default:
		x = positions[i].x - fm.stringWidth(label)/2;
		break;
	    }
	    y = positions[i].y;

	    g.drawString(label, x, y);
	}
    }

    private String parseEntities(String s) {
	StringBuffer out = new StringBuffer();

	for (int i=0; i<s.length(); i++) {
	    char c = s.charAt(i);

	    if ( c != '&' ) {
		out.append(c);
		continue;
	    }

	    // At this point we know we're dealing with an entity
	    StringBuffer numStr = new StringBuffer();

	    c = s.charAt(++i);

	    if ( c != '#' ) {
		out.append(c);
		continue;
	    }

	    c = s.charAt(++i);

	    if ( c != 'x' && c != 'X' ) {
		out.append(c);
		continue;
	    }

	    while ( (c = s.charAt(++i)) != ';' && c > ' ') {
		numStr.append(c);
	    }

	    out.append(((char) Integer.parseInt(numStr.toString(), 16)));
	}
	return out.toString();
    }
}
