package applets.sketching;

import java.awt.Color;
import com.integretechpub.spline.*;
import com.integretechpub.mathapplet.DoubleRectangle;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.util.StringTokenizer;
import java.awt.Event;
import java.awt.event.MouseEvent;
import com.integretechpub.graphing.GraphPaper;
import com.integretechpub.mathapplet.DoubleDimension;

public class Sketching extends java.applet.Applet {
    private BufferedSplinePlot plotter;

    public void init() {
	setLayout(new BorderLayout());

	int xGridlines, yGridlines;
	String gridlines = getParameter("gridlines");
	if (gridlines == null) {
	    xGridlines = yGridlines = 4;
	} else if (gridlines.indexOf(",") < 0) {
	    xGridlines = yGridlines = Integer.parseInt(gridlines.trim());
	} else {
	    int k = gridlines.indexOf(",");
	    xGridlines = Integer.parseInt(gridlines.substring(0, k).trim());
	    yGridlines = Integer.parseInt(gridlines.substring(k+1).trim());
	}
	double xMin = getDoubleParam("xMin", -10.0);
	double xMax = getDoubleParam("xMax", 10.0);
	double width = xMax - xMin;
	double xSpace = xGridlines > 0 ? width/xGridlines : 0.0;
	double yMin = getDoubleParam("yMin", -10.0);
	double yMax = getDoubleParam("yMax", 10.0);
	double height = yMax - yMin;
	double ySpace = yGridlines > 0 ? height/yGridlines : 0.0;
	boolean labeled = "true".equals(getParameter("labeled"));

	DoubleRectangle viewport = new DoubleRectangle(xMin - xSpace, yMin - ySpace, width + 2*xSpace, height + 2*ySpace);

	plotter = new BufferedSplinePlot(viewport, 20);
	plotter.setSplineType(SplinePlot.SPLINE_CUBIC);
	plotter.setBackground(Color.white);
	if (labeled) {
	    DoubleDimension d = new DoubleDimension((xSpace == 0.0) ? 10*width : xSpace, 
						    (ySpace == 0.0) ? 10*height : ySpace);
	    plotter.setSpacing(GraphPaper.GRIDLINES |GraphPaper.TICKMARKS, d);
	} else {
	    plotter.setPropertyEnabled(GraphPaper.GRIDLINES |GraphPaper.TICKMARKS, false);
	}
	plotter.getSpline().setRenderNodes(true);
	plotter.getSpline().setRenderNodeTangents(false);
	plotter.setDecimalPlace(8);
	add("Center", plotter);
	readParameters();
    }

    private void readParameters() {
	String response = getParameter("response");
	if (response == null) {
	    // do nothing
	} else if (response.startsWith("nodes:")) {
	    Spline theSpline = plotter.getSpline();
	    StringTokenizer stz = new StringTokenizer(response.substring(6), ", ");
	    while (stz.hasMoreTokens()) {
		try {
		    double x = Double.valueOf(stz.nextToken()).doubleValue();
		    double y = Double.valueOf(stz.nextToken()).doubleValue();
		    double m = Double.valueOf(stz.nextToken()).doubleValue();
		    theSpline.addNode(new SplineNode(x, y, m));
		} catch (com.integretechpub.spline.ConflictingPositionException e) { }
	    }
	} else {
	    Spline theSpline = plotter.getSpline();
	    StringTokenizer stz = new StringTokenizer(response, ", ");
	    while (stz.hasMoreTokens()) {
		try {
		    double x = Double.valueOf(stz.nextToken()).doubleValue();
		    double y = Double.valueOf(stz.nextToken()).doubleValue();
		    theSpline.addNode(new SplineNode(x, y, 1.0));
		} catch (com.integretechpub.spline.ConflictingPositionException e) { }
		plotter.reassignSlopes();
	    }
	}

	plotter.setLocked("true".equals(getParameter("locked")));
    }

    private double getDoubleParam(String name, double dflt) {
	try {
	    return Double.valueOf(getParameter(name)).doubleValue();
	} catch (Exception e) {
	    return dflt;
	}
    }

    public void update(Graphics g) {
	paint(g);
    }

    public void deleteActiveNode() {
	plotter.deleteActiveNode();
	plotter.repaint();
    }

    public void deleteAllNodes() {
	plotter.removeAllNodes();
	plotter.repaint();
   }

    public String getResponse() {
	Spline spl = plotter.getSpline();
	spl.sortNodes();
	SplineNode[] nodes = plotter.getSpline().getNodes();
	StringBuffer sb = new StringBuffer();
	sb.append("nodes: ");
	if (nodes != null) {
	    for (int i=0; i<nodes.length; i++) {
		sb.append(nodes[i].node.x + " ");
		sb.append(nodes[i].node.y + " ");
		sb.append(nodes[i].slope + " ");
	    }
	}
	return sb.toString();
    }
}

class BufferedSplinePlot extends SplinePlot {
    private Image offscreen;
    private boolean locked;

    BufferedSplinePlot(DoubleRectangle r, int k) {
	super(r, k);
    }

    public void paint(Graphics g) { 
	if (offscreen == null) {
	    offscreen = createImage(size().width, size().height);
	}
	Graphics og = offscreen.getGraphics();
	super.paint(og);
	g.drawImage(offscreen, 0, 0, this);
    }

    void setLocked(boolean x) {
	locked = x;
    }

    public void mousePressed(MouseEvent e) {
	System.out.println(locked);
	
	if (! locked) {
	    super.mousePressed(e);
	}
    }
}

