package applets.util;

import java.awt.*;
import java.util.*;

public class MultiLineLabel
  extends Canvas
{
	private Vector lines;
	private int textWidth = 0;
	private int textHeight = 0;

        private static int INSET = 20;

	public MultiLineLabel(String text) {

		boolean lastTokenWasLineBreak = false;
		
		this.lines = new Stack();
		
		for(StringTokenizer stz = new StringTokenizer(text, "\n", true); stz.hasMoreTokens(); ) {
			
			// We need to be sure that each "\n" is counted...
			String s = stz.nextToken();
			
			if( "\n".equals(s) ) {
				
				if( lastTokenWasLineBreak ) ((Stack)lines).push("");
				lastTokenWasLineBreak = true;
			}
			else {
				((Stack)lines).push(s);
				lastTokenWasLineBreak = false;
			}
		}
	}
  
	public void addNotify() {
		
		super.addNotify();
		
		FontMetrics fm = this.getFontMetrics(this.getFont());
		
		for(Enumeration e = this.lines.elements(); e.hasMoreElements(); ) {
			
			int width = fm.stringWidth((String)e.nextElement());
			
			this.textWidth = (this.textWidth < width) ? width : this.textWidth;
		}
		this.textHeight = this.lines.size() * fm.getHeight();
	}
  
	public Dimension getMinimumSize() {
		
		return( new Dimension(this.textWidth, this.textHeight) );
	}
  
	public Dimension getPreferredSize() {
		
		return( new Dimension(this.textWidth + 2*INSET, this.textHeight + 2*INSET) );
	}
  
	public static void main(String[] args) {
		
		Frame f = new Frame();
		f.add("Center", new MultiLineLabel("Hi there.\nHow are you today?This is a list\n\nof several lines\nof text"));
		f.pack();
		f.show();
	}
  
	public Dimension minimumSize() { return getMinimumSize(); }
  
	public void paint(Graphics g) {
		
		FontMetrics fm = this.getFontMetrics(this.getFont());
		
		int baseline = fm.getAscent() + INSET;
		
		for(int i=0; i<this.lines.size(); i++) {
			
			g.drawString((String)this.lines.elementAt(i), INSET, baseline);
			baseline += fm.getHeight();
		}
	}
  
	public Dimension preferredSize() { return getPreferredSize(); }
}
