package applets.util;

import java.io.UnsupportedEncodingException;

public class URLEncoder {
	
	private static final char[] DIGITS = { '0', '1', '2', '3', '4', '5', '6',
			'7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };

	public static String encode(String input) {
		if (input == null || "".equals(input)) {
			return new String(input);
		}
		StringBuffer output = new StringBuffer();
		
		for (int index = 0; index < input.length(); index++) {
			output.append(escape(input.charAt(index)));
		}
		return output.toString();
	}

	private static String escape(char input) {
		StringBuffer output = new StringBuffer();
		if (input <= 0x007f) {
			return output.append(input).toString();
		} else {
			try {
				byte[] bytes = String.valueOf(input).getBytes("UTF-8");
				for (int i = 0; i < bytes.length; i++) {
					output.append('%').
					append(DIGITS[(0xF0 & bytes[i]) >> 4]).
					append(DIGITS[0x0F & bytes[i]]);
				}
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
				output = new StringBuffer();
				return output.append(input).toString();
			}
		}
		return output.toString().toUpperCase();
	}
}
