package applets.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;

import javax.swing.JButton;
import javax.swing.JDialog;

public class WarningDialog
  extends JDialog implements ActionListener 
{
	private static final long	serialVersionUID	= 1L;

	public WarningDialog (Frame parent, String message, Locale theLocale) {

		super(parent, "Warning");

		// Set the colors
		setBackground(Color.lightGray);
		setForeground(Color.black);
	
		// Set the font
		setFont(new Font("SansSerif", Font.PLAIN, 12));
	
		add("Center", new MultiLineLabel(message));
	
		Panel p = new Panel();
		JButton button = new JButton(applets.MessageUtilities.getMessage(theLocale, "WarningDialog.Button.OK.Label"));
		button.addActionListener(this);
		p.add(button);
		add("South", p);
	
		pack();
	}

	public void actionPerformed(ActionEvent e) {
		this.setVisible(false);
		this.dispose();
	}
}
