<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>
<%@ page import="com.maplesoft.mapleta.ws.WSProperties"%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>

<!DOCTYPE html>
<html:html lang="true">
<head>
	<!-- skinFrame.jsp -->
	<base href="<%=GatewayService.getServerURL()%>">

	<title><fmt:message key="title.system" /> - <tiles:getAsString
			name="module_title" ignore="true" />
	</title>

	<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0">

	<link rel="stylesheet" type="text/css"
		href="<%=GatewayService.getServerURL()%>modules/skin/css/main.css">
	<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/skin/css/print.css" media="print">  
	<link rel="stylesheet" type="text/css"
		href="<%=GatewayService.getServerURL()%>modules/skin/css/menubar.css">
	<link rel="stylesheet" type="text/css"
		href="<%=GatewayService.getServerURL()%>modules/skin/css/questions.css">
	<tiles:insert page="/WEB-INF/tiles/wsscript.jsp" beanScope="request" flush="false" />
	<script language="JavaScript">
		// strings for main.js
		var msgMainScriptImminentSessionTimeoutWarningPart1 = "<fmt:message key='msg.Main.Script.ImminentSessionTimeoutWarning.Part1' />";
		var msgMainScriptImminentSessionTimeoutWarningPart2 = "<fmt:message key='msg.Main.Script.ImminentSessionTimeoutWarning.Part2' />";
		var msgMainScriptTimedAssignmentWarning = "<fmt:message key='msg.Main.Script.TimedAssignmentWarning' />";
		var msgMainScriptFinishOtherAssignmentFirst = "<fmt:message key='msg.Main.Script.FinishOtherAssignmentFirst' />";
	
		
		// Blocking Backspace
		var newPage = true;
		// Blocking Backspace
		if (history.pushState) {
			history.pushState(null, "Current Page");
			
			window.onpopstate = function(event) {
				var isChrome = /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor);
				var isSafari = /Safari/.test(navigator.userAgent) && /Apple Computer/.test(navigator.vendor);
				var doBack = ((!newPage || (!isChrome && !isSafari)) && document.getElementById('MenuItem.actions.assignment.back') != null);

				if (doBack) {
					disableme('MenuItem.actions.assignment.back');
					doAction('back');
				} else {
					history.pushState(null, "Current Page");
					newPage = false;
				}
			};
		}
	</script>
	

	<tiles:insert page="/WEB-INF/tiles/javascript.jsp" beanScope="request"	flush="false" />

	<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/skin/css/jquery.ui.css"/>
	<script
		src="<%=GatewayService.getServerURL()%>modules/scripts/buttons.js"></script>
	<script
		src="<%=GatewayService.getServerURL()%>modules/skin/scripts/buttons.js"></script>
	<script src="<%=GatewayService.getServerURL()%>modules/scripts/main.js"></script>
	<script
		src="<%=GatewayService.getServerURL()%>modules/skin/scripts/menubar.js"></script>
	<script
		src="<%=GatewayService.getServerURL()%>modules/scripts/helpURLs.js"></script>

	<link rel="shortcut icon" href="<%=GatewayService.getServerURL()%>modules/skin/images/titlebar/favicon.ico" />

</head>



<body onLoad="onLoad()" onResize="onResize()" onUnload="onUnload()">

		<div id="top">
					<c:choose>
						<c:when test="${! sessionScope.bb_enabled and empty sessionScope.wsQuestionEngine}">
							<div class="pageHeader">
								<tiles:insert name="header">
									<tiles:put name="module">
										<tiles:getAsString name="module_title" ignore="true" />
									</tiles:put>
								</tiles:insert>
							</div>
							<div class="crumbTrail">
								<tiles:insert definition=".crumbTrail">
									<tiles:put name="crumb">
										<tiles:getAsString name="crumbtrail" ignore="true" />
									</tiles:put>
									<tiles:put name="exit_wrapper"
										value="${sessionScope.exitWrapper}" type="String" />
								</tiles:insert>
							</div>
						</c:when>
						<c:when test="${sessionScope.bb_enabled}">
							<div class="bbHeader">
								<tiles:insert name="header">
									<tiles:put name="module">
										<tiles:getAsString name="module_title" ignore="true" />
									</tiles:put>
									
									<tiles:put name="crumbtrail">
										<tiles:getAsString name="crumbtrail" ignore="true" />
									</tiles:put>
								</tiles:insert>
							</div>
						</c:when>
	
						<c:otherwise>
							<div style="position: absolute; right: 0; bottom: 0; font-size: smaller; color: gray;">
							    <tiles:insert name="version" flush="false" />
							</div>		
						</c:otherwise>
					</c:choose>
	
					<c:if test="${empty sessionScope.wsQuestionEngine}">
						<div class="menu">
							<tiles:insert name="menu" />
						</div>
					</c:if>
			</div>
		
					<div id="holder">
					<div class="content">
						<div id="pageContainer">
							<tiles:getAsString name="content" />
						</div>
					</div>
			
					
					</div>
					
					<c:if test="${empty sessionScope.wsQuestionEngine}">
						<div class="foot">
							<tiles:insert name="footer" />
						</div>
					</c:if>
	<div id="pageDialog"></div>
		<logic:present name="popupAlert">
			<script language="Javascript" type="text/javascript">
				alert("${popupAlert}");
			</script>
		</logic:present>
</body>
</html:html>
