<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>

<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">
	<tiles:useAttribute name="searchType" ignore="true" />

	<script>

	var toggleDiv = function(_id) {
		var c =  document.getElementById("userSearch"),
		   divs = c.getElementsByTagName("DIV");
		for( i=0; i<divs.length; i++ ) {
			if( divs[i].id == _id ) {
	  			divs[i].className = "";
			} 
			else if(divs[i].parentNode == c){
	  			divs[i].className = "hidden";
	  		}
		}
	};

	function formRefresh(_id) {
		var inputs = document.getElementById(_id).getElementsByTagName("INPUT");
		for( i=0; i<inputs.length; i++ ) {
			if( inputs[i].type == "text" ) {
				inputs[i].value="";
			}
			else if( inputs[i].type == "radio" && inputs[i].value == "and" ) {
				inputs[i].checked="true";
			}
		}
		
	}
	
</script>

	<style>

#usersearch {
position:relative;
}

#userSearch .hidden {
position:absolute;
left:-990px;
}

.proster{
    border: 1px solid #CCCCCC;
    margin: 10px;
    padding: 10px;
    width: 50%;
}
.strong{ font-weight: bold;}
#roster span{ white-space:nowrap; }
</style>

	<tiles:useAttribute name="actionMapping" />

	<div id="userSearch">
			<!-- Advanced Search -->
			<c:choose>
				<c:when test="${search_obj == 'advanced'}">
					<div id="advanced">
				</c:when>
				<c:otherwise>
					<div id="advanced" class="hidden">
				</c:otherwise>
			</c:choose>
			<html:form styleId="advanced" method="post" action="${actionMapping}">
				<html:hidden property="dispatch" value="advanced" />
				<table border="0" cellpadding="0" cellspacing="3">
					<tr>
						<td>
							<strong><fmt:message key="UserAdmin.last.label" />&nbsp;</strong>
						</td>
						<td>
							<html:text property="sn" />
						</td>
						<td width="10px">
							&nbsp;
						</td>
						<td>
							<strong><fmt:message key="UserAdmin.first.label" />&nbsp;</strong>
						</td>
						<td>
							<html:text property="givenName" />
						</td>
					</tr>
					<tr>
						<td>
							<strong><fmt:message key="UserAdmin.uid.label" />&nbsp; </strong>
						</td>
						<td>
							<html:text property="uid" />
						</td>
						<td width="10px">
							&nbsp;
						</td>
						<td>
							<strong><fmt:message key="UserAdmin.studentID.label" />&nbsp;</strong>
						</td>
						<td>
							<html:text property="studentID" />
						</td>
					</tr>

					<tr>
						<td>
							<strong><fmt:message key="UserAdmin.email.label" />&nbsp; </strong>
						</td>
						<td>
							<html:text property="email" />
						</td>
						<td width="10px">
							&nbsp;
						</td>
					</tr>
					<tr>
						<td>
							<strong><fmt:message key="UserAdmin.recordsPerPage.label"/>&nbsp; </strong>
						</td>
						<td>
							<html:select property="pageLimit">							  
								<html:option value="25">25</html:option>
								<html:option value="50">50</html:option>
								<html:option value="100">100</html:option>
								<html:option value="150">150</html:option>
								<html:option value="200">200</html:option>								
							</html:select>
						</td>
						<td width="10px">
							&nbsp;
						</td>
					</tr>
				</table>

				<%-- insert filtering tile--%>
				<br />
				<tiles:insert name="filter" flush="false" ignore="true">
					<tiles:put name="showAdvancedFilters" value="true" />
				</tiles:insert>

				<br />
				<table>
					<tr>
						<td>
							<c:set var="reset_label">
								<fmt:message key="UserAdmin.reset_fields.label" />
							</c:set>
							<input type="button" class="button" value="${reset_label}"
								onclick="javascript:this.form.dispatch.value = 'reset'; this.form.submit();" />
						</td>
						<td>
							<html:submit styleClass="button">
								<fmt:message key="UserAdmin.search.label" />
							</html:submit>
						</td>
						<td width="10px">
							&nbsp;
						</td>
						<td>
							&nbsp;
						</td>
						<td>
							&nbsp;
						</td>
					</tr>
				</table>


			</html:form>
			<a href="Basic Search" onclick="toggleDiv('basic'); return false;"><fmt:message
					key="UserAdmin.basic.label" /> </a> |
			<fmt:message key="UserAdmin.advanced.label" />
				<c:if test="${actionMapping == '/ProctorTools'}">|
			<a href="#" onclick="toggleDiv('roster'); return false;"><fmt:message key="UserAdmin.roster.label" /></a></c:if>

		</div>
		<!--  basic search -->
			<!-- Advanced Search -->
		<c:choose>
			<c:when test="${search_obj == 'basic' || empty search_obj}">
				<div id="basic">
			</c:when>
			<c:otherwise>
				<div id="basic" class="hidden">
			</c:otherwise>
		</c:choose>
			<html:form method="post" action="${actionMapping}">
				<html:hidden property="dispatch" value="basic" />
				<table>
					<tr>
						<td>
							<strong><fmt:message key="UserAdmin.search.label" /> </strong>
						</td>
						<td>
							<html:text property="searchString" />
						</td>
					</tr>
					<tr>
						<td>
							<strong><fmt:message key="UserAdmin.recordsPerPage.label"/>&nbsp; </strong>
						</td>
						<td>
							<html:select property="pageLimit">							  
								<html:option value="25">25</html:option>
								<html:option value="50">50</html:option>
								<html:option value="100">100</html:option>
								<html:option value="150">150</html:option>
								<html:option value="200">200</html:option>								
							</html:select>
						</td>
					</tr>
				</table>

				<%-- insert filtering tile--%>
				<br />
				<tiles:insert name="filter" flush="false" ignore="true">
					<tiles:put name="showAdvancedFilters" value="false" />
				</tiles:insert>
				<br />
				<input type="button" class="button" value="${reset_label}"
					onclick="javascript:this.form.dispatch.value = 'reset'; this.form.submit();" />
				<html:submit styleClass="button">
					<fmt:message key="UserAdmin.search.label" />
				</html:submit>

			</html:form>
			<fmt:message key="UserAdmin.basic.label" />
			|
			<a href="Advanced Search"
				onclick="toggleDiv('advanced');return false;"><fmt:message
					key="UserAdmin.advanced.label" /> </a>
			<c:if test="${actionMapping == '/ProctorTools'}">|
			<a href="#" onclick="toggleDiv('roster'); return false;"><fmt:message key="UserAdmin.roster.label" /></a></c:if>
		</div>
		
		<c:if test="${actionMapping == '/ProctorTools'}">
				<c:choose>
				   <c:when test="${search_obj == 'roster'}">
					   <div id="roster">
				   </c:when>
				<c:otherwise>
					<div id="roster" class="hidden">
				</c:otherwise>
			  </c:choose>
				<html:form method="post" action="${actionMapping}" enctype="multipart/form-data">
					<html:hidden property="dispatch" value="roster" />
					<div>
					  <p class="strong"><fmt:message key="UserAdmin.roster.instruction1" /></p>					  
						<html:file property="roster" accept=".csv, text/plain" />
					</div>
					<table>
						<tr>
							<td width="120px"><strong><fmt:message key="ProctorToolsFilter.assignments.label" /></strong></td>
							<td><tiles:insert definition=".proctor.assignment.chooser" flush="false" /></td>
						</tr>
					</table>
					<div>
						<span><fmt:message key="UserAdmin.recordsPerPage.label"/>&nbsp; </span> <select name="pageLimit">							
							<option selected="selected" value="25">25</option>
							<option value="50">50</option>
							<option value="100">100</option>
							<option value="100">150</option>
							<option value="100">200</option>							
						</select>
						<br>
					</div><br>
					
			     <div>
						<html:submit styleClass="button"><fmt:message key="UserAdmin.search.label" /></html:submit>
					</div>
				</html:form>
				<a href="Basic Search" onclick="toggleDiv('basic'); return false;"><fmt:message	key="UserAdmin.basic.label" /></a>
			  | <a href="Advanced Search" onclick="toggleDiv('advanced');return false;"><fmt:message key="UserAdmin.advanced.label" /></a>
			  | <fmt:message key="UserAdmin.roster.label" />
			</div>
	  </c:if>

	</div>
	<br>
</fmt:bundle>
