
/*
 * This set of Javascript functions provides general utilities for the system. None
 * of the functions in this file are directly related to look and feel. It is strongly
 * recommended NOT to modify these functions.
 */

/*
 * Variable to hold page submission counter. 
 */
var clickCounter; 

var questionMenu; // The question menu in the top bar

/*
 * Variable to hold assignment window instance reference.
 */
var edu_window;

/*
 * Hook to be called whenever a page is loaded. Override this to provide
 * functionality.
 */
function onLoad() {
	// Do nothing
}
/*
 * Hook to be called whenever a page is resized. Override this to provide
 * functionality.
 */
function onResize() {
	// Do nothing
}
/*
 * Hook to be called whenever a page is left. Override this to provide
 * functionality.
 */
function onUnload() {
	// Do nothing
}
/*
 * Hook to be called whenever a form is submitted. Override this to provide
 * functionality.
 */
function onSubmit() {
	return true;
}

function readCookie(name) {
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return null;
}

/*
 * Returns true if the the 'usingLockdown' cookie is set to true, false
 * otherwise
 */
function getUsingLockdown()
{
	return readCookie('usingLockdown') == "true";
}

/*
 * Called by the lockdown browser to specify that the user is in the lockdown
 * browser
 */
function setUsingLockdown()
{
	document.cookie="usingLockdown=true";
}

/*
 * Called to specify that the student has an assignment open in a tab needed for
 * lockdown browser
 */
function setInAssignment(value){
	document.cookie="inLockdownAssignment=" + value;
}


/*
 * This is the basic action-delegation method called to submit forms to EDU.
 * Most button clicks result in a call to this function.
 */
function doAction(action) {
	if (firstClick(action) && onSubmit()) {
		var frm = document.forms["edu_form"];
		frm.elements.actionID.value = action;
		frm.submit();
	}
}

function disableme(theId) {
	var el = document.getElementById(theId);
	el.parentElement.innerHTML="<span onselectstart='return false;'>" + el.innerHTML + "</span>";
}


/*
 * This handles action's performed from the menu so as not to clobber the
 * edu_form
 */
function doMenuAction(action) {
	var frm = document.forms["menu_form"];
	frm.elements.actionID.value = action;
	if (onSubmit()) {
		frm.submit();
	}
}

function readEssayAreas(){
	if( typeof CKTwoDeeEditorPlugin != 'undefined'){
		// Have a CKeditor somewhere, clean it up

		var textareas = $('textarea');
		
	
		for( var i = 0; i< textareas.length; i++){
			var curTextarea = textareas[i];
			
			var id = $(curTextarea).attr('id');
			var instance = CKEDITOR.instances[id];
			
			if( instance != null ){
				var input =  instance.getData(true);
				
				var output = CKTwoDeeEditorPlugin.removeMathJax(input, false);

				var valueId = id.replace('.textarea', '.value');
				
				$('[name="' + valueId + '"]').val(output);
			}
		}
	}
}


/*
 * Read a question response from a Java applet that conforms to the contract of
 * Java question type.
 */
function readAppletItems() {
	readEssayAreas();
	
	
	var form = document.edu_form;
	var elts = form.elements;
	var pattern = /ans\.(\d+)\.(\d+)/;
	
	for (var i = 0; i < elts.length; i++) {
		var name = elts[i].name;
		if (name.match(pattern) != null) {
			var appl = document[name + ".sro"];
			var app = null;
			var resp = null;
			if (appl != null) {
				try {
					resp = new String(appl.getResponse());
				} catch (err) {
				}
			} else {
				if ((appl = document[name + ".swf"]) != null) {
					if (!('length' in appl)) {
						try {
							resp = new String(appl.getResponse());	// AS3.0 authors must define, and register with ExternalInterface, a getResponse() method in the Flash movie.
						} catch (err) {
							resp = new String(appl.GetVariable("response")); // As before, AS2.0 authors must define a response variable in the Flash movie.
						}
					} else {
						for (var j=0; j<appl.length; j++) {
							try {
								try {
									resp = new String(appl[j].getResponse());	// AS3.0 authors must define, and register with ExternalInterface, a getResponse() method in the Flash movie.
									break;
								} catch (err) {
									resp = new String(appl[j].GetVariable("response")); // As before, AS2.0 authors must define a response variable in the Flash movie.
									break;
								}
							} catch (err) {
								;
							} 
						}
						appl = appl[j];
					}

				} else if ((appl = document[name + ".mw"]) != null) {
					
					var gradeid = name+".0"; 
					var stateid = name+".1"; 
					
					try {
						callMapleNet(appl.value, '', gradeid);
						callMapleNet(appl.value, '', stateid);
						resp == null;
					} catch(err) {
						alert("error");
					}
				}
				
			
			}
			if (resp != null) {
				form.elements[i].value = resp;
				if (resp.indexOf("error:") == 0) {
					var errm = resp.substring(6, resp.length);
					if (!confirm(errm)) {
						appl.requestFocus();
						return false;
					}
				}
			}
		}
	}
	return true;
}

function mapleNetStateChanged(elemid) {
    if (xmlHttp.readyState==4) {
       document.getElementById(elemid).value=xmlHttp.responseText;
    }
}

function GetXmlHttpObject() {
	var xmlHttp = null;
	try {
		// Firefox, Opera 8.0+, Safari
		xmlHttp = new XMLHttpRequest();
	} catch (e) {
		// Internet Explorer
		try {
			xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e) {
			xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
		}
	}
	return xmlHttp;
}

function callMapleNet(url, params, elemid) {
    xmlHttp=GetXmlHttpObject();
    if (xmlHttp==null) {
       alert ("Your browser does not support AJAX!");
       return;
    }

    xmlHttp.onreadystatechange=mapleNetStateChanged(elemid);
    xmlHttp.open("POST",url,true);
    xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    xmlHttp.setRequestHeader("Content-length", params.length);
    xmlHttp.setRequestHeader("Connection", "close");
    xmlHttp.send(params);
}

/*
 * Redirect the window to the home page for the ambient class.
 */
function toClassPage() {
	var w = window;
	if (window.parent.frames.controlbar != null) {
		w = window.parent.opener;
	}
	if (w != null) {
		if (className != "") {
			w.location = getBaseURL() + "registration.Redirect?className=" + className;
		} else {
			w.location = getBaseURL();
		}
		w.focus();
	}
	if (window.parent.frames.controlbar != null) {
		window.parent.close();
	}
}
/*
 * Draw the content of a popup hints window.
 */

/*
 * this code was added in an attempt to show what hints have been seen. It did
 * not work so is commented out until we can get back to this feature.
 * 
 * 
 * function showHint(hintIndex) {
 * 
 * if (hintIndex == -1) return; // Update the list of hints that we've seen...
 * var objHintsSeen = document.getElementById("hintsSeen"); var hintsSeen =
 * objHintsSeen.value; if (hintsSeen.indexOf(hintIndex) == -1) { var arrayHints =
 * hintsSeen.split(','); arrayHints[arrayHints.length] = hintIndex;
 * arrayHints.sort(); hintsSeen = arrayHints.join(','); objHintsSeen.value =
 * hintsSeen; }
 */
function showHint(hintVal, hintRefVal, testId, assignmentMode) {
	var hintUrl = getBaseURL() + "modules/proctoredTest.ShowHint";
	$.post(hintUrl,{ hint: hintVal, hintRef: hintRefVal, testId: testId, assignment_mode: assignmentMode}, function(data){
		
		var hint = $("#hint", data).html();
		
		try{
		$('#pageDialog').dialog("destroy");
		}catch(ex){}
		
		$('#pageDialog').html(hint);
		MathJax.Hub.Queue(["Typeset",MathJax.Hub]);

		$('#pageDialog').dialog({
			"title": "Hint",
			"resizable": true,
			"autoOpen": true,
			"beforeclose": function(){
				setAppletsEnabled($(this).closest(".ui-dialog")[0]);
			},
			"beforeClose": function(){
				setAppletsEnabled($(this).closest(".ui-dialog")[0]);
			},
			"open" : function(){
				setAppletsEnabled($(this).closest(".ui-dialog")[0], false);
			},
			"buttons": {
				"Ok": function() {
					$(this).dialog("close");
				}
			}
		 });
		$('#pageDialog').dialog("open");
	});


}
/*
 * Provide help for a user in one of the system roles of instructor, student,
 * administrator, or proctor.
 */
function getHelp(what,where) {

	var winspec = "scrollbars,resizable,width=800,height=600";
	var help;
	// The definitions of the help urls are in helpURLs.js
	if (what == "instructor") {
		help = INSTRUCTOR_HELP_URL;
	} else if (what == "administrator") {
		help = SYSADMIN_HELP_URL;
	} else if (what == "proctor") {
		help = PROCTOR_HELP_URL;
	} else if (what == "student") {
		help = STUDENT_HELP_URL;
	} else if (what == "getting_started") {
		help = INSTRUCTOR_GETTIN_STARTED;
	} else if (what == "user_guide_pdf") {
		help = INSTRUCTOR_USER_GUIDE_PDF;
		/*
		 * } else if (what == "inline_editor") { help = INLINE_EDITOR_HELP_URL;
		 */
	} else if (what == "math_symbol_mode") {
		help = MATH_SYMBOL_MODE_HELP_URL;
	} else if (what == "math_text_mode") {
		help = MATH_TEXT_MODE_HELP_URL;
	} else if (what == "student_math_editor") {
		help = STUDENT_MATH_EDITOR_HELP;
	} else if (what == "instructor_math_editor") {
		help = INSTRUCTOR_MATH_EDITOR_HELP;
	} else if (what == "chem_symbol_mode") {
		help = CHEM_SYMBOL_MODE_HELP_URL;
	} else if (what == "chem_text_mode") {
		help = CHEM_TEXT_MODE_HELP_URL;
	} else {
		help = ASSIGNMENT_TYPE_HELP_URL;
	}


	var url= where+help;

	var index = url.lastIndexOf('/');
	var folder = url.substr( 0, index + 1);
	var page = url.substr(index + 1);

	if( getUsingLockdown() )
	{
		loadHelpDialog(folder, page, true, where);
	}else{
		openWindow(where+help, "helpWindow", "scrollbars,resizable,width=800,height=600");
	}

}




function getFileName( url )
{

	var index = url.lastIndexOf('/');

	if( index > 0){
		return url.substr( index +1  );
	}else{
		return url;
	}
}

function setImageWidth( img ){
	$("<img/>") // Make in memory copy of image to avoid css issues
	.attr("src", $(img).attr("src") + "?t=" + new Date().getTime())
	.load(function() {
		if( this.width > 740 )
		{
			$(img).css('width', '740px');
		}
	} );
}

function loadHelpDialog(folder, page, destroy, where)
{
	var index = page.lastIndexOf('#');
	var anchor = "";

	if( index > 0)
	{
		anchor = page.substr(index +1);
		page = page.substr( 0, index );		
	}	

	var target = folder + page + ' > div';

	$('#pageDialog').html("<div id='helpContainer'>&nbsp</div>");

	$('#helpContainer').load(target, function(text,status, request){

		if( request.status == 404){
			$('#pageDialog').html("Help page not found " + folder + page );
		}

		$('#pageDialog img').each(function(){

			var src =$(this).attr('src');

			if( src.indexOf(where) >= 0){
				src = src.replace(where, folder);
			}else{
				src = folder + src;
			}

			$(this).attr('src', src);

			setImageWidth(this);
		});	


		$('#helpContainer > div').css('width', 740);

		$('#pageDialog a').click(function(){
			$(this).dialog("close");					

			loadHelpDialog(folder, getFileName($(this).attr('href')), false, where);
			return false;
		});

		if( destroy){			
			try{
				$('#pageDialog').dialog("destroy");
			}catch(ex){}
				
			$('#pageDialog').dialog(  { 
				"title": "Help",
				"resizable": false,
				"width": 800,
				"height": 600,
				"scroll": false,
				"open" : function(){
					setAppletsEnabled($(this).closest(".ui-dialog")[0], false);
				},
				"beforeclose": function(){
					setAppletsEnabled($(this).closest(".ui-dialog")[0]);
				},
				"beforeClose": function(){
					setAppletsEnabled($(this).closest(".ui-dialog")[0]);
				},
				"buttons": {"Close": function() {
					$(this).dialog("close");
				}}
			});

			$('#pageDialog').dialog("open");
		}		

		if( anchor != ""){
			var destination = $('#'+anchor).offset().top - $("#pageDialog").offset().top;
			$("#helpContainer").animate( { scrollTop: destination } );
		}else{
			$("#helpContainer").scrollTop(0);
		}

	});

}

/*
 * Utility method. Not called from outside this package.
 */
function getMaplePlotURL(maple, plot, type, libname, driver, width, height) {
	var url = getBaseURL() + "modules/mapleTA.plotserver.PlotServer" + "?maple=" + myEscape(maple) + (plot != null ? "&plot=" + myEscape(plot) : "") + (type != null ? "&type=" + myEscape(type) : "") + (libname != null ? "&libname=" + myEscape(libname) : "") + ((driver == null || driver.length == 0) ? "" : "&plotdriver=" + myEscape(driver)) + ((width == null || height == null) ? "" : "&width=" + width + "&height=" + height);
	return url;
}
/*
 * Create a plot using the provided Maple code. Utility method. Not called from
 * outside this package.
 */
function drawMaplePlot(maple, width, height, libname, driver) {
	var url = getMaplePlotURL(maple, null, null, libname, driver, width, height);
	document.write("<IMG title=\"Maple plot\"");
	document.write("SRC=\"" + url + "\" ");
	// size the image if we have that parameters, otherwise, let the browser
	// figure it out
	if (width != null && height != null) {
		document.write("WIDTH=" + width + " ");
		document.write("HEIGHT=" + height);
	}
	document.write(">");
}
/*
 * Create a popup plot of Maple code.
 */
function popupMaplePlot(maple, plot, type, libname, driver) {
	var url = getMaplePlotURL(maple, plot, type, libname, driver, null, null);

	openWindow(url, "maplepopup", "width=640,height=480,scrollbars=yes,resizable=yes");

}
/*
 * Utility method to perform URL escaping since there are problems with the
 * Javascript built-in function.
 */
function myEscape(s) {
	return encodeURIComponent(s);
}
/*
 * Generate a popup message
 */
function popupMessage(msg) {
	var w = openWindow("", "popup", "width=500,height=380,scrollbars=no,resizable=yes,status=no,location=no,dependent=yes");
	var d = w.document;
	d.open("text/html");
	d.writeln("<HTML>");
	d.writeln("<HEAD>");
	d.writeln("</HEAD>");
	d.writeln("<BODY>");
	d.writeln("<TABLE ALIGN=\"CENTER\">");
	d.writeln("<TR VALIGN=\"CENTER\"><TD>");
	d.writeln(msg);
	d.writeln("</TD></TR>");
	d.writeln("</TABLE>");
	d.writeln("</BODY>");
	d.writeln("</HTML>");
	d.close();
}
var _preview = null;
var _previewEq = null;
function previewFormula(quesName, s, m, l, fromQE) {
	//var platf = navigator.platform;
	//var useJava = (platf != null) && (platf.indexOf("Win32") == 0 || platf.indexOf("Linux") == 0);
	var elem =$('input[name="' + quesName +'"]')[0], f = (typeof elem !== 'undefined') ? elem.value : null, b = myEscape(f);
	_previewEq = f;	
	if (_preview != null) {
		_preview.close();
	}

	if (typeof m === "undefined") {
		m = "";
	}
	if (typeof l === "undefined") {
		l = "";
	}
	var requestParam = 'eq=' + b + '&actionID=' + s + '&maple=' + myEscape(m) + '&libname=' + myEscape(l) + '&', requestUrl=getBaseURL();
	requestUrl += (typeof fromQE !== 'undefined' && fromQE == 'true') ? 'ws/launcher.do?wsActionID=questionPreviewFormula&wsQuestionEngine=true&' :  'modules/preview.Preview?';
		
	_preview = openWindow(requestUrl + requestParam, "previewer", "width=350,height=200,scrollbars,resizable");
	// _preview.resizeTo(350, 200);
}
function previewChemistry(f) {
	var b = myEscape(f);
	openWindow(getBaseURL() + "modules/preview.Preview?actionID=chemistry&eq=" + b, "previewer", "width=300,height=175,resizable");
}
/*
 * Holds a pointer to an inline question's webeq input control applet. Used by
 * popupMathToolbar() (below) and the JS in mathEditor/toolbar.html.
 */
var _math_toolbar_target;
/*
 * Pop up a toolbar window which writes templates to a webeq IC. Used by the
 * Inline question.
 */
function popupMathToolbar(name) {
	_math_toolbar_target = document[name + ".sro"];
	openWindow(getBaseURL() + "modules/mathEditor/toolbar.html", "math_editor_toolbar", "width=240,height=50");
}
/*
 * Pop up a toolbar window which writes templates to a webeq IC. Used by the
 * Inline question.
 */
function popupChemToolbar(name) {
	_math_toolbar_target = document[name + ".sro"];
	openWindow(getBaseURL() + "modules/mathEditor/chem_toolbar.html", "math_editor_toolbar", "width=240,height=50");
}
/*
 * Popup describing EDU server, version, etc.
 */
function aboutPopup(server_url) {
	openWindow(server_url+"About.do", "version_info", "width=350,height=250,resizable,scrollbars");
}
/*
 * Warning that the session timeout is close to expiring.
 */
function warnOfImminentSessionTimeout(k) {
	clearInterval(_sessionTimeoutTimerID);
	//var timestamp = new Date();
	alert("" + msgMainScriptImminentSessionTimeoutWarningPart1 + 
			(k / (60 * 1000)) + 
			"" + msgMainScriptImminentSessionTimeoutWarningPart2 + 
			"" + (new Date()).toLocaleString());
}
var _sessionTimeoutTimerID = 0;
function startSessionTimeoutWarningTimer(timeout) {
	var k = 5 * 60 * 1000;
	var t = timeout - k;
	if (t < 0) {
		t = timeout / 2;
	}
	_sessionTimeoutTimerID = setInterval("warnOfImminentSessionTimeout(" + k + ")", t);
}
/*
 * Get a handle to the object matching the given name
 */
function findObj(n, d) {
	var p, i, x;
	if (!d) {
		d = document;
	}
	if ((p = n.indexOf("?")) > 0 && parent.frames.length) {
		d = parent.frames[n.substring(p + 1)].document;
		n = n.substring(0, p);
	}
	if (!(x = d[n]) && d.all) {
		x = d.all[n];
	}
	for (i = 0; !x && i < d.forms.length; i++) {
		x = d.forms[i][n];
	}
	for (i = 0; !x && d.layers && i < d.layers.length; i++) {
		x = findObj(n, d.layers[i].document);
	}
	if (!x && d.getElementById) {
		x = d.getElementById(n);
	}
	return x;
}
/*
 * Change the visibility of the style element to be hidden
 */
function hide(objName) {
	obj = findObj(objName);
	if (obj.style) {
		obj.style.visibility = "hidden";
	}
}
/*
 * Change the visibility of the style element to be visible
 */
function show(objName) {
	obj = findObj(objName);
	if (obj.style) {
		obj.style.visibility = "visible";
	}
}
/*
 * This method installs CSS to enable (certain browsers) to display scrollable
 * tables. The method must be called in the document's <head>. The feature is
 * enabled for Mozilla/Firefox based on Gecko 1.7 or better, and for MSIE 6.0.
 * Usage: Wrap the table in a div.scrollableTableWrapper and include the
 * scrollable body in <tbody>: <div class="scrollableTableWrapper"> <table>
 * <thead><tr><td>Planes</td><td>Trains</td><td>Automobiles</td></tr></thead>
 * <tbody> <tr><td>3</td><td>2</td><td>1</td></tr> <tr><td>1</td><td>2</td><td>1</td></tr>
 * <tr><td>3</td><td>4</td><td>1</td></tr> etc... </tbody> </table>
 * </div>
 */
function deployScrollableTableFeature() {
	var browser = getBrowserCategory();

	if (browser == "gecko") {
		document.writeln("<style type='text/css'> ");
		document.writeln("  div.scrollableTableWrapper tbody {  ");
		document.writeln("    overflow: auto;  ");
		document.writeln("    height: 35em;  ");
		document.writeln("  } ");
		document.writeln("</style>");
	} else {
		if (browser == "ie") {
			document.writeln("<style type='text/css'> ");
			document.writeln("  div.scrollableTableWrapper { ");
			document.writeln("    clear: left; ");
			document.writeln("    float:left; ");
			document.writeln("    height:250px; ");
			document.writeln("    width:100%; ");
			document.writeln("    overflow:scroll; ");
			document.writeln("  } ");
			document.writeln("  div.scrollableTableWrapper table th { ");
			document.writeln("    position: relative; ");
			document.writeln("    background:#f7f7f7; ");
			document.writeln("  } ");
			document.writeln("  div.scrollableTableWrapper table { ");
			document.writeln("    margin-right:16px; ");
			document.writeln("   } ");
			document.writeln("</style>");
		}
	}
}

function getBrowserCategory()
{
	var browser = "unavailable";
	if (navigator.userAgent.indexOf("MSIE") >= 0) {
		browser = "ie";
	} else {
		if (navigator.userAgent.indexOf("Gecko") >= 0) {
			var re = /rv:(\d+\.\d+)/;
			var m = re.exec(navigator.userAgent);
			if (m != null) {
				var v = parseFloat(m[1]);
				if (v >= 1.7) {
					browser = "gecko";
				}
			}
		}
	}

	return browser;
}

function BrowserCheck() {
	var b = navigator.appName;
	if (b == "Microsoft Internet Explorer") {
		this.b = "ie";
	} else {
		this.b = b;
	}
	this.v = parseInt(navigator.appVersion);
	this.ie = (this.b == "ie" && this.v >= 4);
	this.ie4 = (navigator.userAgent.indexOf("MSIE 4") > 0);
	this.ie5 = (navigator.userAgent.indexOf("MSIE 5") > 0);
}
is = new BrowserCheck();
selectAllItems = function (obj) {
	var check = obj.checked;
	var boxes = document.getElementsByName("selectedItems");
	for (var i = 0; i < boxes.length; i++) {
		boxes[i].checked = check;
	}
};

//override the back button if the history is empty, meaning the window
//is brand new and should be closed
function sidebarBack() {
	if (history.length <= 1) {
		closeWindow();
	} else {
		history.back();
	}
}

/*
 * Checks for double-clicks on the test screen. Checks Grade button only for
 * now.
 */
function firstClick(action) {
	var status;

//	if (action != "grade")
//	return true;

	if (clickCounter != 1)
		status=true;
	else
		status=false;

	clickCounter=1;
	return status;
}

function isAssignmentWindowClosed(){
	if( getUsingLockdown() )
	{


		return readCookie("inLockdownAssignment") != "true";
	}else{
		return (edu_window == null || edu_window.closed);
	}
}

function doAssignment(id,tn,timed,isPractice) {
	if (!firstClick("")) {
		return;
	}
	var f = document.forms["edu_form"];
	var url = getBaseURL()+"modules/test.Test?className=" + className + "&testName=" + encodeURIComponent(tn) + "&testId=" + id;

	if (isAssignmentWindowClosed() ) {
		var accept;
		if( timed && !isPractice) {
			accept = confirm(msgMainScriptTimedAssignmentWarning);
		}
		else {
			accept = true;
		}
		if( accept ) {
			edu_window = openWindow(url, "assignment_window", "scrollbars,resizable");
		}
	} else {
		alert(msgMainScriptFinishOtherAssignmentFirst);
		focusWindow(edu_window);
	}
	clickCounter=0;

	// setInAssignment(true);
}

function doStudentExternal(aid) {
	if (!firstClick("")) {
		return;
	}
	var url = getBaseURL()+"contentmanager/RubricList.do?actionID=preview&assignmentId=" + aid;
	openWindow(url, "external_window", "width=800,height=600,scrollbars=yes,resizable=yes");
	clickCounter=0;
}

function doInstructorExternal(id) {
	if (!firstClick("")) {
		return;
	}
	var url = getBaseURL()+"gradebook/External.do?asgnId="+id;
	openWindow(url, "external_window", "width=800,height=600,scrollbars=yes,resizable=yes");
	clickCounter=0;
}

function doRubricGrade(trId) {
	if (extmodified) {
		alert(AddExternalFormSaveBeforeGradingMsg);
		return;
	}
  	var url = getBaseURL()+ "contentmanager/RubricList.do?";
  	url += "actionID=grade";
  	url += "&trId=" + trId;
  	openWindow(url, "rubricView", "width=800,height=600,scrollbars=yes,resizable=yes");
}

function showAssignmentPolicies(id,tn) {
	var url = getBaseURL()+"modules/test.ShowPolicies?className=" + className + "&testName=" + encodeURIComponent(tn) + "&testId=" + id;
	openWindow(url, "show_policies_window","width=400,height=300,scrollbars,resizable");
}

/*
 * Opens a new window and sets the focus on the window Use this function instead
 * of window.open(...).focus() to avoid problems with the Lockdown browser
 */
function openWindow(url, name, features)
{

	if( !getUsingLockdown()){
		var win = window.open( url, name, features );
		
		if( win != null ){
			win.focus();
		}


		return win;
	}else{
		win = window.open (url);



		return null;
	}

}

/*
 * Focuses the given window if it is not null; otherwise, does nothing.
 */
function focusWindow(win)
{
	if( win != null)
	{
		win.focus();
	}
}

/*
 * Closes the current window. Use this instead of window.close() to avoid
 * problems with the Lockdown browser
 */
function closeWindow()
{
	if( getUsingLockdown()){
		// Close window by navigating to special url
		window.location = "CLOSEMETA.html";
	}else{
		window.close();
	}
}

//Set the size of the #holder div to handle the sperate scrolling
function setHolderSize()
{
	if (typeof wsQuestionEngine != 'undefined' && wsQuestionEngine == true) {
		return;
	}

	var topHeight = $('#top').height();
	var height = $(document).height() - topHeight;

	var width = $(document).width();

	$('#holder').css('height', height );
	$('#holder').css('width', width );

	$('#title').show();
	$('#logo').show();
	$('#poweredBy').show();
	$('.crumbTrail').show();	

	if( width < 950 )
	{
		$('#poweredBy').hide();
	}

	if( width < 780 )
	{
		$('#title').hide();
		$('.crumbTrail').hide();
	}

	if( width < 390 )
	{

		$('#logo').hide();
	}           

}

function resetSelectDialog(){
	var currentValue = readCookie("useMathEditor");

	if( currentValue == "true")
	{
		$('#symbol').attr("checked", true);
	}else{
		$('#text').attr("checked", true);
	}

}

function displayPopupDialog(title, url,width,height){
	$('#pageDialog').load(url, function(){	
		try{
		$('#pageDialog').dialog("destroy");
		}catch(ex){}
		
		$('#pageDialog').dialog(  { 
			"title": title,
			"resizable": false,
			"width": width,
			"height": height,
			"open": function(){
				setAppletsEnabled($(this).closest(".ui-dialog")[0], false);	
			},
			"beforeclose": function(){
				setAppletsEnabled($(this).closest(".ui-dialog")[0]);
			},
			"beforeClose": function(){
				setAppletsEnabled($(this).closest(".ui-dialog")[0]);
			},
			"buttons": {"Ok": function() {


				$(this).dialog("close");


			}}
		});


	});

}

function loadMathSelect()
{
	var selectDialogUrl = getBaseURL() + "mathEditor/select.do";

	$('#pageDialog').html("<div id='changeMathContainer'>&nbsp</div>");
	
	$('#changeMathContainer').load(selectDialogUrl, function(){

		
		
		resetSelectDialog();

		try{
			$('#pageDialog').dialog("destroy");
		}catch(ex){}
			
		$('#pageDialog').dialog(  { 
			"title": "Change Math Entry Mode",
			"resizable": false,
			"width": 410,
			"height": 520,
			"open": function(){
				setAppletsEnabled($(this).closest(".ui-dialog")[0], false);
			},
			"buttons": {"Ok": function() {

				if($('#symbol:checked').length > 0 )
				{
					document.cookie="useMathEditor=true; path=/;";
				}else{
					document.cookie="useMathEditor=false; path=/;";
				}
				$(this).dialog("close");

				// Reload the window to get the new editor
				doAction("refresh");
			}
		,
		"Cancel": function() { 
			// Set the radio buttons to their original state
			resetSelectDialog();
			
			setAppletsEnabled($(this).closest(".ui-dialog")[0]);
			
			$(this).dialog("close"); }
			} });

		$('#pageDialog').dialog("open");


	});
}

function stopRightClick(){
	// Stop the right click menu from appearing
	document.oncontextmenu = function(){
		return false;
	};
}

function labelDiv(div){
	
	if( !$(div).hasClass('labelled')){
	var numberPattern = /\d+/g;
	
	var labels = $('.centered', div);
	
	for (var i = 0; i < labels.length; i++) {
		  var curLabel = labels[i];
		  
		  if( curLabel != null  ){
	  		  
			  var width = $(curLabel).width();
			  
			  var oldLeft = parseInt( $(curLabel).css('left').match(numberPattern)[0] );
			  var newLeft = oldLeft - width/2;
			  
			  $(curLabel).css('left', newLeft);
		  }
	}
		$(div).addClass('labelled');
	}
	
}

function displayLabelledDivs(){
	var labels = $('.labelledImage');
	
	for (var i = 0; i < labels.length; i++) {
		  var curLabel = labels[i];
		  
		  labelDiv(curLabel);
		  
	}
}


$(function(){

	$("#pageMessage").appendTo("#top");

	if (typeof wsQuestionEngine != 'undefined' && wsQuestionEngine == true) {
		MGH_resize2();
	} else {
		setHolderSize();
		$(window).bind('resize', function(){ setHolderSize(); } );   
	}

	if( $("#title").width() <  312)
	{
		// Set the title width to ensure full gradient visible
		$("#title").css('width', 312);
	}else if( $("#title").width() >  400 ){
		$("#title").css('width', 400);
	}


	if( $('#welcome').width() > 200 ){
		$('#welcome').css('width', 200);
	}

	$('.changeMathMode').click(function(){

		loadMathSelect();

		return false;
	});

	
	displayLabelledDivs();
	
	// Hide the question menu by default, show it in initControlbar when jumping
	// to questions is enabled
	var jumpList = $('#jump');	

	if( $(jumpList).length > 0  )
	{
		questionMenu = $(jumpList).parent().parent().parent().parent().parent();
		$(questionMenu).hide();
	}

	// Force the body margin to override Blackboard CSS
	$('body').css('margin', 0);

});


function showAllDynamicAttempts(id) { 
	var toggle = document.getElementById('toggle_attempts_'+id);
	var c=0;
	var att=document.getElementById('attempts'+id+'_'+c);
	while( att ) {
		att.style.display = toggle.checked ? 'block' : 'none';
		c++;
		att=document.getElementById('attempts'+id+'_'+c);
	}
}

function MGH_resize2() {
	if (typeof MathJax.isReady != 'undefined' && MathJax.isReady && MathJax.Hub.queue.queue.length == 0) {
		wsExpanded = false;
		MGH_resize();
//		MathJax.Hub.queue.Push("MGH_resize");
	} else {
		window.setTimeout("MGH_resize2();", 1000);
	}
}

function MGH_resize() {
	if (wsExpanded || typeof parent.wsQuestionEngine != 'undefined') {
		return;
	}

	var newWidth = document.forms[0].scrollWidth + 50;
	var newHeight = document.forms[0].scrollHeight + 200;
	
	newWidth = (newWidth > 900 ? newWidth : 900);
	newHeight = (newHeight > 900 ? newHeight : 900);

	EZ.resize(newWidth, newHeight);
	wsExpanded = true;
	
	$('#holder').css('width', '100%');
	$('#holder').css('height', '100%');
	
}

/*disable or hide applets when a modal is open, and enable or show them when the modal is closed*/
function setAppletsEnabled(dialog, enabled){
	var $applets = $('applet');
	if($applets.length == 0 ) return;	
	enabled = typeof enabled === 'undefined' ? true : enabled;
	
	showAppletOverIframe(dialog, !enabled);
	for(var i=0; i<$applets.length; i++){
		if(typeof $applets[i].setEnabled === 'function'){
			$applets[i].setEnabled(enabled);
		}else{
			$($applets[i]).css('visibility', enabled ? 'visible' : 'hidden');
		}
	}	
}

function showAppletOverIframe(elem, state){           
    var IfrRef = document.getElementById('DivShim');
    if(IfrRef == null){
    	var divShim = document.createElement('iframe');
    	$(divShim).attr({'id': 'DivShim', 'src': 'javascript:return "";', 'scrolling': 'no', 'frameborder':'0'});
    	$(divShim).css({'position':'absolute', 'display':'none'});
    	document.body.appendChild(divShim);
    	IfrRef = divShim;
    }
    if(state){
     IfrRef.style.width = elem.offsetWidth + "px";
     IfrRef.style.height = elem.offsetHeight + "px";
     IfrRef.style.top = elem.style.top ;
     IfrRef.style.left = elem.style.left;
     IfrRef.style.zIndex = 100;
     IfrRef.style.display = "block";
    }else{
     IfrRef.style.display = "none";
    }
}


