/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class JavaCallbackListener {
    public static final String ERROR_CLASS_ACCESS = "Access to this class is not allowed.";
    public static final String ERROR_NUM_ARGS = "Number of actual arguments does not match signature.";
    public static final String ERROR_ARG_TYPE = "Argument type doesn't match signature.";
    public static final String ERROR_UNEXPECTED = "An unexpected error occurred: ";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean processJava(KernelEvent event) {
        Dag eventDag = event.getDag();
        String className = eventDag.getChild(0).getData();
        String methodName = eventDag.getChild(1).getData();
        String signature = eventDag.getChild(2).getData();
        Dag argumentDag = eventDag.getChild(3);
        if (!className.startsWith("com.maplesoft.")) {
            event.setResponseAsDag(DagUtil.createErrorDag(ERROR_CLASS_ACCESS));
            return true;
        }
        try {
            Class<?> theClass = Class.forName(className);
            Class[] classObjects = JavaCallbackListener.getClassObjects(signature);
            Method theMethod = theClass.getMethod(methodName, classObjects);
            Object[] objects = new Object[classObjects.length];
            if (argumentDag.getLength() != classObjects.length) {
                event.setResponseAsDag(DagUtil.createErrorDag(ERROR_NUM_ARGS));
                return true;
            }
            if (classObjects != null) {
                int i = 0;
                while (i < classObjects.length) {
                    objects[i] = JavaCallbackListener.getObjectFromDag(argumentDag.getChild(i), classObjects[i]);
                    if (objects[i] == null) {
                        event.setResponseAsDag(DagUtil.createErrorDag(ERROR_ARG_TYPE));
                        return true;
                    }
                    ++i;
                }
            }
            Object returnVal = theMethod.invoke(theClass, objects);
            Object response = null;
            Dag dagResponse = null;
            if (returnVal instanceof String) {
                dagResponse = DagUtil.createStringDag((String)returnVal);
            } else if (returnVal instanceof Boolean) {
                dagResponse = DagUtil.createNameDag(((Boolean)returnVal).toString());
            } else if (returnVal instanceof Byte) {
                dagResponse = DagUtil.createIntDag(((Byte)returnVal).intValue());
            } else if (returnVal instanceof Character) {
                dagResponse = DagUtil.createStringDag(((Character)returnVal).toString());
            } else if (returnVal instanceof Short) {
                dagResponse = DagUtil.createIntDag(((Short)returnVal).intValue());
            } else if (returnVal instanceof Integer) {
                dagResponse = DagUtil.createIntDag((Integer)returnVal);
            } else if (returnVal instanceof Long) {
                dagResponse = DagUtil.createIntDag((Long)returnVal);
            } else if (returnVal instanceof Float) {
                dagResponse = DagUtil.createFloatDag(((Float)returnVal).floatValue());
            } else if (returnVal instanceof Double) {
                dagResponse = DagUtil.createDoubleDag((Double)returnVal);
            }
            if (dagResponse == null) return true;
            String dotm = DagBuilder.createDotm(dagResponse);
            event.setResponseAsDotM(dotm);
            return true;
        }
        catch (Exception e) {
            event.setResponseAsDag(DagUtil.createErrorDag(ERROR_UNEXPECTED + e));
            return true;
        }
    }

    public static Class[] getClassObjects(String signature) {
        if (signature.charAt(0) != '(' || signature.length() < 2) {
            return null;
        }
        ArrayList<Class> classArray = new ArrayList<Class>();
        boolean foundEndOfArgs = false;
        int i = 1;
        while (true) {
            Class classObject = null;
            char type = signature.charAt(i);
            switch (type) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    classObject = JavaCallbackListener.getClassObject(Character.toString(type));
                    ++i;
                    break;
                }
                case 'L': {
                    int semicolon = signature.indexOf(59, i);
                    if (semicolon == -1) {
                        return null;
                    }
                    classObject = JavaCallbackListener.getClassObject(signature.substring(i, semicolon + 1));
                    i = semicolon + 1;
                    break;
                }
                case '[': {
                    return null;
                }
                case ')': {
                    foundEndOfArgs = true;
                    classObject = JavaCallbackListener.getClassObject(signature.substring(i + 1, signature.length()));
                    i = signature.length();
                    break;
                }
                default: {
                    return null;
                }
            }
            if (i == signature.length()) break;
            if (classObject == null) {
                return null;
            }
            classArray.add(classObject);
        }
        if (!foundEndOfArgs) {
            return null;
        }
        Object[] objects = classArray.toArray();
        if (objects.length == 0) {
            Class[] empty = new Class[]{};
            return empty;
        }
        Class[] classObjects = new Class[objects.length];
        int j = 0;
        while (j < objects.length) {
            classObjects[j] = (Class)objects[j];
            ++j;
        }
        return classObjects;
    }

    public static Class getClassObject(String signatureElem) {
        try {
            if (signatureElem == null || signatureElem.length() == 0) {
                return Class.forName("void");
            }
            char type = signatureElem.charAt(0);
            switch (type) {
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'L': {
                    return Class.forName(signatureElem.substring(1, signatureElem.length() - 1).replace('/', '.'));
                }
                case '[': {
                    return null;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getObjectFromDag(Dag argument, Class classObject) {
        String object = argument.getData();
        if (classObject.equals(String.class)) {
            return object;
        }
        if (classObject.equals(Boolean.TYPE)) {
            if (argument.getType() == 2 || argument.getType() == 1) {
                if (DagUtil.parseInt(argument) == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (argument.getType() == 7 || argument.getType() == 8) {
                return Boolean.valueOf(object);
            }
            return null;
        }
        if (classObject.equals(Byte.TYPE)) {
            if (argument.getType() == 2 || argument.getType() == 1) {
                return new Byte((byte)DagUtil.parseInt(argument));
            }
            if (argument.getType() == 7 || argument.getType() == 8) {
                return Byte.valueOf(object.substring(0, 1));
            }
            return null;
        }
        if (classObject.equals(Character.TYPE)) {
            return new Character(object.charAt(0));
        }
        if (classObject.equals(Short.TYPE)) {
            if (argument.getType() == 2 || argument.getType() == 1) {
                return new Short((short)DagUtil.parseInt(argument));
            }
            if (argument.getType() == 7 || argument.getType() == 8) {
                return Short.valueOf(object.substring(0, 1));
            }
            return null;
        }
        if (classObject.equals(Integer.TYPE)) {
            if (argument.getType() == 2 || argument.getType() == 1) {
                return new Integer(DagUtil.parseInt(argument));
            }
            if (argument.getType() == 7 || argument.getType() == 8) {
                return Integer.valueOf(object.substring(0, 1));
            }
            return null;
        }
        if (classObject.equals(Long.TYPE)) {
            if (argument.getType() == 2 || argument.getType() == 1) {
                return new Long(DagUtil.parseLong(argument));
            }
            if (argument.getType() == 7 || argument.getType() == 8) {
                return Long.valueOf(object.substring(0, 1));
            }
            return null;
        }
        if (classObject.equals(Float.TYPE)) {
            if (argument.getType() == 4) {
                long first = DagUtil.parseLong(argument.getChild(0));
                long second = DagUtil.parseLong(argument.getChild(1));
                return new Float((float)((double)first * Math.pow(10.0, second)));
            }
            if (argument.getType() == 3) {
                long first = DagUtil.parseLong(argument.getChild(0));
                long second = DagUtil.parseLong(argument.getChild(1));
                return new Float((float)first / (float)second);
            }
            return null;
        }
        if (classObject.equals(Double.TYPE)) {
            if (argument.getType() == 4) {
                long first = DagUtil.parseLong(argument.getChild(0));
                long second = DagUtil.parseLong(argument.getChild(1));
                return new Double((double)first * Math.pow(10.0, second));
            }
            if (argument.getType() == 3) {
                long first = DagUtil.parseLong(argument.getChild(0));
                long second = DagUtil.parseLong(argument.getChild(1));
                return new Double((double)first / (double)second);
            }
            return null;
        }
        return object;
    }
}

