/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.ClientReady;
import com.maplesoft.client.CommandQueue;
import com.maplesoft.client.KernelCommunicationError;
import com.maplesoft.client.KernelConnectionEvent;
import com.maplesoft.client.KernelConnectionListener;
import com.maplesoft.client.KernelInterfaceProperties;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.KernelPortReady;
import com.maplesoft.client.KernelProxy;
import com.maplesoft.client.MapleClientSocket;
import com.maplesoft.client.MapleServerSocket;
import com.maplesoft.client.RedirectedKernelListener;
import com.maplesoft.client.preprocessor.KernelInputPreprocessor;
import com.maplesoft.util.RuntimeLocale;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class KernelConnection {
    private static final boolean DEBUG_PRINT = false;
    private KernelProxy kernelProxy;
    MapleClientSocket clientSocket;
    MapleServerSocket serverSocket;
    private CommandQueue commandQueue;
    private Vector listeners;
    private KernelInterfaceProperties interfaceProperties;
    private RedirectedKernelListener redirectedListener = null;
    private static int startupPort = -1;

    public KernelConnection(KernelProxy kernel) {
        this.kernelProxy = kernel;
        this.commandQueue = new CommandQueue();
        this.listeners = new Vector();
        this.interfaceProperties = new KernelInterfaceProperties(this);
    }

    CommandQueue getQueue() {
        return this.commandQueue;
    }

    public void queueCommand(KernelProxy.KernelTransaction t) {
        this.commandQueue.push(t);
    }

    void queueUrgentCommand(KernelProxy.KernelTransaction t) {
        this.commandQueue.urgent(t);
    }

    public void sendCommand(KernelListener listener, String command, int how) {
        int len;
        command = command.trim();
        if (this.redirectedListener != null) {
            this.redirectedListener.writeInput(command);
        }
        if ((len = command.length()) >= 1) {
            String[] commands = KernelInputPreprocessor.preprocess(command, this);
            int i = 0;
            while (i < commands.length) {
                KernelProxy.KernelTransaction kt = this.kernelProxy.createTransaction(listener, commands[i], how);
                this.queueCommand(kt);
                ++i;
            }
        }
    }

    public void sendUrgentCommand(KernelListener listener, String command, int how) {
        int len;
        command = command.trim();
        if (this.redirectedListener != null) {
            this.redirectedListener.writeInput(command);
        }
        if ((len = command.length()) >= 1) {
            String[] commands = KernelInputPreprocessor.preprocess(command, this);
            int i = 0;
            while (i < commands.length) {
                KernelProxy.KernelTransaction kt = this.kernelProxy.createTransaction(listener, commands[i], how);
                this.queueUrgentCommand(kt);
                ++i;
            }
        }
    }

    public void sendInternalCommand(KernelListener listener, String command, int how) {
        int len;
        command = command.trim();
        if (this.redirectedListener != null) {
            this.redirectedListener.writeInput(command);
        }
        if ((len = command.length()) >= 1) {
            String[] commands = KernelInputPreprocessor.preprocess(command, this);
            int i = 0;
            while (i < commands.length) {
                KernelProxy.KernelTransaction kt = this.kernelProxy.createTransaction(listener, commands[i], how, true);
                this.queueCommand(kt);
                ++i;
            }
        }
    }

    public void sendUrgentInternalCommand(KernelListener listener, String command, int how) {
        int len;
        command = command.trim();
        if (this.redirectedListener != null) {
            this.redirectedListener.writeInput(command);
        }
        if ((len = command.length()) >= 1) {
            String[] commands = KernelInputPreprocessor.preprocess(command, this);
            int i = 0;
            while (i < commands.length) {
                KernelProxy.KernelTransaction kt = this.kernelProxy.createTransaction(listener, commands[i], how, true);
                this.queueUrgentCommand(kt);
                ++i;
            }
        }
    }

    public void setRedirectedListener(RedirectedKernelListener redirectedListener) {
        if (this.redirectedListener != null && this.redirectedListener != redirectedListener) {
            try {
                this.redirectedListener.getRedirector().closeFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.redirectedListener = redirectedListener;
    }

    public boolean hasEvaluationPending() {
        return !this.commandQueue.isEmpty();
    }

    public RedirectedKernelListener getRedirectedListener() {
        return this.redirectedListener;
    }

    public int getKernelID() {
        return ((KernelConnectionListener)this.listeners.get(0)).getKernelID();
    }

    public KernelInterfaceProperties getInterfaceProperties() {
        return this.interfaceProperties;
    }

    public void setInterfaceProperties(KernelInterfaceProperties interfaceProperties) {
        this.interfaceProperties = interfaceProperties;
    }

    public void addKernelConnectionListener(KernelConnectionListener listener) {
        this.listeners.add(listener);
    }

    public KernelConnectionListener removeKernelConnectionListener(KernelConnectionListener listener) {
        KernelConnectionListener removed = null;
        int index = 0;
        index = this.listeners.indexOf(listener);
        if (index > -1) {
            removed = (KernelConnectionListener)this.listeners.remove(index);
        }
        return removed;
    }

    void confirmListener(KernelConnectionListener listener) {
        if (this.listeners.indexOf(listener) == -1) {
            this.listeners.add(listener);
            listener.setConnection(this);
            listener.processConnection(new KernelConnectionEvent(1, 2, this, listener));
        }
    }

    public int getNumberKernelConnectionListeners() {
        return this.listeners.size();
    }

    public KernelConnectionListener[] getListeners() {
        return this.listeners.toArray(new KernelConnectionListener[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryShutdown(int kernelid) {
        boolean shutdown = false;
        if (this.getNumberKernelConnectionListeners() < 1) {
            KernelProxy.getInstance().shutdownConnection(kernelid);
            shutdown = true;
            if (this.commandQueue != null) {
                CommandQueue commandQueue = this.commandQueue;
                synchronized (commandQueue) {
                    this.commandQueue.clear();
                    this.commandQueue.notifyAll();
                }
                this.commandQueue = null;
            }
            if (this.listeners != null) {
                this.listeners.clear();
                this.listeners = null;
            }
            this.interfaceProperties = null;
            this.redirectedListener = null;
        }
        return shutdown;
    }

    public static void setServerPort(int port) {
        startupPort = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSockets() throws KernelCommunicationError {
        int port = -1;
        if (startupPort > 0) {
            port = startupPort;
            startupPort = -1;
        } else {
            KernelPortReady portReady = new KernelPortReady();
            this.serverSocket = new MapleServerSocket(portReady);
            this.serverSocket.setLanguage(RuntimeLocale.getDisplayEnvVariableName());
            Thread serverthread = new Thread(this.serverSocket);
            serverthread.start();
            KernelPortReady kernelPortReady = portReady;
            synchronized (kernelPortReady) {
                try {
                    while (!portReady.ready && !portReady.error) {
                        portReady.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int n = port = this.serverSocket != null ? this.serverSocket.getKernelPort() : -1;
        }
        if (port <= 0) {
            throw new KernelCommunicationError("Unable to open mserver");
        }
        this.startSockets(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSockets(int port) {
        ClientReady clientReady = new ClientReady();
        this.clientSocket = new MapleClientSocket(port, clientReady);
        this.clientSocket.setKernelProxy(this.kernelProxy);
        this.clientSocket.setKernelConnection(this);
        Thread clientthread = new Thread((Runnable)this.clientSocket, "WMI:MapleClientSocket:Kernel Connection ");
        try {
            clientthread.setDaemon(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        clientthread.start();
        ClientReady clientReady2 = clientReady;
        synchronized (clientReady2) {
            try {
                while (!clientReady.ready && !clientReady.failed) {
                    clientReady.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (clientReady.failed) {
                throw new KernelCommunicationError(this.clientSocket.errorState());
            }
        }
    }

    public int getPort() {
        int port = -1;
        if (this.clientSocket != null) {
            port = this.clientSocket.getPort();
        }
        return port;
    }

    public void stopSockets() {
        this.clientSocket.shutdown();
        if (this.serverSocket != null) {
            this.serverSocket.Shutdown(true);
        }
    }

    public synchronized boolean interrupt() throws KernelCommunicationError {
        return this.interrupt(true);
    }

    public synchronized boolean interrupt(boolean reportError) throws KernelCommunicationError {
        this.clearQueue();
        return this.clientSocket.interrupt(reportError);
    }

    public synchronized void toDebugMode() throws KernelCommunicationError {
        this.clientSocket.toDebugMode();
    }

    public synchronized void clearQueue() {
        if (this.commandQueue != null) {
            this.commandQueue.clear();
        }
    }

    public InputStream getClientInputStream() {
        return this.clientSocket.getSocketInputStream();
    }

    public OutputStream getClientOutputStream() {
        return this.clientSocket.getSocketOutputStream();
    }

    public String toString() {
        String listenerStr = "no listener";
        if (this.listeners.size() > 0) {
            listenerStr = String.valueOf(((KernelConnectionListener)this.listeners.get(0)).getKernelID() + 1);
        }
        return "KernelConnection: Server " + listenerStr;
    }

    public void setClientSocket(MapleClientSocket clientSocket) {
        this.clientSocket = clientSocket;
    }
}

