/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelInterfacePropertiesChangeEvent;
import com.maplesoft.client.KernelInterfacePropertiesChangeListener;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.preprocessor.PreprocessorSubstitutionTable;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class KernelInterfaceProperties {
    public static final int LPRINT = 0;
    public static final int TTY = 1;
    public static final int J2D_LABEL = 2;
    public static final int J2D_NO_LABEL = 3;
    public static final int DOTM = 4;
    public static final int XML_PRE_NORMALIZE = 5;
    public static final int XML_POST_NORMALIZE = 6;
    public static final int DAG_TOSTRING = 7;
    public static final int DAG_TOSTRING_NORMALIZE = 8;
    public static final String INFINITY_STRING = "infinity";
    public static final String PROPERTY_ANSI = "ansi";
    public static final String PROPERTY_CURRENTDIR = "currentdir";
    public static final String PROPERTY_DIGIT_ELISION_AFTER = "elisiondigitsafter";
    public static final String PROPERTY_DIGIT_ELISION_BEFORE = "elisiondigitsbefore";
    public static final String PROPERTY_DIGIT_ELISION_THRESHOLD = "elisiondigitsthreshold";
    public static final String PROPERTY_DISPLAY_PRECISION = "displayprecision";
    public static final String PROPERTY_ECHO = "echo";
    public static final String PROPERTY_ERROR_BREAK = "errorbreak";
    public static final String PROPERTY_ERROR_CURSOR = "errorcursor";
    public static final String PROPERTY_IMAGINARY_UNIT = "imaginaryunit";
    public static final String PROPERTY_INDENT_AMOUNT = "indentamount";
    public static final String PROPERTY_LABELLING = "labelling";
    public static final String PROPERTY_LABEL_WIDTH = "labelwidth";
    public static final String PROPERTY_LATEX_WIDTH = "latexwidth";
    public static final String PROPERTY_LONG_DELIM = "longdelim";
    public static final String PROPERTY_PLOT_DEVICE = "plotdevice";
    public static final String PROPERTY_PLOT_DRIVER = "plotdriver";
    public static final String PROPERTY_PLOT_OPTIONS = "plotoptions";
    public static final String PROPERTY_PLOT_OUTPUT = "plotoutput";
    public static final String PROPERTY_POSTPLOT = "postplot";
    public static final String PROPERTY_PREPLOT = "preplot";
    public static final String PROPERTY_PRETTYPRINT = "prettyprint";
    public static final String PROPERTY_PROMPT = "prompt";
    public static final String PROPERTY_QUIET = "quiet";
    public static final String PROPERTY_RTABLE_SIZE = "rtablesize";
    public static final String PROPERTY_SCREEN_HEIGHT = "screenheight";
    public static final String PROPERTY_SCREEN_WIDTH = "screenwidth";
    public static final String PROPERTY_SHOW_ASSUMED = "showassumed";
    public static final String PROPERTY_TERM_ELISION_AFTER = "elisiontermsafter";
    public static final String PROPERTY_TERM_ELISION_BEFORE = "elisiontermsbefore";
    public static final String PROPERTY_TERM_ELISION_THRESHOLD = "elisiontermsthreshold";
    public static final String PROPERTY_TYPESETTING = "typesetting";
    public static final String PROPERTY_TYPESETTING_OFF = "standard";
    public static final String PROPERTY_TYPESETTING_ON = "extended";
    public static final String PROPERTY_USE_CLIENT_JVM = "useclientjvm";
    public static final String PROPERTY_VERBOSE_PROC = "verboseproc";
    public static final String PROPERTY_VERSION = "version";
    public static final String PROPERTY_WARN_LEVEL = "warnlevel";
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    private PreprocessorSubstitutionTable subsTable;
    private static final String VERSION_NAME = "Standard Worksheet Interface";
    private static final String VERSION_NUM = "Maple 10";
    private static final String VERSION_OS = System.getProperty("os.name");
    private static final String VERSION_DATE = "August 11 2010";
    private static final String VERSION_BUILD_SEP = " Build ID ";
    private static final int VERSION_BUILDID = 999999;
    private static final String VERSION_SEP = ", ";
    private static final String VERSION = "Standard Worksheet Interface, Maple 10, " + VERSION_OS + ", " + "August 11 2010" + " Build ID " + 999999;
    private static Object[] propertyInitTable = new Object[]{"ansi", DagUtil.createNameDag("false"), new BooleanValidator(), "currentdir", DagUtil.createStringDag(KernelInterfaceProperties.getInitCurrentDir()), new BaseValidator(), "elisiondigitsafter", DagUtil.createIntDag(100), new PositiveIntegerValidator(), "elisiondigitsbefore", DagUtil.createIntDag(100), new PositiveIntegerValidator(), "elisiondigitsthreshold", DagUtil.createIntDag(10000), new InfinityPositiveIntegerValidator(), "displayprecision", DagUtil.createIntDag(-1), new IntegerRangeValidator(-1, 100), "echo", DagUtil.createIntDag(1), new IntegerRangeValidator(0, 4), "errorbreak", DagUtil.createIntDag(1), new IntegerRangeValidator(0, 2), "errorcursor", DagUtil.createNameDag("false"), new BooleanValidator(), "imaginaryunit", DagUtil.createNameDag("I"), new BaseValidator(), "indentamount", DagUtil.createIntDag(4), new PositiveIntegerValidator(), "labelling", DagUtil.createNameDag("true"), new BooleanValidator(), "labelwidth", DagUtil.createIntDag(20), new PositiveIntegerValidator(), "latexwidth", DagUtil.createFloatDag(5.0f), new DoubleRangeValidator(0.0, 100.0), "longdelim", DagUtil.createNameDag("true"), new BooleanValidator(), "plotdevice", DagUtil.createStringDag("inline"), new BaseValidator(), "plotdriver", DagUtil.createStringDag("openviz"), new ReadOnlyValidator(), "plotoptions", DagUtil.createStringDag(""), new BaseValidator(), "plotoutput", DagUtil.createStringDag("terminal"), new BaseValidator(), "postplot", DagUtil.createStringDag(""), new BaseValidator(), "preplot", DagUtil.createStringDag(""), new BaseValidator(), "prettyprint", DagUtil.createIntDag(3), new IntegerRangeValidator(0, 3), "prompt", DagUtil.createStringDag("> "), new BaseValidator(), "quiet", DagUtil.createNameDag("false"), new BooleanValidator(), "rtablesize", DagUtil.createIntDag(10), new InfinityPositiveIntegerValidator(), "screenheight", DagUtil.createIntDag(25), new IntegerRangeValidator(1, 9999), "screenwidth", DagUtil.createIntDag(79), new IntegerRangeValidator(10, 9999), "showassumed", DagUtil.createIntDag(1), new IntegerRangeValidator(0, 2), "elisiontermsafter", DagUtil.createIntDag(100), new PositiveIntegerValidator(), "elisiontermsbefore", DagUtil.createIntDag(100), new PositiveIntegerValidator(), "elisiontermsthreshold", DagUtil.createIntDag(10000), new InfinityPositiveIntegerValidator(), "typesetting", DagUtil.createNameDag("standard"), new TypesetValidator(), "useclientjvm", DagUtil.createNameDag("true"), new BooleanValidator(), "verboseproc", DagUtil.createIntDag(1), new IntegerRangeValidator(0, 3), "version", DagUtil.createNameDag(VERSION), new ReadOnlyValidator(), "warnlevel", DagUtil.createIntDag(3), new IntegerRangeValidator(0, 4)};
    private static HashMap defaultMap = new HashMap();
    private static String[] retainsValueOnReset;
    private static String[] aliasTable;
    private HashMap propertyMap = new HashMap();
    private LinkedList changeListeners = new LinkedList();
    private static HashMap aliasMap;
    private static HashMap validatorMap;
    private static HashSet retainedPropertySet;
    private KernelConnection user;

    static {
        int i = 0;
        while (i < propertyInitTable.length) {
            String prop = (String)propertyInitTable[i];
            Dag value = (Dag)propertyInitTable[i + 1];
            defaultMap.put(prop, value);
            i += 3;
        }
        retainsValueOnReset = new String[]{PROPERTY_DISPLAY_PRECISION, PROPERTY_LATEX_WIDTH, PROPERTY_PLOT_DEVICE, PROPERTY_PLOT_OUTPUT, PROPERTY_PRETTYPRINT, PROPERTY_SHOW_ASSUMED, PROPERTY_VERSION, PROPERTY_DIGIT_ELISION_THRESHOLD, PROPERTY_DIGIT_ELISION_BEFORE, PROPERTY_DIGIT_ELISION_AFTER, PROPERTY_TERM_ELISION_THRESHOLD, PROPERTY_TERM_ELISION_BEFORE, PROPERTY_TERM_ELISION_AFTER, PROPERTY_PLOT_DRIVER};
        aliasTable = new String[]{"Ansi", PROPERTY_ANSI, "ANSI", PROPERTY_ANSI, "CurrentDir", PROPERTY_CURRENTDIR, "currentDir", PROPERTY_CURRENTDIR, "displayPrecision", PROPERTY_DISPLAY_PRECISION, "DisplayPrecision", PROPERTY_DISPLAY_PRECISION, "Echo", PROPERTY_ECHO, "errorBreak", PROPERTY_ERROR_BREAK, "ErrorBreak", PROPERTY_ERROR_BREAK, "errorCursor", PROPERTY_ERROR_CURSOR, "ErrorCursor", PROPERTY_ERROR_CURSOR, "imaginaryUnit", PROPERTY_IMAGINARY_UNIT, "ImaginaryUnit", PROPERTY_IMAGINARY_UNIT, "indentAmount", PROPERTY_INDENT_AMOUNT, "IndentAmount", PROPERTY_INDENT_AMOUNT, "Labelling", PROPERTY_LABELLING, "latexWidth", PROPERTY_LATEX_WIDTH, "LatexWidth", PROPERTY_LATEX_WIDTH, "longDelim", PROPERTY_LONG_DELIM, "LongDelim", PROPERTY_LONG_DELIM, "plotDevice", PROPERTY_PLOT_DEVICE, "PlotDevice", PROPERTY_PLOT_DEVICE, "plotOptions", PROPERTY_PLOT_OPTIONS, "PlotOptions", PROPERTY_PLOT_OPTIONS, "plotOutput", PROPERTY_PLOT_OUTPUT, "PlotOutput", PROPERTY_PLOT_OUTPUT, "prePlot", PROPERTY_PREPLOT, "PrePlot", PROPERTY_PREPLOT, "postPlot", PROPERTY_POSTPLOT, "PostPlot", PROPERTY_POSTPLOT, "prettyPrint", PROPERTY_PRETTYPRINT, "PrettyPrint", PROPERTY_PRETTYPRINT, "Prompt", PROPERTY_PROMPT, "Quiet", PROPERTY_QUIET, "rTableSize", PROPERTY_RTABLE_SIZE, "RTableSize", PROPERTY_RTABLE_SIZE, "RtableSize", PROPERTY_RTABLE_SIZE, "screenHeight", PROPERTY_SCREEN_HEIGHT, "ScreenHeight", PROPERTY_SCREEN_HEIGHT, "screenWidth", PROPERTY_SCREEN_WIDTH, "ScreenWidth", PROPERTY_SCREEN_WIDTH, "showAssumed", PROPERTY_SHOW_ASSUMED, "ShowAssumed", PROPERTY_SHOW_ASSUMED, "verboseProc", PROPERTY_VERBOSE_PROC, "VerboseProc", PROPERTY_VERBOSE_PROC, "Version", PROPERTY_VERSION, "warnLevel", PROPERTY_WARN_LEVEL, "WarnLevel", PROPERTY_WARN_LEVEL, "labeling", PROPERTY_LABELLING, "Labeling", PROPERTY_LABELLING, "Labelling", PROPERTY_LABELLING, "ElisionThreshold", PROPERTY_DIGIT_ELISION_THRESHOLD, "elisionthreshold", PROPERTY_DIGIT_ELISION_THRESHOLD, "ElisionDigitsThreshold", PROPERTY_DIGIT_ELISION_THRESHOLD, "ElisionDigitsAfter", PROPERTY_DIGIT_ELISION_AFTER, "ElisionDigitsBefore", PROPERTY_DIGIT_ELISION_BEFORE, "TermElisionThreshold", PROPERTY_TERM_ELISION_THRESHOLD, "termelisionthreshold", PROPERTY_TERM_ELISION_THRESHOLD, "ElisionTermsThreshold", PROPERTY_TERM_ELISION_THRESHOLD, "elisiontermthreshold", PROPERTY_TERM_ELISION_THRESHOLD, "termelisionafter", PROPERTY_TERM_ELISION_AFTER, "termelisionbefore", PROPERTY_TERM_ELISION_BEFORE, "TermElisionAfter", PROPERTY_TERM_ELISION_AFTER, "TermElisionBefore", PROPERTY_TERM_ELISION_BEFORE, PROPERTY_TERM_ELISION_AFTER, PROPERTY_TERM_ELISION_AFTER, PROPERTY_TERM_ELISION_BEFORE, PROPERTY_TERM_ELISION_BEFORE, "ElisionTermsAfter", PROPERTY_TERM_ELISION_AFTER, "ElisionTermsBefore", PROPERTY_TERM_ELISION_BEFORE, "UseClientJVM", PROPERTY_USE_CLIENT_JVM, "Typesetting", PROPERTY_TYPESETTING, "plotDriver", PROPERTY_PLOT_DRIVER, "PlotDriver", PROPERTY_PLOT_DRIVER};
        aliasMap = new HashMap();
        validatorMap = new HashMap();
        retainedPropertySet = new HashSet();
        i = 0;
        while (i < aliasTable.length) {
            aliasMap.put(aliasTable[i], aliasTable[++i]);
            ++i;
        }
        i = 0;
        while (i < retainsValueOnReset.length) {
            retainedPropertySet.add(retainsValueOnReset[i]);
            ++i;
        }
    }

    public static String getVersionDate() {
        return VERSION_DATE;
    }

    public static int getVersionBuildID() {
        return 999999;
    }

    private static String getInitCurrentDir() {
        String encoded;
        String currentdir = System.getProperty("user.dir");
        if (RuntimePlatform.isWindows() && !currentdir.equals(encoded = RuntimeLocale.getExportEncoder().fromUnicode(currentdir))) {
            String javahome = System.getProperty("java.home");
            currentdir = String.valueOf(javahome.charAt(0)) + ":\\\\";
        }
        return currentdir;
    }

    public KernelInterfaceProperties(KernelConnection user) {
        int i = 0;
        while (i < propertyInitTable.length) {
            String prop = (String)propertyInitTable[i];
            Dag value = (Dag)propertyInitTable[i + 1];
            Validator validator = (Validator)propertyInitTable[i + 2];
            this.propertyMap.put(prop, value);
            validatorMap.put(prop, validator);
            i += 3;
        }
        this.user = user;
        this.subsTable = new PreprocessorSubstitutionTable();
    }

    public Object getValue(String key) {
        Object returned = null;
        String aliasedKey = this.alias(key);
        if (this.propertyMap.containsKey(aliasedKey)) {
            Dag dag = (Dag)this.propertyMap.get(aliasedKey);
            returned = this.convertDag(dag);
        } else {
            Dag error = DagUtil.createErrorDag(String.valueOf(aliasedKey) + " not a valid property name");
            this.throwInterfaceErrorToKernel(error, null);
        }
        return returned;
    }

    public int getType(String key) {
        Dag defaultDag = (Dag)defaultMap.get(this.alias(key));
        return defaultDag != null ? defaultDag.getType() : -1;
    }

    public Dag getDagValue(String key) {
        return (Dag)this.propertyMap.get(this.alias(key));
    }

    protected Object convertDag(Dag dag) {
        Object result = null;
        result = DagUtil.isInt(dag) ? new Integer(DagUtil.parseInt(dag)) : (DagUtil.isFloat(dag) ? new Float(DagUtil.parseFloat(dag)) : (DagUtil.isNameNamed(dag, TRUE) ? Boolean.TRUE : (DagUtil.isNameNamed(dag, FALSE) ? Boolean.FALSE : (DagUtil.isText(dag) ? dag.getData() : DagBuilder.lPrint(dag)))));
        return result;
    }

    public boolean isValidProperty(String key) {
        return this.propertyMap.containsKey(this.alias(key));
    }

    public void setValue(String key, Dag value, KernelEvent event) {
        String aliasedKey = this.alias(key);
        if (this.propertyMap.containsKey(aliasedKey)) {
            Dag existing = (Dag)this.propertyMap.get(aliasedKey);
            Validator validator = (Validator)validatorMap.get(aliasedKey);
            Dag validatedResult = validator.validate(aliasedKey, value);
            if (DagUtil.isError(validatedResult)) {
                this.throwInterfaceErrorToKernel(validatedResult, event);
            } else if (validatedResult != null) {
                this.propertyMap.put(aliasedKey, validatedResult);
                if (existing != null && event != null) {
                    event.setResponseAsDag(existing);
                    if (!existing.equals(validatedResult)) {
                        this.fireChangeEvent(aliasedKey, DagBuilder.lPrint(existing));
                    }
                }
            } else {
                Dag error = DagUtil.createErrorDag("null property detected for property " + key);
                this.throwInterfaceErrorToKernel(error, event);
            }
        } else {
            Dag error = DagUtil.createErrorDag(String.valueOf(aliasedKey) + " not a valid property name");
            this.throwInterfaceErrorToKernel(error, event);
        }
    }

    public Dag setValue(String key, Dag value) {
        Dag result = null;
        String aliasedKey = this.alias(key);
        if (this.propertyMap.containsKey(aliasedKey)) {
            Dag existing = (Dag)this.propertyMap.get(aliasedKey);
            Validator validator = (Validator)validatorMap.get(aliasedKey);
            Dag validatedResult = validator.validate(aliasedKey, value);
            if (validatedResult == null) {
                result = DagUtil.createErrorDag("null property detected for property " + key);
            } else if (DagUtil.isError(validatedResult)) {
                result = validatedResult;
            } else {
                result = existing;
                this.propertyMap.put(aliasedKey, validatedResult);
                if (existing != null && !existing.equals(validatedResult)) {
                    this.fireChangeEvent(aliasedKey, DagBuilder.lPrint(existing));
                }
            }
        } else {
            result = DagUtil.createErrorDag(String.valueOf(aliasedKey) + " not a valid property name");
        }
        return result;
    }

    public void setValue(String key, String value, KernelEvent event) {
        String aliasedKey = this.alias(key);
        if (this.propertyMap.containsKey(aliasedKey)) {
            Dag defaultDag = (Dag)defaultMap.get(aliasedKey);
            Dag dagVal = null;
            if (DagUtil.isString(defaultDag)) {
                dagVal = DagUtil.createStringDag(value);
            } else if (DagUtil.isName(defaultDag)) {
                dagVal = DagUtil.createNameDag(value);
            } else if (DagUtil.isInt(defaultDag)) {
                try {
                    int ival = Integer.parseInt(value);
                    dagVal = DagUtil.createIntDag(ival);
                }
                catch (NumberFormatException ival) {}
            } else if (DagUtil.isFloat(defaultDag)) {
                try {
                    float fval = Float.parseFloat(value);
                    dagVal = DagUtil.createFloatDag(fval);
                }
                catch (NumberFormatException fval) {
                    // empty catch block
                }
            }
            if (dagVal == null && INFINITY_STRING.equals(value)) {
                dagVal = DagUtil.createNameDag(INFINITY_STRING);
            }
            if (dagVal != null) {
                this.setValue(key, dagVal, event);
            } else {
                Dag error = DagUtil.createErrorDag("Could not construct property for " + key + " : " + value);
                this.throwInterfaceErrorToKernel(error, event);
            }
        }
    }

    public PreprocessorSubstitutionTable getSubstitutionTable() {
        return this.subsTable;
    }

    protected void throwInterfaceErrorToKernel(Dag message, KernelEvent event) {
        if (event != null && this.user != null) {
            event.setResponseAsDag(message);
        }
    }

    private String alias(String key) {
        String returnedKey = key;
        if (aliasMap.containsKey(returnedKey)) {
            returnedKey = (String)aliasMap.get(returnedKey);
        }
        return returnedKey;
    }

    public KernelEvent createGetReply(Dag dag, KernelEvent event) {
        if (DagUtil.isExpSeq(dag) && dag.getLength() > 0) {
            Dag[] results = new Dag[dag.getLength()];
            Dag errorDag = null;
            int i = 0;
            while (i < dag.getLength()) {
                Dag child = dag.getChild(i);
                if (DagUtil.isName(child)) {
                    String name = child.getData();
                    if (name != null && this.isValidProperty(name)) {
                        results[i] = (Dag)this.propertyMap.get(this.alias(name));
                    } else {
                        errorDag = DagUtil.createErrorDag("unknown interface variable, " + name);
                    }
                } else {
                    errorDag = DagUtil.createErrorDag("Malformed interface property get");
                }
                ++i;
            }
            if (errorDag == null) {
                Dag result = Dag.createDag(29, results, null, false);
                event.setResponseAsDag(result);
            } else {
                this.throwInterfaceErrorToKernel(errorDag, event);
            }
        }
        return event;
    }

    public KernelEvent createSetReply(String name, Dag oldValue, KernelEvent event) {
        if (this.isValidProperty(name)) {
            Dag result = Dag.createDag(29, new Dag[]{oldValue}, null, false);
            event.setResponseAsDag(result);
        } else {
            Dag error = DagUtil.createErrorDag("unknown interface variable, " + name);
            this.throwInterfaceErrorToKernel(error, event);
        }
        return event;
    }

    public void addChangeListener(KernelInterfacePropertiesChangeListener listener) {
        this.changeListeners.add(listener);
        KernelInterfacePropertiesChangeEvent e = new KernelInterfacePropertiesChangeEvent(1, this);
        listener.processConnected(e);
    }

    public KernelInterfacePropertiesChangeListener removeChangeListener(KernelInterfacePropertiesChangeListener listener) {
        KernelInterfacePropertiesChangeListener rl = null;
        int index = -1;
        index = this.changeListeners.indexOf(listener);
        if (index > 0) {
            rl = (KernelInterfacePropertiesChangeListener)this.changeListeners.remove(index);
            KernelInterfacePropertiesChangeEvent e = new KernelInterfacePropertiesChangeEvent(3, this);
            rl.processDisconnected(e);
        }
        return rl;
    }

    void fireChangeEvent(String property, String previous) {
        KernelInterfacePropertiesChangeEvent e = new KernelInterfacePropertiesChangeEvent(2, this, property, this.getValue(property), previous);
        Iterator listIt = this.changeListeners.iterator();
        while (listIt.hasNext()) {
            ((KernelInterfacePropertiesChangeListener)listIt.next()).processPropertiesUpdated(e);
        }
    }

    public int getNumberProperties() {
        return this.propertyMap.size();
    }

    public Iterator getIterator() {
        return this.propertyMap.keySet().iterator();
    }

    public static boolean shouldChangeOnReset(String name) {
        return !retainedPropertySet.contains(name);
    }

    protected static class BaseValidator
    implements Validator {
        protected BaseValidator() {
        }

        @Override
        public Dag validate(String key, Dag value) {
            Dag result = null;
            result = value != null ? (DagUtil.isNameNamed(value, "default") ? this.getDefaultValue(key) : value) : DagUtil.createErrorDag("property " + key + " can not be set to NULL");
            return result;
        }

        protected Dag getDefaultValue(String key) {
            return (Dag)defaultMap.get(key);
        }
    }

    protected static class BooleanValidator
    extends BaseValidator {
        protected BooleanValidator() {
        }

        @Override
        public Dag validate(String key, Dag value) {
            Dag result = null;
            Dag sresult = super.validate(key, value);
            if (DagUtil.isNameNamed(sresult, KernelInterfaceProperties.TRUE) || DagUtil.isNameNamed(sresult, KernelInterfaceProperties.FALSE)) {
                result = sresult;
            } else if (DagUtil.isName(sresult)) {
                String data = sresult.getData();
                if (KernelInterfaceProperties.TRUE.equalsIgnoreCase(data)) {
                    result = DagUtil.createNameDag(KernelInterfaceProperties.TRUE);
                } else if (KernelInterfaceProperties.FALSE.equalsIgnoreCase(data)) {
                    result = DagUtil.createNameDag(KernelInterfaceProperties.FALSE);
                }
            }
            if (result == null) {
                result = DagUtil.createErrorDag(String.valueOf(key) + " must be true or false");
            }
            return result;
        }
    }

    protected static class DoubleRangeValidator
    extends BaseValidator {
        double min = 0.0;
        double max = 0.0;

        protected DoubleRangeValidator(double min, double max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public Dag validate(String key, Dag value) {
            double dval;
            Dag result = null;
            Dag sresult = super.validate(key, value);
            if (DagUtil.isFloat(sresult) && (dval = (double)DagUtil.parseFloat(sresult)) >= this.min && dval <= this.max) {
                result = value;
            }
            if (result == null) {
                result = DagUtil.createErrorDag(String.valueOf(key) + " must be a number in the range " + this.min + ".." + this.max);
            }
            return result;
        }
    }

    protected static class InfinityPositiveIntegerValidator
    extends BaseValidator {
        protected InfinityPositiveIntegerValidator() {
        }

        @Override
        public Dag validate(String key, Dag value) {
            Dag result = null;
            Dag sresult = super.validate(key, value);
            result = DagUtil.isPosInt(sresult) || DagUtil.isPosInfinity(sresult) ? sresult : DagUtil.createErrorDag(String.valueOf(key) + " must be a positive integer, or infinity");
            return result;
        }
    }

    protected static class IntegerRangeValidator
    extends BaseValidator {
        int min = 0;
        int max = 0;

        protected IntegerRangeValidator(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public Dag validate(String key, Dag value) {
            int val;
            Dag result = null;
            Dag sresult = super.validate(key, value);
            if (DagUtil.isInt(sresult) && (val = DagUtil.parseInt(sresult)) >= this.min && val <= this.max) {
                result = sresult;
            }
            if (result == null) {
                result = DagUtil.createErrorDag(String.valueOf(key) + " must be an integer in the range " + this.min + ".." + this.max);
            }
            return result;
        }
    }

    protected static class IntegerValidator
    extends BaseValidator {
        protected IntegerValidator() {
        }

        @Override
        public Dag validate(String key, Dag value) {
            Dag result = null;
            Dag sresult = super.validate(key, value);
            result = DagUtil.isInt(sresult) ? sresult : DagUtil.createErrorDag(String.valueOf(key) + " must be an integer");
            return result;
        }
    }

    protected static class PositiveIntegerValidator
    extends BaseValidator {
        protected PositiveIntegerValidator() {
        }

        @Override
        public Dag validate(String key, Dag value) {
            Dag result = null;
            Dag sresult = super.validate(key, value);
            result = DagUtil.isPosInt(sresult) ? sresult : DagUtil.createErrorDag(String.valueOf(key) + " must be a positive integer");
            return result;
        }
    }

    protected static class ReadOnlyValidator
    implements Validator {
        protected ReadOnlyValidator() {
        }

        @Override
        public Dag validate(String key, Dag value) {
            return DagUtil.createErrorDag(String.valueOf(key) + " is Read Only");
        }
    }

    protected static class TypesetValidator
    extends BaseValidator {
        protected TypesetValidator() {
        }

        @Override
        public Dag validate(String key, Dag value) {
            Dag result = null;
            Dag sresult = super.validate(key, value);
            if (DagUtil.isNameNamed(sresult, KernelInterfaceProperties.PROPERTY_TYPESETTING_ON) || DagUtil.isNameNamed(sresult, KernelInterfaceProperties.PROPERTY_TYPESETTING_OFF)) {
                result = sresult;
            } else if (DagUtil.isText(value)) {
                String val = sresult.getData();
                if (KernelInterfaceProperties.PROPERTY_TYPESETTING_ON.equalsIgnoreCase(val)) {
                    result = DagUtil.createNameDag(KernelInterfaceProperties.PROPERTY_TYPESETTING_ON);
                } else if (KernelInterfaceProperties.PROPERTY_TYPESETTING_OFF.equalsIgnoreCase(val)) {
                    result = DagUtil.createNameDag(KernelInterfaceProperties.PROPERTY_TYPESETTING_OFF);
                }
            }
            if (result == null) {
                result = DagUtil.createErrorDag(String.valueOf(key) + " must be a string of " + KernelInterfaceProperties.PROPERTY_TYPESETTING_ON + " or " + KernelInterfaceProperties.PROPERTY_TYPESETTING_OFF);
            }
            return result;
        }
    }

    protected static interface Validator {
        public Dag validate(String var1, Dag var2);
    }
}

