/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelConnectionEvent;
import com.maplesoft.client.KernelConnectionListener;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.RedirectedKernelListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class KernelProxy {
    private static final int KERNEL_INVALID = 0;
    private static final int KERNEL_STARTING = 1;
    private static final int KERNEL_RUNNING = 2;
    private static final int START_WAIT_QUANTUM = 100;
    private static int idCounter = -1;
    private static KernelProxy instance = null;
    private static int nextTransactionID = 0;
    private HashMap runningConnections;
    private Vector pendingConnections;
    private Object connectionQueue;

    private KernelProxy() {
        instance = this;
        this.runningConnections = new HashMap();
        this.pendingConnections = new Vector();
        this.connectionQueue = new Object();
    }

    public static KernelProxy getInstance() {
        if (instance == null) {
            new KernelProxy();
        }
        return instance;
    }

    public void createKernelConnection(KernelConnectionListener listener) {
        int kernelID = listener.getKernelID();
        this.setKernelStarting(kernelID);
        KernelConnection kernelConnection = new KernelConnection(this);
        kernelConnection.startSockets();
        this.setKernelRunning(kernelID, kernelConnection);
        listener.setConnection(kernelConnection);
        kernelConnection.addKernelConnectionListener(listener);
        listener.processConnection(new KernelConnectionEvent(1, 1, kernelConnection, listener));
    }

    public void shutdownKernelListener(KernelConnectionListener listener) {
        int id = listener.getKernelID();
        KernelConnection connection = KernelProxy.getInstance().getKernelConnection(id);
        connection.removeKernelConnectionListener(listener);
        KernelConnectionEvent event = null;
        event = new KernelConnectionEvent(0, 2, connection, listener);
        listener.processDisconnection(event);
        this.setKernelInvalid(id);
    }

    public void createKernelIfNeeded(KernelConnectionListener listener) {
        KernelConnection c;
        int kernelID = listener.getKernelID();
        if (kernelID < 0 || this.getKernelState(kernelID) == 0) {
            if (kernelID < 0) {
                kernelID = ++idCounter;
            }
            this.createKernelConnection(listener);
        }
        if ((c = this.getKernelConnection(listener.getKernelID())) != null) {
            c.confirmListener(listener);
        }
    }

    public int getNextConnectionID(boolean newKernel) {
        if (newKernel) {
            return ++idCounter;
        }
        return idCounter;
    }

    public void sendCommand(int kernelID, KernelListener listener, String command, int how) {
        KernelConnection conn = this.getKernelConnection(kernelID);
        if (conn != null) {
            conn.sendCommand(listener, command, how);
        }
    }

    private void sendUrgentCommand(int kernelID, KernelListener listener, String command, int how) {
        KernelConnection conn = this.getKernelConnection(kernelID);
        if (conn != null) {
            conn.sendUrgentCommand(listener, command, how);
        }
    }

    private void sendUrgentInternalCommand(int kernelID, KernelListener listener, String command, int how) {
        KernelConnection conn = this.getKernelConnection(kernelID);
        if (conn != null) {
            conn.sendUrgentInternalCommand(listener, command, how);
        }
    }

    private void sendInternalCommand(int kernelID, KernelListener listener, String command, int how) {
        KernelConnection conn = this.getKernelConnection(kernelID);
        if (conn != null) {
            conn.sendInternalCommand(listener, command, how);
        }
    }

    public void setRedirectedListener(int kernelID, RedirectedKernelListener listener) {
        KernelConnection conn = this.getKernelConnection(kernelID);
        if (conn != null) {
            conn.setRedirectedListener(listener);
        }
    }

    public KernelTransaction createTransaction(KernelListener listener, String command, int how) {
        return new KernelTransaction(nextTransactionID++, listener, command, how);
    }

    public KernelTransaction createTransaction(KernelListener listener, String command, int how, boolean noDitto) {
        return new KernelTransaction(nextTransactionID, listener, command, how, noDitto);
    }

    public void evaluate(int kernelID, KernelListener listener, String command) {
        this.sendCommand(kernelID, listener, command, 41);
    }

    public void evaluate(int kernelID, KernelListener listener, String command, int how) {
        this.sendCommand(kernelID, listener, command, how);
    }

    public void urgentEvaluate(int kernelID, KernelListener listener, String command) {
        this.sendUrgentCommand(kernelID, listener, command, 41);
    }

    public void urgentEvaluate(int kernelID, KernelListener listener, String command, int how) {
        this.sendUrgentCommand(kernelID, listener, command, how);
    }

    public void internalEvaluate(int kernelID, KernelListener listener, String command) {
        this.sendInternalCommand(kernelID, listener, command, 41);
    }

    public void internalEvaluate(int kernelID, KernelListener listener, String command, int how) {
        this.sendInternalCommand(kernelID, listener, command, how);
    }

    public void urgentInternalEvaluate(int kernelID, KernelListener listener, String command) {
        this.sendUrgentInternalCommand(kernelID, listener, command, 41);
    }

    public void urgentInternalEvaluate(int kernelID, KernelListener listener, String command, int how) {
        this.sendUrgentInternalCommand(kernelID, listener, command, how);
    }

    public void shutdownConnection(int kernelID) {
        KernelConnection connection = this.getKernelConnection(kernelID);
        this.setKernelInvalid(kernelID);
        if (kernelID == idCounter && idCounter > 0) {
            --idCounter;
        }
        if (connection != null) {
            connection.stopSockets();
        }
    }

    public int getPort(int kernelID) {
        int port = -1;
        KernelConnection connection = this.getKernelConnection(kernelID);
        if (connection != null) {
            port = connection.getPort();
        }
        return port;
    }

    public void shutdownProxy() {
        int[] ids = this.getKernelIDs();
        int i = 0;
        while (i < ids.length) {
            this.sendCommand(ids[i], null, "quit", 41);
            this.shutdownConnection(ids[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getKernelState(int kernelID) {
        int state = 0;
        Integer id = new Integer(kernelID);
        Object object = this.connectionQueue;
        synchronized (object) {
            if (this.runningConnections.containsKey(id)) {
                state = 2;
            } else if (this.pendingConnections.contains(id)) {
                state = 1;
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setKernelStarting(int kernelID) {
        Integer id = new Integer(kernelID);
        boolean invalidChange = false;
        Object object = this.connectionQueue;
        synchronized (object) {
            if (this.runningConnections.containsKey(id)) {
                invalidChange = true;
            } else if (!this.pendingConnections.contains(id)) {
                this.pendingConnections.add(id);
            }
        }
        if (invalidChange) {
            throw new IllegalArgumentException("Attempt to change running kernel: " + kernelID + "to starting state.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setKernelRunning(int kernelID, KernelConnection conn) {
        Integer id = new Integer(kernelID);
        Object object = this.connectionQueue;
        synchronized (object) {
            this.pendingConnections.remove(id);
            this.runningConnections.put(id, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setKernelInvalid(int kernelID) {
        Integer id = new Integer(kernelID);
        Object object = this.connectionQueue;
        synchronized (object) {
            this.pendingConnections.remove(id);
            this.runningConnections.remove(id);
        }
    }

    public boolean isKernelConnectionValid(int id) {
        return this.getKernelState(id) != 0;
    }

    public KernelConnection getKernelConnection(int id, boolean waitIfStarting) {
        KernelConnection connection = null;
        int state = this.getKernelState(id);
        if (state == 0 && waitIfStarting) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            state = this.getKernelState(id);
        }
        if (state != 0) {
            while (state == 1 && waitIfStarting) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                state = this.getKernelState(id);
            }
            if (state == 2) {
                connection = this.getRunningConnection(id);
            }
        }
        return connection;
    }

    public KernelConnection getKernelConnection(int id) {
        return this.getKernelConnection(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KernelConnection getRunningConnection(int kernelId) {
        KernelConnection conn = null;
        Integer id = new Integer(kernelId);
        Object object = this.connectionQueue;
        synchronized (object) {
            conn = (KernelConnection)this.runningConnections.get(id);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getKernelConnections() {
        Collection c = null;
        Object object = this.connectionQueue;
        synchronized (object) {
            c = this.runningConnections.values();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getKernelIDs() {
        int[] ids = new int[this.getNumberKernels()];
        Object object = this.connectionQueue;
        synchronized (object) {
            int i = 0;
            Iterator key = this.runningConnections.keySet().iterator();
            while (key.hasNext()) {
                ids[i++] = (Integer)key.next();
            }
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberKernels() {
        int numKernels = -1;
        Object object = this.connectionQueue;
        synchronized (object) {
            numKernels = this.runningConnections.size();
        }
        return numKernels;
    }

    public void addKernelId(int kernelID) {
        if (kernelID > idCounter) {
            idCounter = kernelID;
        }
    }

    public static class KernelTransaction {
        protected int transactionID;
        protected KernelListener kernelListener;
        protected String command;
        protected int mrfHow;
        protected boolean noDitto;

        KernelTransaction(int transactionID, KernelListener listener, String command, int how) {
            this.transactionID = transactionID;
            this.kernelListener = listener;
            this.command = command;
            this.mrfHow = how;
            this.noDitto = false;
        }

        KernelTransaction(int transactionID, KernelListener listener, String command, int how, boolean noDitto) {
            this.transactionID = transactionID;
            this.kernelListener = listener;
            this.command = command;
            this.mrfHow = how;
            this.noDitto = noDitto;
        }
    }
}

