/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class KernelUtil {
    private static final int MAX_ASCII = 255;
    private static PrintWriter out;
    private static BufferedReader in;
    private static int BUFSIZE;
    private static byte[] buf;

    static {
        BUFSIZE = 2048;
        buf = new byte[BUFSIZE];
    }

    public static void setOutIn(PrintWriter o, BufferedReader i) {
        out = o;
        in = i;
    }

    public static void writeText(OutputStream os, String s) throws IOException {
        byte[] b = new byte[s.length() + 1];
        int i = 0;
        while (i < s.length()) {
            b[i] = (byte)s.charAt(i);
            ++i;
        }
        b[s.length()] = 0;
        os.write(b);
        os.flush();
    }

    public static void writeText(OutputStream os, char[] ch) throws IOException {
        byte[] b = new byte[ch.length + 1];
        int i = 0;
        while (i < ch.length) {
            b[i] = (byte)ch[i];
            ++i;
        }
        b[ch.length] = 0;
        os.write(b);
        os.flush();
    }

    public static void writeInt(OutputStream os, int i) throws IOException {
        byte[] b = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        os.write(b);
        os.flush();
    }

    public static void writeByte(OutputStream os, int l) throws IOException {
        os.write((byte)l);
    }

    public static int readInt(InputStream is) throws IOException {
        int a = KernelUtil.readByte(is);
        int b = KernelUtil.readByte(is);
        int c = KernelUtil.readByte(is);
        int d = KernelUtil.readByte(is);
        return (a << 24) + (b << 16) + (c << 8) + d;
    }

    public static int readByte(InputStream is) throws IOException {
        int c = is.read();
        return c;
    }

    public static char[] readText(InputStream is) throws IOException {
        int byteCount = KernelUtil.readInt(is);
        int readBytes = 0;
        char[] theChars = new char[byteCount];
        int i = 0;
        while (readBytes < byteCount) {
            int max = BUFSIZE;
            if (byteCount - readBytes < max) {
                max = byteCount - readBytes;
            }
            int n = is.read(buf, 0, max);
            int j = 0;
            while (j < n) {
                theChars[i++] = (char)buf[j] > '\u00ff' ? (char)(0xFF00 ^ buf[j]) : (char)buf[j];
                ++j;
            }
            readBytes += n;
        }
        return theChars;
    }
}

