/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.ClientReady;
import com.maplesoft.client.CommandQueue;
import com.maplesoft.client.KernelCommunicationError;
import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.KernelProxy;
import com.maplesoft.client.KernelUtil;
import com.maplesoft.client.MapleSocket;
import com.maplesoft.client.RedirectedKernelListener;
import com.maplesoft.client.kernelresult.KernelResultsDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;

public class MapleClientSocket
implements Runnable {
    private static final int BUSY_WAIT = 20;
    private static boolean kernelDebugDisplay = false;
    private static final String CONNECT_ERROR = "Connection to Kernel lost";
    protected int kernelPort;
    protected volatile Socket clientSocket;
    protected InputStream clientSocketInputStream;
    protected OutputStream clientSocketOutputStream;
    protected ClientReady clientReady;
    protected KernelProxy kernelProxy;
    protected KernelConnection connection;
    protected String commandstr;
    protected boolean kernelBusy;
    protected KernelProxy.KernelTransaction t;
    protected boolean shutdown;
    protected KernelEvent event;
    private boolean interruptedStatus = false;

    public MapleClientSocket(int port, ClientReady ready) {
        this.kernelPort = port;
        this.clientReady = ready;
        this.shutdown = false;
        this.kernelBusy = false;
    }

    public void setKernelConnection(KernelConnection connection) {
        this.connection = connection;
    }

    public void setKernelProxy(KernelProxy kernel) {
        this.kernelProxy = kernel;
    }

    public String getAuthenticationCode() {
        return null;
    }

    public String getCallbackString() {
        return "1000000000";
    }

    public boolean useEvaluateDAG() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerCallback() {
        int pid = -1;
        String buf = this.getCallbackString();
        try {
            String authCode = this.getAuthenticationCode();
            if (authCode != null) {
                KernelUtil.writeInt(this.clientSocketOutputStream, 1);
                KernelUtil.writeInt(this.clientSocketOutputStream, authCode.length() + 1);
                KernelUtil.writeText(this.clientSocketOutputStream, authCode);
            } else {
                KernelUtil.writeInt(this.clientSocketOutputStream, 0);
            }
            int MapleID = KernelUtil.readInt(this.clientSocketInputStream);
            pid = KernelUtil.readInt(this.clientSocketInputStream);
            KernelUtil.writeByte(this.clientSocketOutputStream, 36);
            KernelUtil.writeInt(this.clientSocketOutputStream, buf.length() + 1);
            KernelUtil.writeText(this.clientSocketOutputStream, buf);
            int c = KernelUtil.readByte(this.clientSocketInputStream);
        }
        catch (IOException e) {
            this.clientReady.failed = true;
            ClientReady clientReady = this.clientReady;
            synchronized (clientReady) {
                this.clientReady.notify();
            }
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.clientSocket = null;
        try {
            this.clientSocket = new Socket("localhost", this.kernelPort);
            this.clientSocket.setTcpNoDelay(true);
        }
        catch (IOException e) {
            try {
                this.clientSocket = new Socket("127.0.0.1", this.kernelPort);
            }
            catch (IOException e2) {
                this.clientReady.failed = true;
                ClientReady clientReady = this.clientReady;
                synchronized (clientReady) {
                    this.clientReady.notify();
                }
                return;
            }
        }
        try {
            this.clientSocketInputStream = this.clientSocket.getInputStream();
            this.clientSocketOutputStream = this.clientSocket.getOutputStream();
        }
        catch (IOException e) {
            this.clientReady.failed = true;
            ClientReady e2 = this.clientReady;
            synchronized (e2) {
                this.clientReady.notify();
            }
        }
        this.registerCallback();
        ClientReady e = this.clientReady;
        synchronized (e) {
            this.clientReady.ready = true;
            this.clientReady.notify();
        }
        this.shutdown = false;
        CommandQueue commandQueue = this.connection.getQueue();
        while (!this.isShutdown()) {
            if (!commandQueue.isEmpty() && !this.kernelBusy) {
                this.t = (KernelProxy.KernelTransaction)commandQueue.pop();
                KernelEvent startEvent = new KernelEvent(9, "", true, this.t.kernelListener);
                startEvent.setStreamName("EVALSTART");
                this.interruptedStatus = false;
                boolean processedFakeStartEvent = false;
                KernelListener startListener = this.t.kernelListener;
                while (startListener != null && !(processedFakeStartEvent = startListener.processComputationStateChange(startEvent))) {
                    startListener = startListener.getParentListener();
                }
                this.kernelBusy = true;
                this.commandstr = this.t.command;
                try {
                    int how = this.t.mrfHow;
                    int options = 0;
                    KernelUtil.writeByte(this.clientSocketOutputStream, how);
                    if (how != 42 && how != 45) {
                        if (this.useEvaluateDAG()) {
                            options |= 1;
                        }
                        if (this.t.noDitto) {
                            options |= 2;
                        }
                    }
                    if (options != 0) {
                        KernelUtil.writeByte(this.clientSocketOutputStream, options);
                    }
                    KernelUtil.writeInt(this.clientSocketOutputStream, this.commandstr.length() + 1);
                    KernelUtil.writeText(this.clientSocketOutputStream, this.commandstr);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.createResults();
                this.t = null;
                continue;
            }
            try {
                boolean busyWait = false;
                CommandQueue commandQueue2 = commandQueue;
                synchronized (commandQueue2) {
                    if (commandQueue.isEmpty()) {
                        commandQueue.wait();
                    } else {
                        busyWait = true;
                    }
                }
                if (!busyWait) continue;
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    int getPort() {
        return this.kernelPort;
    }

    boolean isKernelBusy() {
        return this.kernelBusy;
    }

    public void createResults() {
        int type = 0;
        try {
            while (this.clientSocket != null && (type = KernelUtil.readByte(this.clientSocketInputStream)) > 0) {
                block17: {
                    if (this.connection.getRedirectedListener() != null) {
                        RedirectedKernelListener redirect = null;
                        redirect = this.connection.getRedirectedListener();
                        redirect.setParentListener(this.t.kernelListener);
                        this.event = KernelResultsDescriptor.createKernelEvent(this.connection, type, redirect);
                        KernelResultsDescriptor.processEvent(type, redirect, this.event);
                    } else {
                        this.event = KernelResultsDescriptor.createKernelEvent(this.connection, type, this.t.kernelListener);
                        KernelResultsDescriptor.processEvent(type, this.t.kernelListener, this.event);
                    }
                    String response = this.event.getResponseForKernel();
                    if (response != null && this.clientSocket != null) {
                        try {
                            if (this.useEvaluateDAG()) {
                                KernelUtil.writeByte(this.clientSocketOutputStream, 0);
                            } else {
                                KernelUtil.writeByte(this.clientSocketOutputStream, 34);
                            }
                            KernelUtil.writeInt(this.clientSocketOutputStream, response.length() + 1);
                            KernelUtil.writeText(this.clientSocketOutputStream, response);
                            break block17;
                        }
                        catch (SocketException se) {
                            this.connection.clearQueue();
                            this.endComputationResult(this.t, -1);
                            break block17;
                        }
                        catch (Exception e) {
                            this.connection.clearQueue();
                            this.endComputationResult(this.t, -1);
                            break;
                        }
                    }
                    if (this.clientSocket == null) {
                        if (this.interruptedStatus) {
                            this.endComputationResult(this.t, 0);
                            this.interruptedStatus = false;
                        } else if (this.event.getStreamName().equals("MAPLET_STATUS") && this.event.getText().equals("\"stop\"")) {
                            this.endComputationResult(this.t, 0);
                        } else {
                            this.endComputationResult(this.t, -1);
                        }
                    }
                }
                this.interruptedStatus = false;
            }
            this.endComputationResult(this.t, type);
        }
        catch (SocketException se) {
            this.connection.clearQueue();
            this.endComputationResult(this.t, -1);
        }
        catch (Exception e) {
            this.connection.clearQueue();
            this.endComputationResult(this.t, -1);
        }
        this.kernelBusy = false;
    }

    public void endComputationResult(KernelProxy.KernelTransaction t, int type) {
        if (type == 0 || type == -1) {
            KernelEvent stopEvent = new KernelEvent(9, "", true, t.kernelListener);
            if (type == 0) {
                stopEvent.setStreamName("EVALEND");
            } else {
                stopEvent.setStreamName("KERNELFAIL");
            }
            KernelListener stopListener = t.kernelListener;
            while (stopListener != null && !stopListener.processComputationStateChange(stopEvent)) {
                stopListener = stopListener.getParentListener();
            }
            this.kernelBusy = false;
        }
    }

    public synchronized void Shutdown(boolean shutdown) {
        this.shutdown();
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        try {
            KernelUtil.writeByte(this.clientSocketOutputStream, 9);
            this.clientSocket.close();
            this.clientSocket = null;
            this.clientSocketInputStream = null;
            this.clientSocketOutputStream = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    public boolean interrupt() throws KernelCommunicationError {
        return this.interrupt(true);
    }

    public boolean interrupt(boolean reportFail) throws KernelCommunicationError {
        block9: {
            if (!this.isKernelBusy()) {
                return false;
            }
            if (this.clientSocket instanceof MapleSocket) {
                block8: {
                    try {
                        ((MapleSocket)this.clientSocket).sendInterrupt();
                    }
                    catch (IOException e) {
                        if (!reportFail) break block8;
                        throw new KernelCommunicationError(e.toString());
                    }
                }
                return false;
            }
            try {
                Integer nullCharArgument = new Integer(0);
                Class[] paramSpecification = new Class[1];
                Object[] finalArguments = new Object[1];
                Class<?> socketClass = this.clientSocket.getClass();
                Method socketSendUrgentDataFromOnePointFour = null;
                paramSpecification[0] = Integer.TYPE;
                socketSendUrgentDataFromOnePointFour = socketClass.getMethod("sendUrgentData", paramSpecification);
                finalArguments[0] = nullCharArgument;
                socketSendUrgentDataFromOnePointFour.invoke((Object)this.clientSocket, finalArguments);
                this.interruptedStatus = true;
                return true;
            }
            catch (NoSuchMethodException nsme) {
                if (reportFail) {
                    throw new KernelCommunicationError("Interrupt not supported on all platforms.");
                }
            }
            catch (Exception e1) {
                if (!reportFail) break block9;
                throw new KernelCommunicationError(e1.toString());
            }
        }
        return true;
    }

    void toDebugMode() throws KernelCommunicationError {
        if (this.clientSocket instanceof MapleSocket) {
            try {
                ((MapleSocket)this.clientSocket).sendDebugMode();
            }
            catch (IOException e) {
                System.out.println("error");
                throw new KernelCommunicationError(e.toString());
            }
        }
        try {
            Integer nullCharArgument = new Integer(1);
            Class[] paramSpecification = new Class[1];
            Object[] finalArguments = new Object[1];
            Class<?> socketClass = this.clientSocket.getClass();
            Method socketSendUrgentDataFromOnePointFour = null;
            paramSpecification[0] = Integer.TYPE;
            socketSendUrgentDataFromOnePointFour = socketClass.getMethod("sendUrgentData", paramSpecification);
            finalArguments[0] = nullCharArgument;
            socketSendUrgentDataFromOnePointFour.invoke((Object)this.clientSocket, finalArguments);
        }
        catch (NoSuchMethodException nsme) {
            throw new KernelCommunicationError("Interrupt not supported on all platforms.");
        }
        catch (Exception e1) {
            throw new KernelCommunicationError(e1.toString());
        }
    }

    public InputStream getSocketInputStream() {
        return this.clientSocketInputStream;
    }

    public OutputStream getSocketOutputStream() {
        return this.clientSocketOutputStream;
    }

    public String errorState() {
        return CONNECT_ERROR;
    }
}

