/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class MapleSocket
extends Socket {
    private InputStream in;
    private OutputStream out;
    private static boolean libraryAvailable = true;
    int socket;

    static {
        try {
            System.loadLibrary("MapleSocket");
        }
        catch (UnsatisfiedLinkError e) {
            libraryAvailable = false;
        }
    }

    private native void nativeConnect(String var1, int var2) throws IOException;

    private native void nativeDisconnect() throws IOException;

    private native void nativeWrite(int var1) throws IOException;

    private native int nativeRead() throws IOException;

    private native void nativeSendOOBData(int var1) throws IOException;

    public MapleSocket(String host, int port) throws UnknownHostException, IOException {
        this.nativeConnect(host, port);
        this.in = new SocketInputStream();
        this.out = new SocketOutputStream();
    }

    @Override
    public void close() throws IOException {
        this.nativeDisconnect();
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    public static boolean isLibraryAvailable() {
        return libraryAvailable;
    }

    public void sendInterrupt() throws IOException {
        this.nativeSendOOBData(0);
    }

    public void sendDebugMode() throws IOException {
        this.nativeSendOOBData(1);
    }

    private class SocketInputStream
    extends InputStream {
        private SocketInputStream() {
        }

        @Override
        public int read() throws IOException {
            return MapleSocket.this.nativeRead();
        }
    }

    private class SocketOutputStream
    extends OutputStream {
        private SocketOutputStream() {
        }

        @Override
        public void write(int param) throws IOException {
            MapleSocket.this.nativeWrite(param);
        }
    }
}

