/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelConnectionListener;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelInterfaceProperties;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagUtil;

public class SetGetHandler {
    private KernelConnectionListener connector;
    private boolean setCallDisable = false;

    public SetGetHandler(KernelConnectionListener connectListener) {
        this.connector = connectListener;
    }

    private KernelInterfaceProperties transformSet(KernelEvent event, KernelInterfaceProperties prop) {
        Dag dag = event.getDag();
        if (DagUtil.isExpSeq(dag) && dag.getLength() > 0) {
            Dag[] results = new Dag[dag.getLength()];
            if (dag.getLength() == 2 && !DagUtil.isEquation(dag.getChild(0))) {
                results = new Dag[]{this.processSetProperty(prop, dag)};
            } else {
                int i = 0;
                while (i < dag.getLength()) {
                    Dag child = dag.getChild(i);
                    results[i] = this.processSetProperty(prop, child);
                    ++i;
                }
            }
            if (results.length == 1 && DagUtil.isError(results[0])) {
                event.setResponseAsDag(results[0]);
            } else {
                Dag result = Dag.createDag(29, results, null, false);
                event.setResponseAsDag(result);
            }
        }
        return prop;
    }

    protected Dag processSetProperty(KernelInterfaceProperties prop, Dag dag) {
        Dag result = null;
        String name = null;
        Dag value = null;
        if ((DagUtil.isEquation(dag) || DagUtil.isExpSeq(dag)) && dag.getLength() >= 2) {
            if (DagUtil.isName(dag.getChild(0))) {
                name = dag.getChild(0).getData();
            }
            if (DagUtil.isComplex(value = dag.getChild(1))) {
                value = prop.getDagValue("imaginaryunit");
            }
        }
        if (name == null) {
            result = DagUtil.createErrorDag("No name for property set");
        } else if (value == null) {
            result = DagUtil.createErrorDag("A null value was found for the " + name + " property");
        } else {
            result = this.setCallDisable && !KernelInterfaceProperties.shouldChangeOnReset(name) ? prop.getDagValue(name) : prop.setValue(name, value);
            if (result == null) {
                result = DagUtil.createErrorDag("A null value was found for the " + name + " property");
            }
        }
        return result;
    }

    public boolean getCallDisable() {
        return this.setCallDisable;
    }

    public boolean isConnected() {
        return this.connector.getConnection() != null;
    }

    public KernelEvent processGetHandler(KernelEvent event) {
        KernelInterfaceProperties prop;
        if (this.isConnected() && (prop = this.connector.getConnection().getInterfaceProperties()) != null) {
            event = prop.createGetReply(event.getDag(), event);
        }
        return event;
    }

    public KernelEvent processSetHandler(KernelEvent event) {
        KernelConnection connection;
        KernelInterfaceProperties prop;
        if (this.isConnected() && (prop = (connection = this.connector.getConnection()).getInterfaceProperties()) != null) {
            prop = this.transformSet(event, prop);
            connection.setInterfaceProperties(prop);
        }
        return event;
    }

    public void setCallDisable(boolean status) {
        this.setCallDisable = status;
    }
}

