/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractElisionDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.BinaryOperationTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public abstract class AbstractBinopDagFactory
extends AbstractElisionDagFactory {
    public abstract int getType();

    public abstract String getStringOperator(WmiLPrintOptions var1);

    public final String getStringOperator() {
        return this.getStringOperator(new WmiLPrintOptions());
    }

    abstract boolean isVariableLength();

    @Override
    protected String getElisionThresholdProperty() {
        return "elisiontermsthreshold";
    }

    @Override
    protected String getElisionAfterProperty() {
        return "elisiontermsafter";
    }

    @Override
    protected String getElisionBeforeProperty() {
        return "elisiontermsbefore";
    }

    @Override
    protected int getDefaultElideThreshold() {
        return 1000;
    }

    public static Dag create(int type, Dag kid1, Dag kid2) {
        Dag[] kids = new Dag[]{kid1, kid2};
        return Dag.createDag(type, kids, null, true);
    }

    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        int length = this.isVariableLength() ? DagBuilder.parseShortInteger(is) : 3;
        return this.readDotm(is, this.getType(), length);
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        this.writeDotm(sb, dag, this.getType(), this.isVariableLength());
    }

    abstract NotationLayoutBox createNotationBox(LayoutFormatter var1);

    protected void infixLinePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        int length = dag.getLength();
        if (length > 0) {
            int i = 0;
            while (i < length) {
                Dag child = dag.getChild(i);
                if (this.addBrackets(child, options)) {
                    result.append("(");
                    DagBuilder.linePrint(result, child, options);
                    result.append(")");
                } else {
                    DagBuilder.linePrint(result, child, options);
                }
                if (i < length - 1) {
                    result.append(this.getStringOperator(options));
                }
                ++i;
            }
        }
    }

    protected void prefixLinePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        int length = dag.getLength();
        String opName = this.getStringOperator(options);
        if (opName != null) {
            opName = opName.trim();
        }
        result.append("`" + opName + "`(");
        int i = 0;
        while (i < length) {
            if (i > 0) {
                result.append(", ");
            }
            Dag child = dag.getChild(i);
            DagBuilder.linePrint(result, child, options);
            ++i;
        }
        result.append(")");
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        if (options.isInLineIfPossible()) {
            this.infixLinePrint(result, dag, options);
        } else {
            this.prefixLinePrint(result, dag, options);
        }
    }

    public boolean addBrackets(Dag dag, WmiLPrintOptions options) {
        return DagBuilder.getPrecedence(dag, options) > this.getPrecedence();
    }

    public final boolean addBrackets(Dag dag) {
        throw new Error("Go away");
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        return this.createLayout(f, dag, false);
    }

    public LayoutBox createLayout(LayoutFormatter f, Dag dag, boolean equalPrecedence) {
        int precedenceRule = equalPrecedence ? 0 : 1;
        int length = dag.getLength();
        InlineLayoutBox box = new InlineLayoutBox(2 * length);
        if (length > 0) {
            int i = 0;
            while (i < length) {
                BinaryOperationTemplate.apply(f, (LayoutBox)box, this.createNotationBox(f), dag.getChild(i), this.getPrecedence(), precedenceRule);
                ++i;
            }
        }
        box.setLineBreaker(LineBreakerFactory.newLineBreaker(13));
        return box;
    }
}

