/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public abstract class AbstractKeyWordDagFactory
extends AbstractDagFactory {
    public abstract int getType();

    public abstract String getKeyWord();

    public abstract int getLength();

    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        return this.readDotm(is, this.getType(), this.getLength());
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        this.writeDotm(sb, dag, this.getType(), false);
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        result.append(this.getKeyWord());
        if (this.getLength() > 1 && dag.getLength() > 0) {
            result.append(" ");
            DagBuilder.linePrint(result, dag.getChild(0), options);
        }
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        InlineLayoutBox b = new InlineLayoutBox(1);
        String value = this.getKeyWord();
        b.addChild(NotationLayoutBox.createCustomBox(f, value, 2));
        if (this.getLength() > 1 && dag.getLength() > 0) {
            b.addChild(DagBuilder.createLayout(f, dag.getChild(0)));
        }
        return b;
    }
}

