/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.LeafDag;

public class AttributedLeafDag
extends LeafDag {
    private Dag attributes;
    private String moduleNameData;

    public AttributedLeafDag(int type, Object dagData) {
        super(type, dagData);
    }

    @Override
    public Dag copy() {
        AttributedLeafDag copy = new AttributedLeafDag(this.theType, this.data);
        copy.setAttributes(this.getAttributes());
        return copy;
    }

    @Override
    public void setAttributes(Dag dagAttributes) {
        this.attributes = dagAttributes;
        this.moduleNameData = null;
    }

    @Override
    public String getData() {
        if (this.moduleNameData == null) {
            if (this.attributes instanceof BranchDag && this.attributes.getLength() > 0) {
                this.moduleNameData = this.getModuleName();
            }
            if (this.moduleNameData != null && this.moduleNameData.length() > 0) {
                if (this.data != null) {
                    this.moduleNameData = String.valueOf(this.moduleNameData) + ":-" + this.data.toString();
                }
            } else {
                this.moduleNameData = this.data.toString();
            }
        }
        return this.moduleNameData;
    }

    @Override
    public String getDataOnly() {
        return this.data.toString();
    }

    @Override
    public Dag getAttributes() {
        return this.attributes;
    }

    @Override
    public void dispose() {
        this.attributes = null;
        super.dispose();
    }

    public String getModuleName() {
        return DagBuilder.getModuleName(this.attributes);
    }
}

