/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;

public class BranchDag
extends Dag {
    protected Dag[] theDags;

    public BranchDag(int type, Dag[] dags) {
        super(type);
        this.setChildren(dags);
    }

    @Override
    public void setChildren(Dag[] children) {
        this.theDags = children;
    }

    @Override
    public void setDags(Dag[] dags) {
        this.setChildren(dags);
    }

    @Override
    public Dag[] getChildrenAsArray() {
        Dag[] reply = this.theDags;
        int length = this.theDags.length;
        return reply;
    }

    @Override
    public void setData(Object data) {
    }

    @Override
    public String getData() {
        return null;
    }

    @Override
    public int computeHashCode() {
        int hash = 0;
        if (this.theDags != null) {
            int i = 0;
            while (i < this.theDags.length) {
                if (this.theDags[i] != null) {
                    hash ^= this.theDags[i].hashCode();
                }
                ++i;
            }
        }
        return hash;
    }

    @Override
    public void dispose() {
        if (this.theDags != null) {
            int i = 0;
            while (i < this.theDags.length) {
                if (this.theDags[i] != null) {
                    this.theDags[i].dispose();
                }
                ++i;
            }
        }
        this.theDags = null;
    }

    @Override
    public Dag copy() {
        Dag[] newDags = new Dag[this.theDags.length];
        System.arraycopy(this.theDags, 0, newDags, 0, newDags.length);
        return new BranchDag(this.theType, newDags);
    }

    @Override
    public Dag deepCopy() {
        Dag[] newDags = new Dag[this.theDags.length];
        int i = 0;
        while (i < newDags.length) {
            if (this.theDags[i] != null) {
                newDags[i] = this.theDags[i].deepCopy();
            }
            ++i;
        }
        return new BranchDag(this.theType, newDags);
    }

    @Override
    public void insertChild(int index, Dag child) {
        this.theDags = this.theDags == null ? (this.theDags = new Dag[1]) : this.theDags;
        this.rangeCheck(index);
        Dag[] newAry = new Dag[this.getLength() + 1];
        newAry[index] = child;
        System.arraycopy(this.theDags, 0, newAry, 0, index);
        System.arraycopy(this.theDags, index, newAry, index + 1, this.theDags.length - index);
        this.theDags = newAry;
    }

    @Override
    public void insertChildren(int index, Dag[] children) {
        this.theDags = this.theDags == null ? (this.theDags = new Dag[1]) : this.theDags;
        this.rangeCheck(index);
        if (children[0] == null) {
            throw new NullPointerException("children argument to insertChildrencannot contain null dags.");
        }
        Dag[] newAry = new Dag[this.getLength() + children.length];
        System.arraycopy(this.theDags, 0, newAry, 0, index);
        System.arraycopy(children, 0, newAry, index, children.length);
        System.arraycopy(this.theDags, index, newAry, index + children.length + 1, this.theDags.length - index);
        this.theDags = newAry;
    }

    @Override
    public void replaceChildren(int start, int end, Dag child) {
        this.rangeModifyChildren(start, end, null);
        this.insertChild(start, child);
    }

    @Override
    public void replaceChildren(int start, int end, Dag[] children) {
        this.rangeModifyChildren(start, end, children);
    }

    @Override
    public void removeChild(int index) {
        this.rangeCheck(index);
        Dag[] newArg = new Dag[this.theDags.length - 1];
        System.arraycopy(this.theDags, 0, newArg, 0, index);
        System.arraycopy(this.theDags, index + 1, newArg, index, newArg.length - index);
        this.theDags = newArg;
    }

    private void rangeModifyChildren(int start, int end, Dag[] copyDags) {
        int cpSize;
        if (end < start) {
            throw new IndexOutOfBoundsException("End Argument (" + end + ") less then start (" + start + ") in removeChildren.");
        }
        this.rangeCheck(start);
        this.rangeCheck(end);
        Dag[] newArg = null;
        int cdagslength = 0;
        if (copyDags == null) {
            newArg = new Dag[this.theDags.length - (end - start) - 1];
        } else {
            cdagslength = copyDags.length;
            newArg = new Dag[this.theDags.length - (end - start) - 1 + cdagslength];
        }
        System.arraycopy(this.theDags, 0, newArg, 0, start);
        if (copyDags != null) {
            System.arraycopy(copyDags, 0, newArg, start, cdagslength);
        }
        cpSize = (cpSize = this.theDags.length - (end - start) - start - 1) < 0 ? 0 : cpSize;
        cdagslength = copyDags == null ? 0 : cdagslength;
        System.arraycopy(this.theDags, end + 1, newArg, start + cdagslength, cpSize);
        this.theDags = newArg;
    }

    @Override
    public int getLength() {
        int length = this.theDags == null ? 0 : this.theDags.length;
        return length;
    }

    @Override
    public void setLength(int length) {
        this.theDags = new Dag[length];
    }

    @Override
    public void setChild(int index, Dag child) {
        this.rangeCheck(index);
        this.theDags[index] = child;
    }

    @Override
    public Dag getChild(int index) {
        this.rangeCheck(index);
        return this.theDags[index];
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.getLength()) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.getLength());
        }
    }
}

