/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.ProdDagFactory;
import com.maplesoft.client.dag.SumDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BinaryOperationTemplate;
import com.maplesoft.client.prettyprinter.template.UnaryOperationTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class ComplexDagFactory
extends AbstractDagFactory {
    static Dag pureImaginary = null;
    static Dag complexUnit = null;
    static Dag unity = null;

    static {
        Dag[] pureParts = new Dag[]{DagConstants.ONE};
        pureImaginary = Dag.createDag(6, pureParts, null, false);
        pureImaginary.setNormalized(pureImaginary);
        complexUnit = Dag.createDag(8, null, "I", false);
        unity = Dag.createDag(2, null, "1", false);
    }

    @Override
    public void updateContext(DagRenderContext context) {
        Object value = context.getInterfaceProperty("imaginaryunit");
        if (value != null) {
            complexUnit = Dag.createDag(8, null, value.toString(), false);
        }
    }

    @Override
    public int getPrecedence(Dag dag) {
        Dag child;
        int precedence = 6;
        int length = dag.getLength();
        if (length == 1 && !DagUtil.isNegative(child = dag.getChild(0))) {
            precedence = DagUtil.isOne(child) ? 1 : 4;
        }
        return precedence;
    }

    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        return this.readDotm(is, 6, DagBuilder.parseShortInteger(is));
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        this.writeDotm(sb, dag, 6, true);
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        Dag imag = null;
        Dag real = null;
        int length = dag.getLength();
        if (length == 1) {
            imag = dag.getChild(0);
            if (DagUtil.isMinusOne(imag)) {
                result.append("-");
            } else if (!DagUtil.isOne(imag)) {
                DagBuilder.linePrint(result, imag, options);
                result.append("*");
            }
            result.append(options.getImaginaryUnit());
        } else {
            real = dag.getChild(0);
            imag = dag.getChild(1);
            DagBuilder.linePrint(result, real, options);
            if (DagUtil.isMinusOne(imag)) {
                result.append("-");
            } else {
                if (!DagUtil.isNegative(imag)) {
                    result.append("+");
                }
                if (!DagUtil.isOne(imag)) {
                    boolean addBrackets;
                    boolean bl = addBrackets = DagBuilder.getPrecedence(imag, options) > 4;
                    if (addBrackets) {
                        result.append("(");
                    }
                    DagBuilder.linePrint(result, imag, options);
                    if (addBrackets) {
                        result.append(")");
                    }
                    result.append("*");
                }
            }
            result.append(options.getImaginaryUnit());
        }
    }

    @Override
    public Dag normalize(Dag dag) {
        Dag normalized = null;
        if (dag != null && dag.getType() == 6) {
            normalized = dag.isNormalized() ? dag : this.doNormalization(dag);
        }
        return normalized;
    }

    public Dag doNormalization(Dag dag) {
        Dag normalized = null;
        int length = dag.getLength();
        if (length == 1) {
            Dag scale = dag.getChild(0);
            if (DagUtil.isNegative(scale)) {
                Dag term = null;
                term = DagUtil.isMinusOne(scale) ? pureImaginary : ProdDagFactory.create(DagUtil.negate(scale), 1, pureImaginary, 1);
                Dag[] sumKids = new Dag[]{term, DagConstants.MINUS_ONE};
                normalized = Dag.createDag(16, sumKids, null, false);
            } else {
                normalized = DagUtil.isOne(scale) ? pureImaginary : ProdDagFactory.create(scale, 1, pureImaginary, 1);
            }
        } else {
            Dag[] sumKids = new Dag[4];
            Dag scale = dag.getChild(0);
            if (DagUtil.isNegative(scale)) {
                sumKids[0] = DagUtil.negate(scale);
                sumKids[1] = DagConstants.MINUS_ONE;
            } else {
                sumKids[0] = scale;
                sumKids[1] = DagConstants.ONE;
            }
            scale = dag.getChild(1);
            if (DagUtil.isNegative(scale)) {
                scale = DagUtil.negate(scale);
                sumKids[3] = DagConstants.MINUS_ONE;
            } else {
                sumKids[3] = DagConstants.ONE;
            }
            sumKids[2] = DagUtil.isOne(scale) ? pureImaginary : ProdDagFactory.create(scale, 1, pureImaginary, 1);
            normalized = Dag.createDag(16, sumKids, null, false);
        }
        dag.setNormalized(normalized);
        return normalized;
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        String boxName = DagBuilder.ELEMENT_NAME[6];
        int length = dag.getLength();
        ComplexLayoutBox box = new ComplexLayoutBox(boxName, length + 2);
        if (length == 1) {
            this.createLayoutForPureImaginary(f, dag, box);
        } else {
            this.createLayoutForRealAndImaginary(f, dag, box);
        }
        box.setSelectionData(new StandardSelectionData(2));
        return box;
    }

    public void createLayoutForRealAndImaginary(LayoutFormatter f, Dag dag, LayoutBox box) {
        Dag d = null;
        int notationSign = 1;
        Dag real = dag.getChild(0);
        Dag imag = dag.getChild(1);
        if (DagUtil.isNegative(real)) {
            Dag[] dd = new Dag[]{DagUtil.negate(real), DagUtil.createIntDag(-1)};
            d = SumDagFactory.create(dd);
        } else {
            d = real;
        }
        BinaryOperationTemplate.apply(f, box, notationSign, d, this.getPrecedence(dag));
        if (!DagUtil.isNegative(imag)) {
            d = DagUtil.isOne(imag) ? complexUnit : ProdDagFactory.create(imag, complexUnit);
        } else {
            d = DagUtil.isMinusOne(imag) ? complexUnit : (DagUtil.isNegative(imag) ? ProdDagFactory.create(DagUtil.negate(imag), complexUnit) : ProdDagFactory.create(imag, complexUnit));
            notationSign = 2;
        }
        BinaryOperationTemplate.apply(f, box, notationSign, d, this.getPrecedence(dag));
    }

    public void createLayoutForPureImaginary(LayoutFormatter f, Dag dag, LayoutBox box) {
        Dag d = null;
        Dag child = dag.getChild(0);
        if (DagUtil.isPositive(child)) {
            d = DagUtil.isOne(child) ? complexUnit : ProdDagFactory.create(child, complexUnit);
            BinaryOperationTemplate.apply(f, box, 1, d, this.getPrecedence(dag));
        } else {
            int notation;
            int n = notation = child.getType() == 3 || ProdDagFactory.isQuotient(child) ? 111 : 24;
            if (DagUtil.isMinusOne(child)) {
                d = complexUnit;
                box.addChild(UnaryOperationTemplate.apply(f, notation, d, this.getPrecedence(dag)));
            } else if (DagUtil.isNegative(child)) {
                d = ProdDagFactory.create(DagUtil.negate(child), complexUnit);
                box.addChild(UnaryOperationTemplate.apply(f, notation, d, this.getPrecedence(dag)));
            } else {
                d = ProdDagFactory.create(child, complexUnit);
                box = DagBuilder.createLayout(f, d);
            }
        }
    }

    static class ComplexLayoutBox
    extends InlineLayoutBox {
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker(10);

        ComplexLayoutBox(String s, int i) {
            super(s, i);
        }

        ComplexLayoutBox() {
        }

        @Override
        public void setLineBreaker(LineBreaker l) {
        }

        @Override
        public LineBreaker getLineBreaker() {
            return lb;
        }
    }
}

