/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AttributedBranchDag;
import com.maplesoft.client.dag.AttributedLeafDag;
import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstructor;
import com.maplesoft.client.dag.HybridDag;
import com.maplesoft.client.dag.LeafDag;

public abstract class Dag {
    protected int theType;
    protected Dag normalized;
    protected int hash;

    protected Dag(int type) {
        this.theType = type;
    }

    public static Dag createDag(int type, Dag[] children, Object data, boolean attributed) {
        Dag dag = null;
        DagConstructor constructor = DagBuilder.getConstructor(type);
        dag = constructor == null ? (children != null && data == null ? (attributed ? new AttributedBranchDag(type, children) : new BranchDag(type, children)) : (data != null && children == null ? (attributed ? new AttributedLeafDag(type, data) : new LeafDag(type, data)) : new HybridDag(type, children, data))) : constructor.createDag(type, children, data, attributed);
        return dag;
    }

    public void setType(int type) {
        this.theType = type;
    }

    public int getType() {
        return this.theType;
    }

    public void addChild(Dag child) {
        this.insertChild(this.getLength(), child);
    }

    public abstract void insertChild(int var1, Dag var2);

    public abstract void insertChildren(int var1, Dag[] var2);

    public abstract int getLength();

    public abstract void setLength(int var1);

    public abstract void setChild(int var1, Dag var2);

    public abstract void replaceChildren(int var1, int var2, Dag var3);

    public abstract void replaceChildren(int var1, int var2, Dag[] var3);

    public abstract void removeChild(int var1);

    public abstract Dag getChild(int var1);

    public abstract Dag copy();

    public Dag deepCopy() {
        return this.copy();
    }

    public abstract void setChildren(Dag[] var1);

    public abstract void setDags(Dag[] var1);

    public abstract void setData(Object var1);

    public abstract String getData();

    public String getDataOnly() {
        return this.getData();
    }

    public void setAttributes(Dag attributes) {
    }

    public Dag getAttributes() {
        return null;
    }

    public boolean isNormalized() {
        return this.normalized != null;
    }

    public Dag getNormalized() {
        if (this.normalized == null) {
            this.normalized = DagBuilder.normalize(this);
        }
        return this.normalized;
    }

    public void setNormalized(Dag dag) {
        if (dag != null) {
            this.normalized = dag;
            dag.normalized = dag;
        }
    }

    public Dag[] getChildrenAsArray() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Dag)) {
            return false;
        }
        Dag dag = (Dag)obj;
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        if (dag.getType() != this.theType) {
            return false;
        }
        String theData = this.getData();
        if (theData != null && !theData.equals(dag.getData())) {
            return false;
        }
        if (theData == null && dag.getData() != null) {
            return false;
        }
        int length = this.getLength();
        if (dag.getLength() != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            Dag child1 = this.getChild(i);
            Dag child2 = dag.getChild(i);
            if (child1.hashCode() != child2.hashCode()) {
                return false;
            }
            if (!child1.equals(child2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final int hashCode() {
        if (this.hash == 0) {
            this.hash = this.computeHashCode();
            if (this.hash < 0) {
                this.hash = -this.hash;
            }
        }
        return this.hash;
    }

    public abstract int computeHashCode();

    public void clearHash() {
        this.hash = 0;
        int length = this.getLength();
        int i = 0;
        while (i < length) {
            Dag child = this.getChild(i);
            if (child != null) {
                child.clearHash();
            }
            ++i;
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String s = "";
        String theData = this.getDataOnly();
        int length = this.getLength();
        s = String.valueOf(s) + DagBuilder.CLASS_NAMES[this.theType] + "#" + this.theType + " {" + System.identityHashCode(this) + "} |" + theData + "| - ";
        if (length > 0) {
            s = String.valueOf(s) + " (" + length + ")";
            int i = 0;
            while (i < length) {
                s = String.valueOf(s) + "\n" + indent + ".   " + (i + 1) + "  ";
                Dag child = this.getChild(i);
                s = child == null ? String.valueOf(s) + "--> null" : String.valueOf(s) + child.toString(String.valueOf(indent) + ".   ");
                ++i;
            }
        } else if (this instanceof AttributedLeafDag && !this.equals(this.getAttributes()) && this.getAttributes() != null) {
            s = String.valueOf(s) + "\n" + indent + ".   *" + this.getAttributes().toString(String.valueOf(indent) + ".   ");
        }
        return s;
    }

    public void dispose() {
    }
}

