/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.KernelInterfaceProperties;
import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.AttributedLeafDag;
import com.maplesoft.client.dag.BackrefBuilder;
import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagConstructor;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.DotMParseError;
import com.maplesoft.client.dag.NameDagFactory;
import com.maplesoft.client.dag.ParamDagFactory;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.preprocessor.PreprocessorSubstitutionTable;
import com.maplesoft.client.prettyprinter.AbstractFormatter;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.LayoutVector;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.PostLayoutJob;
import com.maplesoft.client.prettyprinter.PostLayoutJobQueue;
import com.maplesoft.client.prettyprinter.SubexpressionLabelLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.WmiByteArrayInputStream;
import com.maplesoft.util.encoder.KernelEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DagBuilder {
    String PositiveINT = "INTPOS(1)";
    String NegativeINT = "INTNEG(1)";
    static String DotMParseErrorString = "Input Error at 4: unexpected end of input";
    static HandleAssumptionPostProcessor assumptionHandler = new HandleAssumptionPostProcessor();
    public static HashMap elementToType = new HashMap();
    public static final String[] ELEMENT_NAME = new String[]{"", "intneg", "intpos", "rational", "float", "hfloat", "complex", "string", "name", "member", "tableref", "dcolon", "catenate", "power", "prod", "series", "sum", "zppoly", "function", "uneval", "equation", "inequat", "lesseq", "lessthan", "and", "not", "or", "xor", "implies", "expseq", "list", "local", "param", "lexical", "proc", "range", "set", "table", "rtable", "moddef", "module", "assign", "for", "if", "read", "save", "statseq", "stop", "error", "try", "return", "break", "next", "use", "binary", "hash", "backref", "garbage", "foreign", "control", "debug"};
    public static String[] CLASS_NAMES = new String[]{"", "IntnegDagFactory", "IntposDagFactory", "RationalDagFactory", "FloatDagFactory", "HfloatDagFactory", "ComplexDagFactory", "StringDagFactory", "NameDagFactory", "MemberDagFactory", "TablerefDagFactory", "DcolonDagFactory", "CatenateDagFactory", "PowerDagFactory", "ProdDagFactory", "SeriesDagFactory", "SumDagFactory", "ZppolyDagFactory", "FunctionDagFactory", "UnevalDagFactory", "EquationDagFactory", "InequatDagFactory", "LesseqDagFactory", "LessthanDagFactory", "AndDagFactory", "NotDagFactory", "OrDagFactory", "XorDagFactory", "ImpliesDagFactory", "ExpseqDagFactory", "ListDagFactory", "LocalDagFactory", "ParamDagFactory", "LexicalDagFactory", "ProcDagFactory", "RangeDagFactory", "SetDagFactory", "TableDagFactory", "RtableDagFactory", "ModdefDagFactory", "ModuleDagFactory", "AssignDagFactory", "ForDagFactory", "IfDagFactory", "ReadDagFactory", "SaveDagFactory", "StatseqDagFactory", "StopDagFactory", "ErrorDagFactory", "TryDagFactory", "ReturnDagFactory", "BreakDagFactory", "NextDagFactory", "UseDagFactory", "BinaryDagFactory", "HashTableDagFactory", "BackrefDagFactory", "GarbageDagFactory", "ForeignDagFactory", "ControlDagFactory", "DebugDagFactory"};
    protected static SelectionData assumptionStatementSelectionData = new SelectionData();
    protected static SelectionData assumptionSelectionData = new SelectionData();
    private static final int PROC_LAST_NORMALIZE_DAG = 6;
    public static final String ATTRIBUTE_LENGTH = "length";
    public static final String ATTRIBUTE_DATA = "data";
    private static DocumentBuilder docBuilder;
    private static int currentMark;
    static Dag dagPosIdentity;
    static Dag dagNegIdentity;
    static AbstractDagFactory[] factories;
    static int dagCount;
    static final int ORIGINALBACKREFARRAYSIZE = 400;
    private static Vector theDags;
    private static BackrefBuilder backRefMap;
    private static boolean wantBackRef;
    InputStream sr;
    static boolean inProc;
    private static int depthCount;
    private static final int MAXDEPTH = 600;
    private static final boolean LPrintDebug = false;
    private static final char[] DIGITS;
    private static StringBuffer digitsBuffer;
    private static char[] hexdigits;
    private static StringBuffer moduleNameBuffer;

    static {
        DagBuilder.FillInputTable();
        DagBuilder.readClasses();
        DagBuilder.fillElement2TypeTable();
        assumptionSelectionData.setFirstCaretPosition(0);
        assumptionSelectionData.setLastCaretPosition(1);
        assumptionSelectionData.setContextHelpAvailable(false);
        assumptionSelectionData.setSelectionCode(4);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = -10;
        assumptionSelectionData.setTraversalNorthSouth(nArray);
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = -10;
        assumptionSelectionData.setTraversalEastWest(nArray2);
        assumptionStatementSelectionData.setContextHelpAvailable(false);
        assumptionStatementSelectionData.setSelectionCode(4);
        assumptionStatementSelectionData.setTraversalNorthSouth(new int[]{-10});
        assumptionStatementSelectionData.setTraversalEastWest(new int[]{-10});
        theDags = new Vector(400);
        wantBackRef = true;
        inProc = false;
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        digitsBuffer = new StringBuffer();
        hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        moduleNameBuffer = new StringBuffer();
    }

    static void fillElement2TypeTable() {
        int i = 0;
        while (i < ELEMENT_NAME.length) {
            elementToType.put(ELEMENT_NAME[i], new Integer(i));
            ++i;
        }
    }

    static DocumentBuilder getDocBuilder() {
        if (docBuilder == null) {
            try {
                docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return docBuilder;
    }

    static void readClasses() {
        factories = new AbstractDagFactory[CLASS_NAMES.length];
        int good = 0;
        int i = 1;
        while (i < CLASS_NAMES.length) {
            try {
                String s = "com.maplesoft.client.dag." + CLASS_NAMES[i];
                Class<?> c = Class.forName(s);
                DagBuilder.factories[i] = (AbstractDagFactory)c.newInstance();
                ++good;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        dagPosIdentity = DagConstants.ONE;
        dagNegIdentity = DagConstants.MINUS_ONE;
    }

    public static void depthPlus() throws ArrayIndexOutOfBoundsException {
        if (++depthCount > 600) {
            throw new DotMParseError("Too many levels of recursion for display");
        }
    }

    public static void depthMinus() {
        --depthCount;
    }

    public static void putDag(Dag dag, int cnt) {
        theDags.set(cnt - 1, dag);
    }

    public static Dag getDag(int pos) {
        return (Dag)theDags.get(pos - 1);
    }

    public static int dagCountPlus() {
        theDags.add(DagConstants.EMPTY);
        return ++dagCount;
    }

    public static int getCount() {
        return dagCount;
    }

    public static synchronized Dag createDag(String dotm) throws IOException {
        return DagBuilder.createDag(dotm.getBytes());
    }

    public static synchronized Dag createDag(byte[] dotm) throws IOException {
        dagCount = 0;
        WmiByteArrayInputStream sr = new WmiByteArrayInputStream(dotm);
        Dag tmp = null;
        try {
            tmp = DagBuilder.create(sr);
            int count = sr.available();
        }
        catch (DotMParseError dpe) {
            tmp = NameDagFactory.createNameDag(dpe.getMessage());
        }
        if (theDags.size() > 400) {
            theDags.setSize(400);
        }
        theDags.clear();
        depthCount = 0;
        return tmp;
    }

    public static Dag create(WmiByteArrayInputStream sr) throws IOException {
        Dag dag = null;
        int ch = sr.read();
        if (ch == -1) {
            return DagConstants.EMPTY;
        }
        int dagIndex = ch - 33 + 1;
        ProcDagFactory.setActiveProcSubtype((char)ch);
        int dagType = 0;
        if (dagIndex > 0) {
            try {
                if (dagIndex == 84 || dagIndex == 74) {
                    dagType = 34;
                } else if (dagIndex >= MapleNumbers.dotMInputTable.length) {
                    dag = ParamDagFactory.createParamDag(dagIndex);
                    dagType = 0;
                } else {
                    dagType = MapleNumbers.dotMInputTable[dagIndex];
                }
                boolean attributed = false;
                if (dagType > 60) {
                    switch (dagType) {
                        case 105: {
                            dag = factories[31].readDotm(sr);
                            dag.setType(33);
                            dagType = 0;
                            break;
                        }
                        case 106: {
                            dagType = 31;
                            break;
                        }
                        case 107: {
                            dagType = 32;
                            break;
                        }
                        case 104: {
                            dag = factories[34].readDotm(sr, 8);
                            dagType = 0;
                            break;
                        }
                        case 109: {
                            dag = factories[34].readDotm(sr, 9);
                            dagType = 0;
                            break;
                        }
                        case 108: {
                            dag = factories[38].readDotm(sr, 0);
                            dagType = 0;
                            break;
                        }
                        default: {
                            attributed = true;
                            dagType -= 57;
                        }
                    }
                }
                if (dagType > 0) {
                    dag = factories[dagType].readDotm(sr);
                }
                if (attributed) {
                    dag.setAttributes(DagBuilder.create(sr));
                }
            }
            catch (NullPointerException npe) {
                dag = DagConstants.EMPTY;
            }
            catch (ArrayIndexOutOfBoundsException aiobe) {
                throw new DotMParseError("...");
            }
        }
        return dag;
    }

    public static synchronized String createDotm(Dag dag) {
        return DagBuilder.createDotm(dag, true);
    }

    public static synchronized String createDotm(Dag dag, boolean wbr) {
        wantBackRef = wbr;
        backRefMap = wantBackRef && (dag.getLength() > 1 || dag.getAttributes() != null) ? (backRefMap = new BackrefBuilder(dag)) : null;
        dag.clearHash();
        StringBuffer sb = new StringBuffer();
        DagBuilder.writeDotm(sb, dag);
        backRefMap = null;
        return sb.toString();
    }

    public static boolean getBackRefFlag() {
        return wantBackRef;
    }

    public static BackrefBuilder getBackrefs() {
        return backRefMap;
    }

    public static void writeDotm(StringBuffer sb, Dag dag) {
        if (dag != null && sb != null) {
            int dagType = dag.getType();
            factories[dagType].writeDotm(sb, dag);
        }
    }

    public static String writeDotm(Dag dag) {
        StringBuffer sb = new StringBuffer();
        DagBuilder.writeDotm(sb, dag);
        return sb.toString();
    }

    public static Dag createDag(Document xmlDAG) {
        Dag dag = null;
        dag = DagBuilder.dagFromXML(xmlDAG.getDocumentElement());
        return dag;
    }

    static Dag dagFromXML(Node xmlDagSection) {
        NamedNodeMap attributes = xmlDagSection.getAttributes();
        NodeList docChildren = xmlDagSection.getChildNodes();
        String typeName = xmlDagSection.getNodeName();
        int typeCode = -1;
        typeCode = (Integer)elementToType.get(typeName);
        Node data = attributes.getNamedItem(ATTRIBUTE_DATA);
        int numberChildren = 0;
        int i = 0;
        while (i < docChildren.getLength()) {
            if (docChildren.item(i) instanceof Element) {
                ++numberChildren;
            }
            ++i;
        }
        Dag[] children = null;
        children = new Dag[numberChildren];
        int dagIndexCount = 0;
        int i2 = 0;
        while (i2 <= docChildren.getLength()) {
            if (docChildren.item(i2) instanceof Element) {
                children[dagIndexCount++] = DagBuilder.dagFromXML(docChildren.item(i2));
            }
            ++i2;
        }
        if (data != null && numberChildren == 0) {
            children = null;
        }
        return Dag.createDag(typeCode, children, data != null ? data.getNodeValue() : null, true);
    }

    public static int getPrecedence(Dag dag) {
        int precedence = 20;
        if (dag != null) {
            int type = dag.getType();
            precedence = factories[type].getPrecedence(dag);
        }
        return precedence;
    }

    public static int getPrecedence(Dag dag, LayoutFormatter format) {
        int precedence = 20;
        if (dag != null) {
            int type = dag.getType();
            precedence = factories[type].getPrecedence(dag, format);
        }
        return precedence;
    }

    public static int getPrecedence(Dag dag, WmiLPrintOptions options) {
        int precedence = 20;
        if (dag != null) {
            int type = dag.getType();
            precedence = factories[type].getPrecedence(dag, options);
        }
        return precedence;
    }

    public static DagConstructor getConstructor(int type) {
        AbstractDagFactory builder = factories != null ? factories[type] : null;
        return builder != null ? builder.getConstructor() : null;
    }

    public static void updateContext(int type, DagRenderContext context) {
        AbstractDagFactory builder;
        AbstractDagFactory abstractDagFactory = builder = factories != null ? factories[type] : null;
        if (builder != null) {
            builder.updateContext(context);
        }
    }

    public static String getName(InputStream sr, int len) throws IOException {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < len) {
            char ch = (char)DagBuilder.getNextChar(sr);
            if (ch > ' ' && ch < '{') {
                result.append(ch);
            } else if (ch == '~') {
                result.append(' ');
            } else if (ch == '|') {
                result.append((char)DagBuilder.parseShortInteger(sr));
            }
            ++i;
        }
        String reply = null;
        reply = result.toString();
        KernelEncoder encoder = RuntimeLocale.getKernelEncoder();
        if (encoder != null) {
            reply = encoder.toUnicode(reply, true);
        }
        return reply;
    }

    public static void writeNameAsDotm(StringBuffer sb, String name) {
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (ch > ' ' && ch < '{') {
                sb.append(ch);
            } else if (ch == ' ') {
                sb.append("~");
            } else {
                sb.append("|");
                DagBuilder.writeShortInteger(sb, ch);
            }
            ++i;
        }
    }

    public static int getNextChar(InputStream sr) throws IOException {
        int ch = sr.read();
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseDigits(InputStream sr, int len) throws IOException {
        String s = null;
        StringBuffer stringBuffer = digitsBuffer;
        synchronized (stringBuffer) {
            DagBuilder.parseDigitsIntoBuffer(sr, len, digitsBuffer);
            s = digitsBuffer.toString();
            if (digitsBuffer.capacity() > 1000) {
                digitsBuffer.setLength(0);
            }
        }
        return s;
    }

    public static void parseDigitsIntoBuffer(InputStream sr, int len, StringBuffer buffy) throws IOException {
        buffy.setLength(len);
        int ch = 0;
        while (len > 0) {
            ch = DagBuilder.getNextChar(sr);
            if (ch >= 33 && ch < 43) {
                buffy.setCharAt(--len, DIGITS[ch - 33]);
                continue;
            }
            int q = (ch -= 43) * 52429 >>> 19;
            int r = ch - ((q << 3) + (q << 1));
            buffy.setCharAt(--len, DIGITS[r]);
            ch = q;
            if (ch > 0) {
                q = ch * 52429 >>> 19;
                r = ch - ((q << 3) + (q << 1));
                if (len > 0) {
                    buffy.setCharAt(--len, DIGITS[r]);
                    continue;
                }
                buffy.insert(0, DIGITS[r]);
                break;
            }
            if (len > 0) {
                buffy.setCharAt(--len, '0');
                continue;
            }
            buffy.insert(0, '0');
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int skipShortInteger(String dotm, int start) {
        i = start;
        ch = dotm.charAt(i);
        if (ch == '~') {
            ch = dotm.charAt(++i);
        }
        ++i;
        if (ch < '!' || ch > 'Z') ** GOTO lbl10
        return i;
lbl-1000:
        // 1 sources

        {
            ch = dotm.charAt(i);
            ++i;
lbl10:
            // 2 sources

            ** while (ch >= '[' && ch <= 'k')
        }
lbl11:
        // 1 sources

        return i;
    }

    public static int parseShortInteger(InputStream sr) throws IOException {
        int sign = 1;
        int shift = 0;
        int n = 0;
        int ch = DagBuilder.getNextChar(sr);
        if (ch == 126) {
            sign = -1;
            ch = DagBuilder.getNextChar(sr);
        }
        if (ch >= 33 && ch <= 90) {
            return sign * (ch - 33);
        }
        shift = 0;
        n = 0;
        while (ch >= 91 && ch <= 107) {
            if (shift > 32) {
                throw new IOException("short integer too large for this system");
            }
            n += ch - 91 << shift;
            shift += 4;
            ch = DagBuilder.getNextChar(sr);
        }
        if (ch < 107 || ch >= 123) {
            throw new DotMParseError("invalid character in short integer encoding " + ch + " " + (char)ch);
        }
        return (n += ch - 107 << shift) * sign;
    }

    public static double parseDouble(InputStream sr) throws IOException {
        long tmpL = 0L;
        int i = 0;
        while (i < 16) {
            int ch = sr.read();
            if (ch <= 57) {
                ch -= 48;
            } else {
                ch -= 65;
                ch += 10;
            }
            tmpL = (tmpL << 4) + (long)ch;
            ++i;
        }
        return Double.longBitsToDouble(tmpL);
    }

    public static void doubleToHex(double d, StringBuffer out) {
        long theBits = Double.doubleToRawLongBits(d);
        int i = 15;
        while (i >= 0) {
            int b = (int)(theBits >> i * 4 & 0xFL);
            out.append(hexdigits[b]);
            --i;
        }
    }

    static void pBinLong(long l) {
    }

    static void FillInputTable() {
        int i = 1;
        while (i < MapleNumbers.dotMOutputTable.length) {
            MapleNumbers.dotMInputTable[MapleNumbers.dotMOutputTable[i]] = (byte)i;
            ++i;
        }
        MapleNumbers.dotMInputTable[26] = 104;
        MapleNumbers.dotMInputTable[51] = 105;
        MapleNumbers.dotMInputTable[53] = 106;
        MapleNumbers.dotMInputTable[54] = 107;
        MapleNumbers.dotMInputTable[55] = 108;
        MapleNumbers.dotMInputTable[50] = 109;
    }

    public static LayoutBox createNewLayoutBox(LayoutFormatter f, Dag dag) {
        DefaultLayoutBox parent = null;
        boolean firstSubexpression = true;
        PreprocessorSubstitutionTable subs = null;
        DefaultLayoutBox subexpressions = null;
        DagRenderContext context = f.getContext();
        KernelInterfaceProperties props = context != null ? context.getInterfaceProperties() : null;
        boolean allowedLabel = false;
        int labelWidth = 20;
        if (props != null) {
            int prettyprintSetting = 2;
            boolean labelling = true;
            prettyprintSetting = (Integer)props.getValue("prettyprint");
            labelling = (Boolean)props.getValue("labelling");
            boolean bl = allowedLabel = labelling && (prettyprintSetting == 2 || prettyprintSetting == 1);
            if (allowedLabel) {
                labelWidth = (Integer)props.getValue("labelwidth");
            }
            subs = props.getSubstitutionTable();
        }
        assumptionHandler.init(f);
        PostLayoutJobQueue queue = f.getPostLayoutJobQueue();
        if (allowedLabel) {
            queue.locateDuplicates(dag);
            queue.setLabelAllowed(allowedLabel);
            queue.setLabelWidth(labelWidth);
        }
        LayoutBox box = DagBuilder.createLayout(f, dag);
        box.setDag(dag);
        while (!queue.isEmpty()) {
            PostLayoutJob job = queue.removeFirstJob();
            if (job instanceof AbstractFormatter.SubexpressionLabelJob) {
                if (firstSubexpression && subs != null) {
                    subs.flush();
                    firstSubexpression = false;
                }
                if (subexpressions == null) {
                    subexpressions = new DefaultLayoutBox();
                }
                AbstractFormatter.SubexpressionLabelJob slj = (AbstractFormatter.SubexpressionLabelJob)job;
                subexpressions.addChild(slj.getLegendItem());
                SubexpressionLabelLayoutBox sebx = slj.getSubexpressionBox();
                if (subs == null) continue;
                subs.addCommand(sebx.getLabel(), sebx.getLPrint());
                continue;
            }
            if (!(job instanceof AbstractFormatter.AssumptionLabelJob)) continue;
            assumptionHandler.handleAssumptionJob((AbstractFormatter.AssumptionLabelJob)job);
        }
        if (subexpressions != null) {
            parent = new DefaultLayoutBox();
            parent.addChild(box);
            int i = 0;
            while (i < subexpressions.numChildren() - 1) {
                subexpressions.addLayoutAnchor(LayoutAnchor.createTopToBottomAnchor(i));
                ++i;
            }
            parent.addChild(subexpressions);
        }
        assumptionHandler.completeAssumptions();
        LayoutBox assumptions = assumptionHandler.getAssumptionsLayout();
        if (assumptions != null) {
            if (parent == null) {
                parent = new DefaultLayoutBox();
                parent.addChild(box);
            }
            parent.setSelectionData(assumptionSelectionData);
            parent.addChild(assumptions);
        }
        if (parent != null) {
            box = parent;
            int i = 0;
            while (i < box.numChildren() - 1) {
                box.addLayoutAnchor(new LayoutAnchor(i, LayoutVector.SOUTH, i + 1, LayoutVector.NORTH));
                ++i;
            }
        }
        if (subexpressions != null || assumptions != null) {
            box.setLineBreaker(LineBreakerFactory.newLineBreaker(15));
        }
        assumptionHandler.releaseResources();
        return box;
    }

    public static LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        Dag normalized = dag.getNormalized();
        PostLayoutJobQueue queue = f.getPostLayoutJobQueue();
        if (normalized == null) {
            normalized = dag;
        }
        int type = normalized.getType();
        LayoutBox b = factories[type].createLayout(f, normalized);
        b.setDag(dag);
        if (queue.getLabelAllowed()) {
            b = queue.subexpressionLabel(f, b, dag);
        }
        return b;
    }

    public static String lPrintRTable(Dag dag) {
        dag = DagUtil.unwrapExpSeq(dag);
        StringBuffer sb = new StringBuffer();
        Dag idDag = dag.getChild(1);
        String idValue = idDag.getChild(0).getData();
        sb.append("Matrix");
        sb.append("(%id = ");
        sb.append(idValue);
        sb.append(" )");
        return sb.toString();
    }

    public static synchronized String lPrint(Dag dag) {
        return DagBuilder.lPrint(dag, new WmiLPrintOptions());
    }

    public static synchronized String lPrint(Dag dag, WmiLPrintOptions options) {
        StringBuffer sb = new StringBuffer();
        if (dag != null) {
            int type = dag.getType();
            Dag normalized = null;
            inProc = false;
            if (type == 29 && dag.getLength() == 1) {
                normalized = dag.getChild(0).getNormalized();
                return DagBuilder.lPrint(normalized, options);
            }
            normalized = dag.getNormalized();
            if (normalized == null) {
                normalized = dag;
            }
            DagBuilder.linePrint(sb, normalized, options);
        }
        return sb.toString();
    }

    public static void linePrint(StringBuffer sb, Dag dag) {
        DagBuilder.linePrint(sb, dag, new WmiLPrintOptions());
    }

    public static void linePrint(StringBuffer sb, Dag dag, WmiLPrintOptions options) {
        if (dag == null) {
            return;
        }
        Dag normalized = dag.getNormalized();
        if (normalized == null) {
            normalized = dag;
        }
        factories[normalized.getType()].linePrint(sb, normalized, options);
    }

    public static String toMathML(Dag dag) {
        int type = dag.getType();
        StringBuffer sb = new StringBuffer();
        sb.append(factories[type].toMathML(dag));
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static void writeShortInteger(StringBuffer sb, int num) {
        block3: {
            d = 0;
            ch = '\u0000';
            if (num < 0) {
                sb.append('~');
                num = -num;
            }
            if (num >= 58) ** GOTO lbl19
            ch = (char)(num + 33);
            sb.append(ch);
            break block3;
lbl-1000:
            // 1 sources

            {
                d = num & 15;
                if ((num >>= 4) == 0) {
                    sb.append((char)(d + 107));
                    continue;
                }
                sb.append((char)(d + 91));
lbl19:
                // 3 sources

                ** while (num != 0)
            }
        }
    }

    public static void writeDigits(StringBuffer sb, String num, int len) {
        int index = len;
        while (index > 0) {
            if (index == 1) {
                int low = Integer.parseInt(num.substring(index - 1, index));
                index -= DagBuilder.writeOneOrTwoDigits(-1, low, sb);
                continue;
            }
            int temp = Integer.parseInt(num.substring(index - 2, index));
            int high = temp / 10;
            int low = temp % 10;
            index -= DagBuilder.writeOneOrTwoDigits(high, low, sb);
        }
    }

    public static void writeDigits1(StringBuffer sb, String num, int len) {
        int index = len;
        while (index > 0) {
            if (index == 1) {
                int low = Integer.parseInt(num.substring(index - 1, index));
                index -= DagBuilder.writeOneOrTwoDigits(-1, low, sb);
                continue;
            }
            int temp = Integer.parseInt(num.substring(index - 2, index));
            int high = temp / 10;
            int low = temp % 10;
            index -= DagBuilder.writeOneOrTwoDigits(high, low, sb);
        }
    }

    private static int writeOneOrTwoDigits(int high, int low, StringBuffer sb) {
        int pair;
        if (high > -1 && (pair = 10 * high + low) <= 79) {
            sb.append((char)(43 + pair));
            return 2;
        }
        sb.append((char)(33 + low));
        return 1;
    }

    public static int getCurrentMarkID() {
        return currentMark;
    }

    public static synchronized Dag normalize(Dag dag) {
        Dag result = null;
        int count = 0;
        Dag dag2 = result = dag.isNormalized() ? dag.getNormalized() : null;
        if (result == null) {
            count = dag.getLength();
            int type = dag.getType();
            if (type == 34) {
                ProcDagFactory.addToStacks(dag);
                count = 6;
            } else if (type == 39) {
                count = 6;
                ProcDagFactory.addToStacks(dag.getChild(0), dag.getChild(1), dag.getChild(7), dag.getChild(3));
            }
            Dag copy = null;
            Dag norm = null;
            Dag child = null;
            if (dag.getLength() > 0) {
                int i = 0;
                while (i < count) {
                    child = dag.getChild(i);
                    int childType = child.getType();
                    if (childType == 32 || childType == 31 || childType == 33) {
                        child = Dag.createDag(childType, child.getChildrenAsArray(), child.getData(), false);
                    }
                    if (child != null && (norm = DagBuilder.normalize(child)) != child) {
                        if (copy == null) {
                            copy = dag.copy();
                        }
                        copy.setChild(i, norm);
                    }
                    ++i;
                }
                if (copy != null) {
                    dag = copy;
                }
            }
            result = factories[dag.getType()].normalize(dag);
            if (dag.getType() == 34) {
                ProcDagFactory.removeStacks(dag);
            } else if (dag.getType() == 39) {
                ProcDagFactory.removeStacks();
            }
            if (result == null) {
                result = dag;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getModuleName(Dag attr) {
        String s = null;
        StringBuffer stringBuffer = moduleNameBuffer;
        synchronized (stringBuffer) {
            DagBuilder.createModuleName(attr, moduleNameBuffer);
            s = moduleNameBuffer.toString();
            moduleNameBuffer.setLength(0);
        }
        return s;
    }

    private static void createModuleName(Dag attr, StringBuffer name) {
        if (attr instanceof BranchDag) {
            int attrlen = attr.getLength();
            int i = 0;
            while (i < attrlen) {
                Dag lhs;
                Dag attrChild = attr.getChild(i);
                if (attrChild.getType() == 20 && (lhs = attrChild.getChild(0)) instanceof AttributedLeafDag && lhs.getData().equals("modulename")) {
                    Dag rhs = attrChild.getChild(1);
                    if (name.length() > 0) {
                        name.insert(0, ":-");
                    }
                    String data = null;
                    data = rhs instanceof AttributedLeafDag ? ((AttributedLeafDag)rhs).getDataOnly() : rhs.getData();
                    name.insert(0, data);
                    DagBuilder.createModuleName(rhs.getAttributes(), name);
                    break;
                }
                ++i;
            }
        }
    }

    private static class HandleAssumptionPostProcessor {
        LayoutBox assumptions;
        LinkedList assumpList = new LinkedList();
        LayoutFormatter f;

        public LayoutBox getAssumptionsLayout() {
            return this.assumptions;
        }

        public void init(LayoutFormatter formatter) {
            this.assumptions = null;
            this.assumpList.clear();
            this.f = formatter;
        }

        public void releaseResources() {
            this.assumptions = null;
            this.assumpList.clear();
            this.f = null;
        }

        protected void handleAssumptionJob(AbstractFormatter.AssumptionLabelJob job) {
            if (this.assumptions == null) {
                this.assumptions = new DefaultLayoutBox();
                NotationLayoutBox withBox = NotationLayoutBox.createCustomBox(this.f, "with ");
                NotationLayoutBox assumpBox = NotationLayoutBox.createCustomBox(this.f, "assumptions ");
                NotationLayoutBox onBox = NotationLayoutBox.createCustomBox(this.f, "on ");
                withBox.setLineBreaker(LineBreakerFactory.newLineBreaker(8));
                assumpBox.setLineBreaker(LineBreakerFactory.newLineBreaker(8));
                onBox.setLineBreaker(LineBreakerFactory.newLineBreaker(8));
                this.assumptions.addChild(withBox);
                this.assumptions.addChild(assumpBox);
                this.assumptions.addChild(onBox);
                this.assumptions.setSelectionData(assumptionStatementSelectionData);
            }
            this.assumpList.add(job.getVariable());
        }

        protected void completeAssumptions() {
            if (this.assumptions != null) {
                int i = 0;
                while (i < this.assumpList.size()) {
                    if (i != 0) {
                        if (i == this.assumpList.size() - 1) {
                            this.assumptions.addChild(NotationLayoutBox.createCustomBox(this.f, " and "));
                        } else {
                            this.assumptions.addChild(NotationLayoutBox.createCustomBox(this.f, ", "));
                        }
                    }
                    this.assumptions.addChild((LayoutBox)this.assumpList.get(i));
                    ++i;
                }
                i = 0;
                while (i < this.assumptions.numChildren() - 1) {
                    this.assumptions.addLayoutAnchor(LayoutAnchor.createLeftToRightAnchor(i));
                    ++i;
                }
            }
        }
    }
}

