/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.HfloatDagFactory;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.client.prettyprinter.template.RtableTemplate;
import java.util.ArrayList;

public class DagUtil {
    private static final int MODULECALL = 0;
    private static final int FIRSTARGDAG = 1;
    private static final String FLOAT = "Float";
    private static final String UNDEFINED = "undefined";
    private static final String INFINITY = "infinity";
    private static final String MINUS_INFINITY = "-infinity";
    private static final String RTABLE = "RTABLE";

    public static void getRTables(Dag dag, ArrayList rtableIds) {
        if (DagUtil.isBranchDag(dag)) {
            int length = dag.getLength();
            int i = 0;
            while (i < length) {
                Dag child = dag.getChild(i);
                long id = DagUtil.identifyRTableFunction(child);
                if (id > 0L) {
                    long correctedID = RtableTemplate.getCorretedRTableID(id);
                    if (id != correctedID) {
                        RtableTemplate.updateRTableID(child, correctedID);
                        id = correctedID;
                    }
                    rtableIds.add(new Long(id));
                }
                DagUtil.getRTables(child, rtableIds);
                ++i;
            }
        }
    }

    public static Dag unwrapExpSeq(Dag target) {
        Dag result = target;
        if (result != null && DagUtil.isExpSeq(result) && result.getLength() == 1) {
            result = result.getChild(0);
        }
        return result;
    }

    public static String encodeDotmForString(String in) {
        StringBuffer result = new StringBuffer();
        char[] inString = in.toCharArray();
        int i = 0;
        while (i < inString.length) {
            if (inString[i] == '\"' || inString[i] == '\\') {
                result.append('\\');
            }
            result.append(inString[i]);
            ++i;
        }
        return result.toString();
    }

    public static String decodeDotmForString(String in) {
        StringBuffer result = new StringBuffer();
        char[] inString = in.toCharArray();
        int len = inString.length;
        int i = 0;
        while (i < len) {
            if (inString[i] == '\\' && i + 1 < len && (inString[i + 1] == '\"' || inString[i + 1] == '\\')) {
                ++i;
            }
            result.append(inString[i]);
            ++i;
        }
        return result.toString();
    }

    public static Dag searchForAttribute(Dag toSearch, String key) {
        Dag attrs = null;
        Dag value = null;
        attrs = toSearch.getAttributes();
        if (attrs != null) {
            int len = attrs.getLength();
            int i = 0;
            while (i < len) {
                Dag LHS;
                Dag child = attrs.getChild(i);
                if (child != null && child.getType() == 20 && (LHS = child.getChild(0)) != null && LHS.getData() != null && LHS.getData().equals(key)) {
                    value = child.getChild(1);
                    break;
                }
                ++i;
            }
        }
        return value;
    }

    public static void releaseRTables(Dag dag) {
        if (DagUtil.isBranchDag(dag)) {
            int length = dag.getLength();
            int i = 0;
            while (i < length) {
                Dag child = dag.getChild(i);
                if (child != null) {
                    long id = DagUtil.identifyRTableFunction(child);
                    if (id > 0L) {
                        RtableTemplate.release(id);
                    }
                    DagUtil.releaseRTables(child);
                }
                ++i;
            }
        }
    }

    public static boolean isBranchDag(Dag dag) {
        return dag.getLength() > 0;
    }

    public static long identifyRTableFunction(Dag dag) {
        long rtableID = -1L;
        if (dag.getType() == 18) {
            Dag child;
            Dag paramSeq;
            String value;
            int length = dag.getLength();
            boolean isRtable = false;
            if (length > 0 && (value = dag.getChild(0).getData()) != null && value.equals(RTABLE)) {
                isRtable = true;
            }
            if (isRtable && (paramSeq = dag.getChild(1)).getLength() > 0 && (child = paramSeq.getChild(0)).getType() == 2) {
                String id = child.getData();
                try {
                    rtableID = Long.parseLong(id);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return rtableID;
    }

    public static boolean isOneElementList(Dag dag) {
        return dag.getType() == 30 && dag.getLength() == 1;
    }

    public static boolean isGarbage(Dag dag) {
        return dag.getType() == 57;
    }

    public static boolean isZero(Dag dag) {
        return dag != null && dag.equals(DagConstants.ZERO);
    }

    public static boolean isPositive(Dag dag) {
        return DagUtil.isNumeric(dag) && !DagUtil.isZero(dag) && !DagUtil.isNegative(dag);
    }

    public static boolean isOne(Dag dag) {
        return dag != null && dag.equals(DagConstants.ONE);
    }

    public static boolean isMinusOne(Dag dag) {
        return dag != null && dag.equals(DagConstants.MINUS_ONE);
    }

    public static boolean isTwo(Dag dag) {
        return dag != null && dag.equals(DagConstants.TWO);
    }

    public static boolean isOneHalf(Dag dag) {
        return dag != null && dag.equals(DagConstants.ONE_HALF);
    }

    public static boolean isNumeric(Dag dag) {
        return dag != null && dag.getType() <= 6;
    }

    public static boolean isFunction(Dag dag) {
        return dag != null && dag.getType() == 18;
    }

    public static boolean isRange(Dag dag) {
        return dag != null && dag.getType() == 35;
    }

    public static boolean isRational(Dag dag) {
        return dag != null && dag.getType() == 3;
    }

    public static boolean isComplex(Dag dag) {
        return dag != null && dag.getType() == 6;
    }

    public static boolean isExpSeq(Dag dag) {
        return dag != null && dag.getType() == 29;
    }

    public static boolean isString(Dag dag) {
        return dag != null && dag.getType() == 7;
    }

    public static boolean isText(Dag dag) {
        return dag != null && (DagUtil.isString(dag) || DagUtil.isName(dag));
    }

    public static boolean isSum(Dag dag) {
        return dag != null && dag.getType() == 16;
    }

    public static boolean isProd(Dag dag) {
        return dag != null && dag.getType() == 14;
    }

    public static boolean isFunctionNamed(Dag dag, String s) {
        String name;
        boolean match = false;
        if (DagUtil.isFunction(dag) && dag.getLength() > 0 && (name = dag.getChild(0).getData()) != null) {
            match = name.equals(s);
        }
        return match;
    }

    public static boolean isNegative(Dag dag) {
        boolean negative = false;
        if (DagUtil.isNumeric(dag)) {
            switch (dag.getType()) {
                case 1: {
                    negative = true;
                    break;
                }
                case 3: 
                case 4: {
                    negative = DagUtil.isNegative(dag.getChild(0));
                    break;
                }
                case 6: {
                    negative = DagUtil.isNegative(dag.getChild(0));
                    break;
                }
                case 5: {
                    negative = HfloatDagFactory.getDoubleValue(dag) < 0.0;
                }
            }
        } else if (dag.getType() == 16 && dag.getLength() == 2) {
            negative = DagUtil.isNegative(dag.getChild(1));
        }
        return negative;
    }

    public static boolean isNull(Dag dag) {
        return dag != null && dag.equals(DagConstants.EMPTY);
    }

    public static boolean isTrue(Dag dag) {
        return dag != null && dag.getType() == 8 && dag.getData().equals("true");
    }

    public static boolean isName(Dag dag) {
        return dag != null && dag.getType() == 8;
    }

    public static boolean isNameNamed(Dag dag, String s) {
        String name;
        boolean match = false;
        if (DagUtil.isName(dag) && (name = dag.getData()) != null) {
            match = name.equals(s);
        }
        return match;
    }

    public static boolean isAssignDag(Dag dag) {
        return dag != null && dag.getType() == 41;
    }

    public static boolean isRTableDag(Dag dag) {
        int length;
        boolean result = false;
        if (DagUtil.isFunction(dag) && (length = dag.getLength()) > 1) {
            int nargs;
            String value;
            Dag child = dag.getChild(0);
            String string = value = child != null ? child.getData() : null;
            if (value != null && value.equals(RTABLE) && (nargs = (child = dag.getChild(1)).getLength()) > 0) {
                Dag arg = child.getChild(0);
                result = arg != null && arg.getType() == 2;
            }
        }
        return result;
    }

    public static Dag negate(Dag dag) {
        Dag neg = null;
        if (DagUtil.isNumeric(dag)) {
            switch (dag.getType()) {
                case 2: {
                    neg = Dag.createDag(1, null, dag.getData(), false);
                    break;
                }
                case 1: {
                    neg = Dag.createDag(2, null, dag.getData(), false);
                    break;
                }
                case 3: 
                case 4: {
                    Dag[] children = new Dag[]{DagUtil.negate(dag.getChild(0)), dag.getChild(1)};
                    neg = Dag.createDag(dag.getType(), children, null, false);
                    break;
                }
                case 5: {
                    double value = -HfloatDagFactory.getDoubleValue(dag);
                    long longBits = Double.doubleToLongBits(value);
                    neg = Dag.createDag(5, null, Long.toString(longBits), false);
                    break;
                }
                case 6: {
                    int length = dag.getLength();
                    Dag[] children = new Dag[length];
                    int i = 0;
                    while (i < length) {
                        children[i] = DagUtil.negate(dag.getChild(i));
                        ++i;
                    }
                    neg = Dag.createDag(dag.getType(), children, null, false);
                }
            }
        } else if (dag.getType() == 16 && dag.getLength() == 2) {
            Dag[] children = new Dag[]{dag.getChild(0), DagUtil.negate(dag.getChild(1))};
            neg = Dag.createDag(16, children, null, false);
        }
        return neg;
    }

    public static int parseInt(Dag dag) {
        return (int)DagUtil.parseLong(dag);
    }

    public static Dag createIntDag(int theInt) {
        return DagUtil.createIntDag((long)theInt);
    }

    public static Dag createIntDag(long theInt) {
        int type = 2;
        if (theInt < 0L) {
            type = 1;
            theInt = -theInt;
        }
        return Dag.createDag(type, null, Long.toString(theInt), false);
    }

    public static long parseLong(Dag dag) {
        long longVal = 0L;
        longVal = DagUtil.isPosInt(dag) ? Long.parseLong(dag.getData()) : (DagUtil.isNegInt(dag) ? 0L - Long.parseLong(dag.getData()) : 0L);
        return longVal;
    }

    public static float parseFloat(Dag dag) {
        return (float)DagUtil.parseDouble(dag);
    }

    public static Dag createFloatDag(float f) {
        if (Float.isNaN(f)) {
            return DagConstants.NAME_UNDEFINED;
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? DagConstants.MINUS_INFINITY : DagConstants.INFINITY;
        }
        return DagUtil.createDoubleDag(f);
    }

    public static Dag createDoubleDag(double d) {
        Dag dbl = null;
        if (Double.isNaN(d)) {
            dbl = DagConstants.NAME_UNDEFINED;
        } else if (Double.isInfinite(d)) {
            dbl = d < 0.0 ? DagConstants.MINUS_INFINITY : DagConstants.INFINITY;
        } else {
            int ind;
            boolean isNeg = d < 0.0;
            int expVal = 0;
            String str = String.valueOf(d);
            if (str.charAt(0) == '-') {
                str = str.substring(1, str.length());
                isNeg = true;
            }
            if ((ind = str.indexOf(69)) > -1) {
                expVal = Integer.parseInt(str.substring(ind + 1));
                str = str.substring(0, ind);
            }
            if ((ind = str.indexOf(46)) > -1) {
                expVal -= str.length() - (ind + 1);
                str = String.valueOf(str.substring(0, ind)) + str.substring(ind + 1, str.length());
            }
            ind = -1;
            while (ind < str.length() - 2 && str.charAt(ind + 1) == '0') {
                ++ind;
            }
            if (ind > -1) {
                str = str.substring(ind + 1);
            }
            Dag[] kids = new Dag[]{Dag.createDag(isNeg ? 1 : 2, null, str, false), Dag.createDag(expVal < 0 ? 1 : 2, null, String.valueOf(expVal < 0 ? -expVal : expVal), false)};
            dbl = Dag.createDag(4, kids, null, false);
        }
        return dbl;
    }

    public static double parseDouble(Dag dag) {
        boolean parseSuccess;
        double d;
        block47: {
            if (dag == null) {
                return Double.NaN;
            }
            d = 0.0;
            int type = dag.getType();
            parseSuccess = true;
            if (type <= 5) {
                try {
                    if (type == 3) {
                        String num = DagBuilder.lPrint(dag.getChild(0));
                        String den = DagBuilder.lPrint(dag.getChild(1));
                        d = Double.parseDouble(num) / Double.parseDouble(den);
                        break block47;
                    }
                    if (type == 5) {
                        d = HfloatDagFactory.getDoubleValue(dag);
                        break block47;
                    }
                    if (type == 4 && DagUtil.isName(dag.getChild(1))) {
                        Dag mantissa = dag.getChild(0);
                        Dag exp = dag.getChild(1);
                        String s = exp.getData();
                        if (UNDEFINED.equals(s)) {
                            d = Double.NaN;
                        } else if (INFINITY.equals(s)) {
                            d = mantissa.getType() == 1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                        } else {
                            parseSuccess = false;
                        }
                        break block47;
                    }
                    String s = DagBuilder.lPrint(dag);
                    d = Double.parseDouble(s);
                }
                catch (NumberFormatException e) {
                    parseSuccess = false;
                }
            } else if (DagUtil.isFunctionNamed(dag, FLOAT)) {
                Dag[] args = dag.getChild(1).getChildrenAsArray();
                if (args.length == 1) {
                    if (DagUtil.isNameNamed(args[0], UNDEFINED)) {
                        d = Double.NaN;
                    } else if (DagUtil.isNameNamed(args[0], INFINITY)) {
                        d = Double.POSITIVE_INFINITY;
                    } else if (DagUtil.isNameNamed(args[0], MINUS_INFINITY)) {
                        d = Double.NEGATIVE_INFINITY;
                    } else {
                        parseSuccess = false;
                    }
                } else {
                    Dag mantissa = args[1];
                    if (DagUtil.isNameNamed(mantissa, INFINITY)) {
                        d = args[0].getType() == 1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    } else if (DagUtil.isNameNamed(mantissa, UNDEFINED)) {
                        d = Double.NaN;
                    } else {
                        try {
                            d = Double.parseDouble(DagBuilder.lPrint(dag));
                        }
                        catch (NumberFormatException e) {
                            parseSuccess = false;
                        }
                    }
                }
            } else if (dag.getType() == 8) {
                String str = dag.getData();
                if (UNDEFINED.equals(str)) {
                    d = Double.NaN;
                } else if ("FAIL".equals(str) || INFINITY.equals(str)) {
                    d = Double.POSITIVE_INFINITY;
                } else if (MINUS_INFINITY.equals(str)) {
                    d = Double.NEGATIVE_INFINITY;
                } else {
                    parseSuccess = false;
                }
            } else if (DagUtil.isNameNamed(dag, "Pi")) {
                d = Math.PI;
            } else if (DagUtil.isNameNamed(dag, UNDEFINED) || DagUtil.isNameNamed(dag, "FAIL") || DagUtil.isFloat(dag) && DagUtil.isNameNamed(dag.getChild(1), UNDEFINED)) {
                d = Double.NaN;
            } else if (DagUtil.isPosInfinity(dag)) {
                d = Double.POSITIVE_INFINITY;
            } else if (DagUtil.isNegInfinity(dag)) {
                d = Double.NEGATIVE_INFINITY;
            } else {
                try {
                    d = Double.parseDouble(DagBuilder.lPrint(dag));
                }
                catch (NumberFormatException e) {
                    parseSuccess = false;
                }
            }
        }
        if (!parseSuccess) {
            d = Double.NaN;
        }
        return d;
    }

    public static boolean isFloatInfinity(Dag dag) {
        boolean match = false;
        if (dag != null && dag.getLength() > 0) {
            String name;
            Dag child = dag.getChild(1);
            String string = name = child != null ? child.getData() : null;
            if (name != null) {
                match = name.equals(INFINITY);
            }
        }
        return match;
    }

    public static boolean isInfinity(Dag dag) {
        return DagUtil.isPosInfinity(dag) || DagUtil.isNegInfinity(dag);
    }

    public static boolean isNegInfinity(Dag dag) {
        boolean match = false;
        if (DagUtil.isSum(dag) && DagUtil.isNameNamed(dag.getChild(0), INFINITY)) {
            Dag child = dag.getChild(1);
            if (DagUtil.isInt(child) && DagUtil.parseInt(child) == -1) {
                match = true;
            }
        } else {
            match = DagConstants.MINUS_INFINITY.equals(dag);
        }
        return match;
    }

    public static boolean isPosInfinity(Dag dag) {
        return DagUtil.isNameNamed(dag, INFINITY);
    }

    public static Dag createErrorDag(String s) {
        Dag[] kids = new Dag[]{DagUtil.createNameDag(s)};
        Dag[] args = new Dag[]{DagUtil.createExpSeqDag(kids)};
        return Dag.createDag(48, args, null, false);
    }

    public static Dag createExpSeqDag(Dag[] kids) {
        return Dag.createDag(29, kids, null, false);
    }

    public static boolean isError(Dag dag) {
        return dag != null && dag.getType() == 48;
    }

    public static Dag createStringDag(String s) {
        return Dag.createDag(7, null, s, false);
    }

    public static Dag createNameDag(String s) {
        return Dag.createDag(8, null, s, false);
    }

    public static Dag createEquationDag(Dag lhs, Dag rhs) {
        Dag[] children = new Dag[]{lhs, rhs};
        return Dag.createDag(20, children, null, false);
    }

    public static Dag createFunctionDag(String s) {
        return DagUtil.createFunctionDag(s, null);
    }

    public static Dag createFunctionDag(String s, Dag[] expSubDags) {
        Dag[] children = new Dag[]{DagUtil.createNameDag(s), Dag.createDag(29, expSubDags, null, false)};
        return Dag.createDag(18, children, null, false);
    }

    public static Dag createRangeDag(float a, float b) {
        return DagUtil.createRangeDag((double)a, (double)b);
    }

    public static Dag createRangeDag(double a, double b) {
        Dag[] children = new Dag[]{DagUtil.createDoubleDag(a), DagUtil.createDoubleDag(b)};
        return Dag.createDag(35, children, null, false);
    }

    public static boolean isPosInt(Dag dag) {
        return dag != null && dag.getType() == 2;
    }

    public static boolean isNegInt(Dag dag) {
        return dag != null && dag.getType() == 1;
    }

    public static boolean isInt(Dag dag) {
        return DagUtil.isPosInt(dag) || DagUtil.isNegInt(dag);
    }

    public static boolean isFloat(Dag dag) {
        return dag != null && dag.getType() == 4;
    }

    public static boolean isFloatZero(Dag dag) {
        return DagUtil.isFloat(dag) && DagUtil.isZero(dag.getChild(0));
    }

    public static boolean isList(Dag dag) {
        return dag != null && dag.getType() == 30;
    }

    public static boolean isEquation(Dag dag) {
        return dag != null && dag.getType() == 20;
    }

    public static boolean isNumber(Dag dag) {
        return dag != null && (DagUtil.isInt(dag) || DagUtil.isFloat(dag));
    }

    public static boolean isMember(Dag dag) {
        return dag != null && dag.getType() == 9;
    }

    public static boolean isprintSlash(Dag dag) {
        boolean result = false;
        if (DagUtil.isFunction(dag) && DagUtil.isMember(dag.getChild(0)) && DagBuilder.lPrint(dag.getChild(0)).equals("Typesetting:-mprintslash")) {
            result = true;
        }
        return result;
    }

    public static Dag getDisplayDataFromPrintslash(Dag dag) {
        Dag result = dag;
        if (DagUtil.isExpSeq(dag)) {
            dag = DagUtil.unwrapExpSeq(dag);
        }
        if (DagUtil.isprintSlash(dag)) {
            Dag args = dag.getChild(1);
            Dag display = args.getChild(0);
            result = display.getLength() > 1 ? Dag.createDag(29, display.getChildrenAsArray(), null, false) : (display.getLength() == 0 ? DagConstants.EMPTY : display.getChild(0));
        }
        return result;
    }

    public static Dag getSemanticDataFromPrintslash(Dag dag) {
        Dag result = dag;
        if (DagUtil.isExpSeq(dag)) {
            dag = DagUtil.unwrapExpSeq(dag);
        }
        if (DagUtil.isprintSlash(dag)) {
            Dag args = dag.getChild(1);
            Dag meaning = args.getChild(1);
            result = meaning.getLength() > 1 ? Dag.createDag(29, meaning.getChildrenAsArray(), null, false) : (meaning.getLength() > 0 ? meaning.getChild(0) : null);
        }
        return result;
    }

    public static Dag formatProcParams(Dag dag) {
        Dag result = null;
        if (dag != null && dag.getType() == 34) {
            boolean endOfParamMarkerFound;
            Dag child = dag.getChild(0);
            int normalParamCount = ProcDagFactory.countNormalParams(dag);
            int length = child.getLength();
            int endOfParamMarkerIndex = normalParamCount;
            boolean bl = endOfParamMarkerFound = normalParamCount > 0 && DagUtil.isNameNamed(child.getChild(normalParamCount - 1), " $");
            if (endOfParamMarkerFound) {
                --endOfParamMarkerIndex;
            }
            if (length > normalParamCount) {
                Dag[] children = child.getChildrenAsArray();
                Dag[] newParams = new Dag[normalParamCount + 1];
                System.arraycopy(children, 0, newParams, 0, endOfParamMarkerIndex);
                Dag[] specParams = new Dag[length - normalParamCount];
                System.arraycopy(children, normalParamCount, specParams, 0, length - normalParamCount);
                BranchDag set = new BranchDag(36, specParams);
                newParams[endOfParamMarkerIndex] = set;
                if (endOfParamMarkerFound) {
                    newParams[normalParamCount] = child.getChild(endOfParamMarkerIndex);
                }
                result = new BranchDag(29, newParams);
            } else {
                result = child;
            }
        }
        return result;
    }

    public static Dag createAssignDag(Dag[] kids) {
        return Dag.createDag(41, kids, null, false);
    }

    public static Dag createMemberDag(String module, String function) {
        Dag[] args = new Dag[]{DagUtil.createNameDag(module), DagUtil.createNameDag(function)};
        return Dag.createDag(9, args, null, false);
    }

    public static Dag createEquationDag(Dag[] kids) {
        return Dag.createDag(20, kids, null, false);
    }

    public static Dag createListDag(Dag[] kids) {
        return Dag.createDag(30, kids, null, false);
    }

    public static Dag createTableRefDag(Dag dag, Dag dag2) {
        return Dag.createDag(10, new Dag[]{dag, dag2}, null, false);
    }

    public static long countNodes(Dag normalized, long count) {
        if (normalized instanceof BranchDag) {
            count += (long)normalized.getLength();
            int i = 0;
            while (i < normalized.getLength()) {
                count += DagUtil.countNodes(normalized.getChild(i), 0L);
                ++i;
            }
        }
        return count;
    }

    public static boolean isMVerbatim(Dag dag) {
        boolean result = false;
        if (DagUtil.isFunction(dag) && DagUtil.isName(dag.getChild(0)) && "mverbatim".equals(dag.getChild(0).getDataOnly())) {
            result = true;
        }
        return result;
    }

    public static boolean isStatSeq(Dag dag) {
        return dag.getType() == 46;
    }

    public static Dag getRTableFromMParsedDag(Dag dag) {
        Dag args;
        Dag result = null;
        Dag tmp = DagUtil.unwrapExpSeq(dag);
        if (tmp.getLength() > 1 && (args = tmp.getChild(1)).getLength() > 1 && DagUtil.isRTableDag(tmp = args.getChild(1))) {
            result = tmp;
        }
        return result;
    }

    public static boolean containsRtable(Dag dag) {
        boolean result = false;
        if (dag instanceof BranchDag) {
            int i = 0;
            while (i < dag.getLength()) {
                if (result |= DagUtil.isRTableDag(dag.getChild(i))) break;
                ++i;
            }
        }
        return result;
    }

    public static String getFunctionName(Dag dag) {
        String name = null;
        if (DagUtil.isFunction(dag) && dag.getLength() > 0) {
            name = dag.getChild(0).getData();
        }
        return name;
    }
}

