/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.FloatTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;

public class FloatDagFactory
extends AbstractDagFactory {
    private static final SelectionData noHelpSD = new StandardSelectionData(2);
    public static final int SCIENTIFIC_NOTATION_THRESHOLD = 6;
    public static final String TEN_STRING = "10";

    static {
        noHelpSD.setContextHelpAvailable(false);
    }

    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        return this.readDotm(is, 4, 3);
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        this.writeDotm(sb, dag, 4, false);
    }

    @Override
    public int getPrecedence() {
        return 2;
    }

    @Override
    public int getPrecedence(Dag dag) {
        return DagUtil.isNegative(dag) ? 6 : 2;
    }

    @Override
    public void updateContext(DagRenderContext context) {
        FloatTemplate.updateContext(context);
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        dag.getLength();
        Dag mantissa = dag.getChild(0);
        Dag exponent = dag.getChild(1);
        if (exponent.getType() == 8) {
            result.append("Float(");
            if (DagUtil.isMinusOne(mantissa)) {
                result.append("-");
            }
            DagBuilder.linePrint(result, exponent, options);
            result.append(")");
        } else {
            result.append(this.processFloat(dag, options));
        }
    }

    public StringBuffer processFloat(Dag dag, WmiLPrintOptions options) {
        dag.getLength();
        StringBuffer result = new StringBuffer();
        String mantissa = dag.getChild(0).getData();
        String exponent = DagBuilder.lPrint(dag.getChild(1), options);
        if (mantissa != null && exponent != null) {
            try {
                long exponentValue;
                if (dag.getChild(0).getType() == 1) {
                    result.append("-");
                }
                if ((exponentValue = (long)FloatTemplate.calculateExponent(dag.getChild(1))) > 0L || exponentValue < (long)(-1 * mantissa.length())) {
                    result.append("0.");
                    result.append(mantissa);
                    result.append("e");
                    result.append(exponentValue += (long)mantissa.length());
                } else {
                    assert (exponentValue < Integer.MAX_VALUE && exponentValue > Integer.MIN_VALUE);
                    int decimalPlace = mantissa.length() + (int)exponentValue;
                    if (decimalPlace < 0) {
                        byte[] fill = new byte[2 - decimalPlace];
                        Arrays.fill(fill, (byte)48);
                        fill[1] = 46;
                        result.append(new String(fill));
                        result.append(mantissa);
                    } else if (decimalPlace > mantissa.length()) {
                        byte[] fill = new byte[decimalPlace - mantissa.length()];
                        Arrays.fill(fill, (byte)48);
                        result.append(mantissa);
                        result.append(new String(fill));
                    } else {
                        result.append(mantissa.substring(0, decimalPlace));
                        result.append('.');
                        result.append(mantissa.substring(decimalPlace));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        return FloatTemplate.apply(f, dag.getChild(0), dag.getChild(1));
    }
}

