/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractCommandDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.ProcTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class ForDagFactory
extends AbstractCommandDagFactory {
    public static final String[] FOR_KEYWORDS = new String[]{"for ", "from ", "by ", "to ", "while ", "in "};

    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        return this.readDotm(is, 42, DagBuilder.parseShortInteger(is));
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        this.writeDotm(sb, dag, 42, true);
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        int length = dag.getLength();
        if (length == 6) {
            result.append(this.buildFirstLine(dag, options));
            DagBuilder.linePrint(result, dag.getChild(5), options);
            result.append(" end do");
        } else {
            result.append(this.buildShortFirstLine(dag, options));
            DagBuilder.linePrint(result, dag.getChild(3), options);
            result.append(" end do");
        }
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        InlineLayoutBox b = new InlineLayoutBox(4);
        LayoutBox temp = null;
        int targetLocation = 0;
        int length = dag.getLength();
        if (length == 6) {
            b.addChild(this.layoutFirstLine(f, dag));
            targetLocation = 5;
        } else {
            b.addChild(this.layoutShortFirstLine(f, dag));
            targetLocation = 3;
        }
        temp = ProcTemplate.layoutStatement(f, dag.getChild(targetLocation));
        boolean cfr_ignored_0 = temp.getChild(0) instanceof ProcTemplate.ProcDelimiter;
        b.addChild(temp);
        ProcTemplate.addNeededDelimiter(f, b);
        b.addChild(NotationLayoutBox.createNotationBox(f, longForm ? 70 : 50));
        b.addChild(ProcTemplate.createSemiColon(f));
        b.addChild(new ProcTemplate.ProcDelimiter(f));
        b.setLineBreaker(LineBreakerFactory.newLineBreaker(16));
        return b;
    }

    private LayoutBox layoutFirstLine(LayoutFormatter f, Dag dag) {
        InlineLayoutBox box = new InlineLayoutBox(2);
        Dag child = dag.getChild(0);
        if (!DagUtil.isNull(child)) {
            this.appendLayout(f, box, 43, child);
        }
        if (!DagUtil.isOne(child = dag.getChild(1))) {
            this.appendLayout(f, box, 45, child);
        }
        if (!DagUtil.isOne(child = dag.getChild(2))) {
            this.appendLayout(f, box, 46, child);
        }
        if (!DagUtil.isNull(child = dag.getChild(3))) {
            this.appendLayout(f, box, 47, child);
        }
        if (!DagUtil.isName(child = dag.getChild(4)) || !DagUtil.isTrue(child)) {
            this.appendLayout(f, box, 48, child);
        }
        this.appendLayout(f, box, 49, null);
        return box;
    }

    private LayoutBox layoutShortFirstLine(LayoutFormatter f, Dag dag) {
        InlineLayoutBox box = new InlineLayoutBox();
        Dag child = dag.getChild(0);
        if (!DagUtil.isNull(child)) {
            this.appendLayout(f, box, 43, child);
        }
        if (!DagUtil.isOne(child = dag.getChild(1))) {
            this.appendLayout(f, box, 44, child);
        }
        if (!DagUtil.isName(child = dag.getChild(2)) || !DagUtil.isTrue(child)) {
            this.appendLayout(f, box, 48, child);
        }
        this.appendLayout(f, box, 49, null);
        return box;
    }

    private void appendLayout(LayoutFormatter f, LayoutBox box, int notation, Dag dag) {
        box.addChild(NotationLayoutBox.createNotationBox(f, notation));
        box.addChild(NotationLayoutBox.createCustomBox(f, " "));
        if (dag != null) {
            box.addChild(DagBuilder.createLayout(f, dag));
            box.addChild(NotationLayoutBox.createCustomBox(f, " "));
        }
    }

    private String buildFirstLine(Dag dag, WmiLPrintOptions options) {
        StringBuffer result = new StringBuffer();
        Dag child = dag.getChild(0);
        if (!DagUtil.isNull(child)) {
            result.append(FOR_KEYWORDS[0]);
            DagBuilder.linePrint(result, child, options);
            result.append(" ");
        }
        if (!DagUtil.isOne(child = dag.getChild(1))) {
            result.append(FOR_KEYWORDS[1]);
            DagBuilder.linePrint(result, child, options);
            result.append(" ");
        }
        if (!DagUtil.isOne(child = dag.getChild(2))) {
            result.append(FOR_KEYWORDS[2]);
            DagBuilder.linePrint(result, child, options);
            result.append(" ");
        }
        if (!DagUtil.isNull(child = dag.getChild(3))) {
            result.append(FOR_KEYWORDS[3]);
            DagBuilder.linePrint(result, child, options);
            result.append(" ");
        }
        if (!DagUtil.isName(child = dag.getChild(4)) || !DagUtil.isTrue(child)) {
            result.append(FOR_KEYWORDS[4]);
            DagBuilder.linePrint(result, child, options);
            result.append(" ");
        }
        result.append("do ");
        return result.toString();
    }

    private String buildShortFirstLine(Dag dag, WmiLPrintOptions options) {
        StringBuffer result = new StringBuffer();
        Dag child = dag.getChild(0);
        if (!DagUtil.isNull(child)) {
            result.append(FOR_KEYWORDS[0]);
            DagBuilder.linePrint(result, child, options);
            result.append(" ");
        }
        if (!DagUtil.isOne(child = dag.getChild(1))) {
            result.append(FOR_KEYWORDS[5]);
            DagBuilder.linePrint(result, child, options);
            result.append(" ");
        }
        if (!DagUtil.isName(child = dag.getChild(2)) || !DagUtil.isTrue(child)) {
            result.append(FOR_KEYWORDS[4]);
            DagBuilder.linePrint(result, child, options);
            result.append(" ");
        }
        result.append("do ");
        return result.toString();
    }
}

