/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.ExpseqDagFactory;
import com.maplesoft.client.dag.NameDagFactory;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.ProcLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.AbsTemplate;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.CompositionTemplate;
import com.maplesoft.client.prettyprinter.template.ConjugateTemplate;
import com.maplesoft.client.prettyprinter.template.CurlTemplate;
import com.maplesoft.client.prettyprinter.template.DiffTemplate;
import com.maplesoft.client.prettyprinter.template.DivergenceTemplate;
import com.maplesoft.client.prettyprinter.template.EvalTemplate;
import com.maplesoft.client.prettyprinter.template.ExpTemplate;
import com.maplesoft.client.prettyprinter.template.FactorialTemplate;
import com.maplesoft.client.prettyprinter.template.FloatTemplate;
import com.maplesoft.client.prettyprinter.template.GradientTemplate;
import com.maplesoft.client.prettyprinter.template.InfixNotationTemplate;
import com.maplesoft.client.prettyprinter.template.IntegralTemplate;
import com.maplesoft.client.prettyprinter.template.LimitTemplate;
import com.maplesoft.client.prettyprinter.template.LowerCaseTemplate;
import com.maplesoft.client.prettyprinter.template.MatrixTemplate;
import com.maplesoft.client.prettyprinter.template.ModpTemplate;
import com.maplesoft.client.prettyprinter.template.NeutralOpInfixTemplate;
import com.maplesoft.client.prettyprinter.template.PiecewiseTemplate;
import com.maplesoft.client.prettyprinter.template.ProductTemplate;
import com.maplesoft.client.prettyprinter.template.RootTemplate;
import com.maplesoft.client.prettyprinter.template.RtableTemplate;
import com.maplesoft.client.prettyprinter.template.SeriesTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;
import com.maplesoft.client.prettyprinter.template.SumTemplate;
import com.maplesoft.client.prettyprinter.template.TypesettingTemplate;
import com.maplesoft.client.prettyprinter.template.UnitTemplate;
import com.maplesoft.client.prettyprinter.template.VectorShorthandTemplate;
import com.maplesoft.client.prettyprinter.template.VectorTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class FunctionDagFactory
extends AbstractDagFactory {
    private static HashMap inlineableFunctions = new HashMap();
    private static HashMap translatedInlineFunctions;
    private static HashMap precTable;
    private static HashMap specialFunctionMap;
    static HashMap precedenceMap;
    public static ArrayList KEYWORDS;
    static final SelectionData FUNCTION_SELECTION_DATA;
    static HashSet updatedTemplate;

    static {
        inlineableFunctions.put("+", new Integer(6));
        inlineableFunctions.put("*", new Integer(4));
        inlineableFunctions.put("^", new Integer(3));
        inlineableFunctions.put("/", new Integer(4));
        inlineableFunctions.put("@@", new Integer(2));
        inlineableFunctions.put(">", new Integer(12));
        inlineableFunctions.put(">=", new Integer(12));
        inlineableFunctions.put("<", new Integer(12));
        inlineableFunctions.put("<=", new Integer(12));
        translatedInlineFunctions = new HashMap();
        translatedInlineFunctions.put(">", " > ");
        translatedInlineFunctions.put(">=", " >= ");
        translatedInlineFunctions.put("<", " < ");
        translatedInlineFunctions.put("<=", " <= ");
        precTable = new HashMap();
        precTable.put("exp", new Integer(3));
        precTable.put("limit", new Integer(4));
        precTable.put("Limit", new Integer(4));
        precTable.put("sum", new Integer(6));
        precTable.put("Sum", new Integer(6));
        precTable.put("product", new Integer(4));
        precTable.put("Product", new Integer(4));
        precTable.put("&*", new Integer(5));
        specialFunctionMap = null;
        precedenceMap = new HashMap();
        KEYWORDS = new ArrayList(50);
        FUNCTION_SELECTION_DATA = new StandardSelectionData(2);
        updatedTemplate = new HashSet();
        precedenceMap.put("PIECEWISE", new Integer(9));
        precedenceMap.put("in", new Integer(12));
        precedenceMap.put("intersect", new Integer(4));
        precedenceMap.put("minus", new Integer(6));
        precedenceMap.put("mod", new Integer(7));
        precedenceMap.put("subset", new Integer(8));
        precedenceMap.put("union", new Integer(6));
        precedenceMap.put("eval", new Integer(6));
        precedenceMap.put("Eval", new Integer(6));
        precedenceMap.put("int", new Integer(3));
        precedenceMap.put("Int", new Integer(3));
        precedenceMap.put("limit", new Integer(6));
        precedenceMap.put("Limit", new Integer(6));
        precedenceMap.put("product", new Integer(6));
        precedenceMap.put("Product", new Integer(6));
        precedenceMap.put("sum", new Integer(6));
        precedenceMap.put("Sum", new Integer(6));
        precedenceMap.put("diff", new Integer(6));
        precedenceMap.put("Diff", new Integer(6));
        precedenceMap.put("Gradient", new Integer(6));
        precedenceMap.put("Curl", new Integer(6));
        precedenceMap.put("Divergence", new Integer(6));
        precedenceMap.put(".", new Integer(4));
        precedenceMap.put("exp", new Integer(3));
        precedenceMap.put("_SERIES", new Integer(6));
        precedenceMap.put("@", new Integer(4));
        precedenceMap.put("$", new Integer(13));
        precedenceMap.put("&plusmn;", new Integer(6));
        String[] keywordArray = new String[]{"$", "@", "@@", "and", "assuming", "break", "by", "catch", "desription", "do", "done", "elif", "else", "end", "error", "export", "fi", "finally", "for", "from", "global", "if", "implies", "in", "intersect", "local", "minus", "mod", "module", "next", "not", "od", "option", "options", "or", "proc", "quit", "read", "return", "save", "stop", "subset", "then", "to", "try", "union", "use", "while", "xor"};
        int i = 0;
        while (i < keywordArray.length) {
            KEYWORDS.add(keywordArray[i]);
            ++i;
        }
        String[] updatedTemplateNames = new String[]{"Unit", "sum", "Sum", "product", "Product", "_SERIES", "VECTOR", "vector", "MATRIX", "Matrix", "matrix", "RTABLE", "sqrt", "PIECEWISE", "modp1", "modp2", "Limit", "limit", "int", "Int", "$", "@", ".", "in", "intersect", "mod", "minus", "subset", "union", "Gradient", "Float", "factorial", "exp", "eval", "Eval", "Divergence", "Curl", "diff", "Diff", "conjugate", "@@", "abs", "<|>", "<,>", "`<|>`", "`<,>`", "Typesetting:-mfrac", "Typesetting:-mi", "Typesetting:-mmultiscripts", "Typesetting:-mscripts", "Typesetting:-mn", "Typesetting:-mo", "Typesetting:-mover", "Typesetting:-mambiguous", "Typesetting:-maction", "Typesetting:-mroot", "Typesetting:-mrow", "Typesetting:-mspace", "Typesetting:-msqrt", "Typesetting:-ms", "Typesetting:-mstyle", "Typesetting:-msub", "Typesetting:-msubsup", "Typesetting:-msup", "Typesetting:-mtext", "Typesetting:-merror", "Typesetting:-munder", "Typesetting:-mphantom", "Typesetting:-munderover", "Typesetting:-mprescripts", "Typesetting:-none", "Typesetting:-mfenced", "Typesetting:-mtable", "Typesetting:-mtr", "Typesetting:-mtd", "Typesetting:-mprintslash", "Typesetting:-mparsed", "Typesetting:-mverbatim"};
        int j = 0;
        while (j < updatedTemplateNames.length) {
            updatedTemplate.add(updatedTemplateNames[j]);
            ++j;
        }
    }

    private static void fillSpecialFunctionMap() {
        specialFunctionMap = new HashMap();
        specialFunctionMap.put("$", new InfixNotationTemplate(" $ ", 114, 2, 2, 2, 2.0, 0.0));
        specialFunctionMap.put("@", new InfixNotationTemplate("@", 112, 2, 2, Integer.MAX_VALUE, 3.0, 2.0));
        specialFunctionMap.put("@@", new CompositionTemplate());
        specialFunctionMap.put(".", new InfixNotationTemplate(" . ", 120, 1, 2, Integer.MAX_VALUE, 1.0, 1.0));
        specialFunctionMap.put("<,>", new VectorShorthandTemplate(14));
        specialFunctionMap.put("<|>", new VectorShorthandTemplate(15));
        specialFunctionMap.put("`<,>`", new VectorShorthandTemplate(14));
        specialFunctionMap.put("`<|>`", new VectorShorthandTemplate(15));
        specialFunctionMap.put("abs", new AbsTemplate());
        specialFunctionMap.put("conjugate", new ConjugateTemplate());
        specialFunctionMap.put("diff", new DiffTemplate());
        specialFunctionMap.put("Diff", new DiffTemplate());
        specialFunctionMap.put("eval", new EvalTemplate());
        specialFunctionMap.put("Eval", new EvalTemplate());
        specialFunctionMap.put("exp", new ExpTemplate());
        specialFunctionMap.put("Float", new FloatTemplate());
        specialFunctionMap.put("factorial", new FactorialTemplate());
        specialFunctionMap.put("in", new InfixNotationTemplate(" in ", 81, 6, 2, 2, 2.0, 0.0, true));
        specialFunctionMap.put("int", new IntegralTemplate());
        specialFunctionMap.put("Int", new IntegralTemplate());
        specialFunctionMap.put("intersect", new InfixNotationTemplate(" intersect ", 78, 2, 2, 2, 2.0, 0.0));
        specialFunctionMap.put("limit", new LimitTemplate());
        specialFunctionMap.put("TABLE", new LowerCaseTemplate());
        specialFunctionMap.put("Limit", new LimitTemplate());
        specialFunctionMap.put("matrix", new MatrixTemplate());
        specialFunctionMap.put("Matrix", new MatrixTemplate());
        specialFunctionMap.put("MATRIX", new MatrixTemplate());
        specialFunctionMap.put("mod", new InfixNotationTemplate(" mod ", 115, 2, 2, 2));
        specialFunctionMap.put("PIECEWISE", new PiecewiseTemplate());
        specialFunctionMap.put("product", new ProductTemplate());
        specialFunctionMap.put("minus", new InfixNotationTemplate(" minus ", 109, 2, 2, Integer.MAX_VALUE, 3.0, 2.0));
        specialFunctionMap.put("product", new ProductTemplate());
        specialFunctionMap.put("Product", new ProductTemplate());
        specialFunctionMap.put("RTABLE", new RtableTemplate());
        specialFunctionMap.put("subset", new InfixNotationTemplate(" subset ", 79, 2, 2, 2));
        specialFunctionMap.put("sqrt", new RootTemplate());
        specialFunctionMap.put("sum", new SumTemplate());
        specialFunctionMap.put("Sum", new SumTemplate());
        specialFunctionMap.put("union", new InfixNotationTemplate(" union ", 77, 2, 2, 2, 2.0, 0.0));
        specialFunctionMap.put("Unit", new UnitTemplate());
        specialFunctionMap.put("VECTOR", new VectorTemplate());
        specialFunctionMap.put("vector", new VectorTemplate());
        specialFunctionMap.put("Gradient", new GradientTemplate());
        specialFunctionMap.put("Curl", new CurlTemplate());
        specialFunctionMap.put("Divergence", new DivergenceTemplate());
        specialFunctionMap.put("_SERIES", new SeriesTemplate());
        specialFunctionMap.put("modp1", new ModpTemplate());
        specialFunctionMap.put("modp2", new ModpTemplate());
        TypesettingTemplate tt = new TypesettingTemplate();
        specialFunctionMap.put("Typesetting:-mfrac", tt);
        specialFunctionMap.put("Typesetting:-mi", tt);
        specialFunctionMap.put("Typesetting:-mmultiscripts", tt);
        specialFunctionMap.put("Typesetting:-mscripts", tt);
        specialFunctionMap.put("Typesetting:-mn", tt);
        specialFunctionMap.put("Typesetting:-mo", tt);
        specialFunctionMap.put("Typesetting:-mover", tt);
        specialFunctionMap.put("Typesetting:-mambiguous", tt);
        specialFunctionMap.put("Typesetting:-maction", tt);
        specialFunctionMap.put("Typesetting:-mroot", tt);
        specialFunctionMap.put("Typesetting:-mrow", tt);
        specialFunctionMap.put("Typesetting:-mspace", tt);
        specialFunctionMap.put("Typesetting:-msqrt", tt);
        specialFunctionMap.put("Typesetting:-ms", tt);
        specialFunctionMap.put("Typesetting:-mstyle", tt);
        specialFunctionMap.put("Typesetting:-msub", tt);
        specialFunctionMap.put("Typesetting:-msubsup", tt);
        specialFunctionMap.put("Typesetting:-msup", tt);
        specialFunctionMap.put("Typesetting:-mtext", tt);
        specialFunctionMap.put("Typesetting:-merror", tt);
        specialFunctionMap.put("Typesetting:-munder", tt);
        specialFunctionMap.put("Typesetting:-mphantom", tt);
        specialFunctionMap.put("Typesetting:-munderover", tt);
        specialFunctionMap.put("Typesetting:-mprescripts", tt);
        specialFunctionMap.put("Typesetting:-none", tt);
        specialFunctionMap.put("Typesetting:-mfenced", tt);
        specialFunctionMap.put("Typesetting:-mtable", tt);
        specialFunctionMap.put("Typesetting:-mtr", tt);
        specialFunctionMap.put("Typesetting:-mtd", tt);
        specialFunctionMap.put("Typesetting:-mprintslash", tt);
        specialFunctionMap.put("Typesetting:-mparsed", tt);
        specialFunctionMap.put("Typesetting:-mverbatim", tt);
    }

    public static SpecialFunctionTemplate getSpecialFunction(String functionName) {
        if (specialFunctionMap == null) {
            FunctionDagFactory.fillSpecialFunctionMap();
        }
        return (SpecialFunctionTemplate)specialFunctionMap.get(functionName);
    }

    public static Dag createFunctionDag(String name, Dag[] args) {
        Dag expseq = ExpseqDagFactory.createExpseqDag(args);
        Dag namedag = NameDagFactory.createNameDag(name);
        Dag[] funcargs = new Dag[]{namedag, expseq};
        return Dag.createDag(18, funcargs, null, false);
    }

    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        return this.readDotm(is, 18, 3);
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        this.writeDotm(sb, dag, 18, false);
    }

    private void prefixLinePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        Dag name = dag.getChild(0);
        Dag args = dag.getChild(1);
        if (name.getType() == 8) {
            if (name.getData().equals("RTABLE") && (args.getLength() == 3 || options.isLPrintRTableIDForm())) {
                this.lPrintRtable(result, args, options);
                return;
            }
            String nameStr = name.getData();
            if (!(!KEYWORDS.contains(nameStr) || nameStr.startsWith("'") && nameStr.endsWith("'"))) {
                StringBuffer quoteIt = new StringBuffer("`");
                quoteIt.append(nameStr);
                quoteIt.append("`");
                result.append(quoteIt);
            } else {
                DagBuilder.linePrint(result, name, options);
            }
        } else if (name.getType() == 10 || name.getType() == 9) {
            DagBuilder.linePrint(result, name, options);
        } else if (dag.getType() == 18) {
            result.append("(");
            DagBuilder.linePrint(result, name, options);
            result.append(")");
        } else {
            DagBuilder.linePrint(result, name, options);
        }
        result.append("(");
        DagBuilder.linePrint(result, args, options);
        result.append(")");
    }

    private void infixLinePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        Dag name = dag.getChild(0);
        Dag args = dag.getChild(1);
        Dag arg1 = args.getChild(0);
        Dag arg2 = args.getChild(1);
        String functionName = name.getData();
        boolean fence = false;
        if (DagBuilder.getPrecedence(arg1, options) > this.getPrecedence(dag, options) || functionName.equals("^") && DagBuilder.getPrecedence(arg1, options) == this.getPrecedence(dag, options)) {
            result.append("(");
            fence = true;
        }
        DagBuilder.linePrint(result, arg1, options);
        if (fence) {
            result.append(")");
        }
        StringBuffer result2 = new StringBuffer();
        DagBuilder.linePrint(result2, arg2, options);
        if (functionName.equals("+") && result2.charAt(0) == '-') {
            result.append(result2);
        } else {
            String translatedFunctionName = (String)translatedInlineFunctions.get(functionName);
            if (translatedFunctionName != null) {
                functionName = translatedFunctionName;
            }
            result.append(functionName);
            fence = false;
            if (DagBuilder.getPrecedence(arg2, options) > this.getPrecedence(dag, options) || functionName.equals("^") && DagBuilder.getPrecedence(arg2, options) == this.getPrecedence(dag, options)) {
                result.append("(");
                fence = true;
            }
            result.append(result2);
            if (fence) {
                result.append(")");
            }
        }
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        Dag name = dag.getChild(0);
        String nameStr = name.getData();
        Dag args = dag.getChild(1);
        boolean inline = false;
        if (options.isInLineIfPossible() && inlineableFunctions.containsKey(nameStr)) {
            if (args.getLength() == 2) {
                this.infixLinePrint(result, dag, options);
                inline = true;
            } else if ("/".equals(nameStr) && args.getLength() == 1) {
                boolean addBrackets;
                result.append("1/");
                Dag arg = args.getChild(0);
                boolean bl = addBrackets = DagBuilder.getPrecedence(arg, options) >= 4;
                if (addBrackets) {
                    result.append("(");
                }
                DagBuilder.linePrint(result, arg, options);
                if (addBrackets) {
                    result.append(")");
                }
                inline = true;
            }
        }
        if (!inline) {
            this.prefixLinePrint(result, dag, options);
        }
    }

    private void lPrintRtable(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        DagBuilder.linePrint(result, dag.getChild(2), options);
        result.append("(");
        DagBuilder.linePrint(result, dag.getChild(1).getChild(1), options);
        result.append(")");
    }

    @Override
    public int getPrecedence(Dag dag) {
        return 2;
    }

    @Override
    public int getPrecedence(Dag dag, WmiLPrintOptions options) {
        Integer precidenceInt;
        int precidence = 2;
        Dag name = dag.getChild(0);
        String nameStr = name.getData();
        if (options.isInLineIfPossible() && inlineableFunctions.containsKey(nameStr) && (precidenceInt = (Integer)inlineableFunctions.get(nameStr)) != null) {
            precidence = precidenceInt;
        }
        if (precTable.containsKey(nameStr) && (precidenceInt = (Integer)precTable.get(nameStr)) != null) {
            precidence = precidenceInt;
        }
        return precidence;
    }

    @Override
    public int getPrecedence(Dag dag, LayoutFormatter format) {
        int length;
        int precedence = 2;
        if (dag != null && dag.getType() == 18 && (length = dag.getLength()) == 2) {
            Dag arguments;
            String name = dag.getChild(0).getData();
            Integer precmap = (Integer)precedenceMap.get(name);
            if (precmap != null) {
                precedence = precmap;
            } else if (name != null && name.startsWith("&") && (arguments = dag.getChild(1)) != null && arguments.getLength() == 2) {
                precedence = FunctionDagFactory.getNeutralOperatorPrecedence(name);
            }
        }
        return precedence;
    }

    public static int getNeutralOperatorPrecedence(String name) {
        return name.equals("&*") ? 5 : 2;
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        LayoutBox b = null;
        Dag nameDag = dag.getChild(0);
        Dag argDag = dag.getChild(1);
        f.setIsFunctionName(true);
        LayoutBox name = DagBuilder.createLayout(f, nameDag);
        if (name.getSelectionData() == null) {
            name.setSelectionData(FUNCTION_SELECTION_DATA);
        }
        if (name instanceof ProcLayoutBox) {
            name = BracketTemplate.apply(f, name, nameDag, -1);
            name.setLineBreaker(LineBreakerFactory.newLineBreaker(1));
        } else {
            name.setLineBreaker(LineBreakerFactory.newLineBreaker(8));
        }
        if (argDag != null) {
            String functionName = name.getData();
            SpecialFunctionTemplate template = FunctionDagFactory.getSpecialFunction(functionName);
            if (nameDag.getData() != null && nameDag.getData().startsWith("&") && argDag.getLength() == 2) {
                b = NeutralOpInfixTemplate.apply(f, nameDag, argDag);
            } else if (template != null && !f.useInLine(dag)) {
                if (template instanceof VectorShorthandTemplate) {
                    int base = updatedTemplate.contains(functionName) ? 0 : 1;
                    Dag[] arguments = this.normalizeArguments(argDag, base);
                    b = template.apply(f, dag, arguments);
                } else if (!f.isInProc()) {
                    int base = updatedTemplate.contains(functionName) ? 0 : 1;
                    Dag[] arguments = this.normalizeArguments(argDag, base);
                    b = template.apply(f, dag, arguments);
                } else {
                    b = null;
                }
                if (b != null && (template instanceof MatrixTemplate || template instanceof VectorTemplate || template instanceof RtableTemplate)) {
                    b.setAllDags(dag);
                } else if (b != null) {
                    b.setDag(dag);
                }
            } else {
                b = null;
            }
        }
        if (b == null) {
            b = FunctionDagFactory.createGenericLayout(f, dag);
        }
        return b;
    }

    public static LayoutBox createGenericLayout(LayoutFormatter f, Dag dag) {
        Dag nameDag = dag.getChild(0);
        LayoutBox name = DagBuilder.createLayout(f, nameDag);
        LayoutBox box = FunctionDagFactory.createGenericLayout(f, name, dag);
        return box;
    }

    public static LayoutBox createGenericLayout(LayoutFormatter f, LayoutBox nameBox, Dag dag) {
        InlineLayoutBox box = new InlineLayoutBox(DagBuilder.ELEMENT_NAME[dag.getType()], 2);
        Dag nameDag = dag.getChild(0);
        Dag argDag = dag.getChild(1);
        LayoutBox args = DagBuilder.createLayout(f, argDag);
        args = BracketTemplate.apply(f, args, argDag, -1);
        args.setDag(argDag);
        if (nameBox.getSelectionData() == null) {
            nameBox.setSelectionData(FUNCTION_SELECTION_DATA);
        }
        if (nameBox instanceof ProcLayoutBox) {
            nameBox = BracketTemplate.apply(f, nameBox, nameDag, -1);
            nameBox.setLineBreaker(LineBreakerFactory.newLineBreaker(1));
        } else if (nameDag instanceof BranchDag) {
            nameBox = BracketTemplate.apply(f, nameBox, nameDag, 2);
            nameBox.setLineBreaker(LineBreakerFactory.newLineBreaker(1));
        } else {
            nameBox.setLineBreaker(LineBreakerFactory.newLineBreaker(8));
        }
        box.addChild(nameBox);
        box.addChild(args);
        box.setLineBreaker(LineBreakerFactory.newLineBreaker(11));
        return box;
    }

    Dag[] normalizeArguments(Dag args, int base) {
        int length = args.getLength();
        Dag[] normalized = new Dag[length + base];
        int i = 0;
        while (i < length) {
            Dag child = args.getChild(i);
            int type = child.getType();
            if (type == 32 || type == 33 || type == 31) {
                int index = 0;
                try {
                    Dag intDag = child.getChild(0);
                    index = Integer.parseInt(intDag.getData());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (type == 32) {
                    normalized[i + base] = ProcDagFactory.getParameter(index);
                } else if (type == 33) {
                    normalized[i + base] = ProcDagFactory.getLexical(index);
                } else if (type == 31) {
                    normalized[i + base] = ProcDagFactory.getLocal(index);
                }
            } else {
                normalized[i + base] = child;
            }
            ++i;
        }
        return normalized;
    }
}

