/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractBinopDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.HashDag;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class HashTableDagFactory
extends AbstractBinopDagFactory {
    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        int throwaway = DagBuilder.parseShortInteger(is);
        int length = this.isVariableLength() ? DagBuilder.parseShortInteger(is) : 3;
        return this.readDotm(is, this.getType(), 2 * length + 1, throwaway);
    }

    protected Dag readDotm(WmiByteArrayInputStream bs, int type, int length, int size) throws IOException {
        int cnt = 0;
        if (type != 57 && type != 56) {
            cnt = DagBuilder.dagCountPlus();
        }
        HashDag dag = new HashDag(type);
        dag.setSize(size);
        Dag[] myDag = new Dag[--length];
        int i = 0;
        while (i < length) {
            myDag[i] = DagBuilder.create(bs);
            ++i;
        }
        dag.setChildren(myDag);
        if (type != 57 && type != 56) {
            DagBuilder.putDag(dag, cnt);
        }
        return dag;
    }

    @Override
    protected void writeDotm(StringBuffer sb, Dag hdag, int type, boolean writeLength) {
        HashDag dag = (HashDag)hdag;
        int backrefPosition = HashTableDagFactory.isABackref(dag, type);
        if (backrefPosition > 0) {
            this.writeBackref(sb, backrefPosition);
            return;
        }
        char ch = (char)(MapleNumbers.dotMOutputTable[type] + 33 - 1);
        sb.append(ch);
        DagBuilder.writeShortInteger(sb, dag.getSize());
        int length = dag.getLength();
        if (length > 0) {
            if (writeLength) {
                DagBuilder.writeShortInteger(sb, length / 2);
            }
            int i = 0;
            while (i < length) {
                DagBuilder.writeDotm(sb, dag.getChild(i));
                ++i;
            }
        } else {
            DagBuilder.writeShortInteger(sb, 0);
        }
    }

    @Override
    public int getType() {
        return 55;
    }

    @Override
    public String getStringOperator(WmiLPrintOptions options) {
        return ", ";
    }

    @Override
    public NotationLayoutBox createNotationBox(LayoutFormatter formatter) {
        return NotationLayoutBox.createNotationBox(formatter, 14);
    }

    @Override
    public boolean isVariableLength() {
        return true;
    }

    @Override
    public int getPrecedence() {
        return 12;
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        int length = dag.getLength();
        result.append("table( [");
        int i = 0;
        while (i < length) {
            result.append("( ");
            DagBuilder.linePrint(result, dag.getChild(i), options);
            result.append(" ) = ");
            DagBuilder.linePrint(result, dag.getChild(i + 1), options);
            if (i < length - 2) {
                result.append(", ");
            }
            i += 2;
        }
        result.append(" ] )");
    }
}

