/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractCommandDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.ProcTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class IfDagFactory
extends AbstractCommandDagFactory {
    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        return this.readDotm(is, 43, DagBuilder.parseShortInteger(is));
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        this.writeDotm(sb, dag, 43, true);
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        int length = dag.getLength();
        boolean isIntEven = this.isEven(length);
        result.append("if ");
        DagBuilder.linePrint(result, dag.getChild(0), options);
        result.append(" then ");
        DagBuilder.linePrint(result, dag.getChild(1), options);
        int i = 2;
        while (i < length - 1) {
            result.append(" elif ");
            DagBuilder.linePrint(result, dag.getChild(i), options);
            result.append(" then ");
            DagBuilder.linePrint(result, dag.getChild(i + 1), options);
            i += 2;
        }
        if (!isIntEven) {
            result.append(" else ");
            DagBuilder.linePrint(result, dag.getChild(length - 1), options);
        }
        result.append(" end if");
    }

    public boolean isEven(int number) {
        return (number & 1) == 0;
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        int length = dag.getLength();
        boolean isDagEven = this.isEven(length);
        InlineLayoutBox b = new InlineLayoutBox(5 + (length - 1 + (length - 1) / 2));
        b.addChild(this.layout_if_then(f, dag.getChild(0)));
        b.addChild(new ProcTemplate.ProcDelimiter(f));
        b.addChild(this.layout_statement(f, dag.getChild(1)));
        int i = 2;
        while (i < length - 1) {
            ProcTemplate.addNeededDelimiter(f, b);
            b.addChild(this.layout_if_then(f, dag.getChild(i), 40));
            b.addChild(new ProcTemplate.ProcDelimiter(f));
            b.addChild(this.layout_statement(f, dag.getChild(i + 1)));
            i += 2;
        }
        if (!isDagEven) {
            InlineLayoutBox row = new InlineLayoutBox(1);
            row.addChild(NotationLayoutBox.createNotationBox(f, 41));
            ProcTemplate.addNeededDelimiter(f, b);
            b.addChild(row);
            b.addChild(new ProcTemplate.ProcDelimiter(f));
            b.addChild(this.layout_statement(f, dag.getChild(length - 1)));
        }
        ProcTemplate.addNeededDelimiter(f, b);
        b.addChild(NotationLayoutBox.createNotationBox(f, longForm ? 69 : 42));
        b.addChild(ProcTemplate.createSemiColon(f));
        b.addChild(new ProcTemplate.ProcDelimiter(f));
        b.setLineBreaker(LineBreakerFactory.newLineBreaker(16));
        return b;
    }

    private LayoutBox layout_if_then(LayoutFormatter f, Dag condition) {
        return this.layout_if_then(f, condition, 38);
    }

    private LayoutBox layout_if_then(LayoutFormatter f, Dag condition, int ifType) {
        InlineLayoutBox row = new InlineLayoutBox(5);
        row.addChild(NotationLayoutBox.createNotationBox(f, ifType));
        row.addChild(NotationLayoutBox.createCustomBox(f, " "));
        row.addChild(DagBuilder.createLayout(f, condition));
        row.addChild(NotationLayoutBox.createCustomBox(f, " "));
        row.addChild(NotationLayoutBox.createNotationBox(f, 39));
        row.setLineBreaker(LineBreakerFactory.newLineBreaker(17));
        return row;
    }

    private LayoutBox layout_statement(LayoutFormatter f, Dag statement) {
        return ProcTemplate.layoutStatement(f, statement);
    }
}

