/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractBinopDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;

public class ImpliesDagFactory
extends AbstractBinopDagFactory {
    @Override
    public int getType() {
        return 28;
    }

    @Override
    public String getStringOperator(WmiLPrintOptions options) {
        return " implies ";
    }

    @Override
    public boolean isVariableLength() {
        return false;
    }

    @Override
    public int getPrecedence() {
        return 18;
    }

    @Override
    public NotationLayoutBox createNotationBox(LayoutFormatter formatter) {
        return NotationLayoutBox.createNotationBox(formatter, 13);
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        int length = dag.getLength();
        if (length > 0) {
            int i = 0;
            while (i < length) {
                Dag child = dag.getChild(i);
                if (DagBuilder.getPrecedence(child, options) >= this.getPrecedence()) {
                    result.append("(");
                    DagBuilder.linePrint(result, child, options);
                    result.append(")");
                } else {
                    DagBuilder.linePrint(result, child, options);
                }
                if (i < length - 1) {
                    result.append(this.getStringOperator(options));
                }
                ++i;
            }
        }
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        return super.createLayout(f, dag, true);
    }
}

