/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class LexicalDagFactory
extends AbstractDagFactory {
    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        int cnt = DagBuilder.dagCountPlus();
        int value = DagBuilder.parseShortInteger(is);
        Dag[] args = new Dag[1];
        value = value % 2 == 0 ? (value /= 2) : -(value / 2);
        args[0] = Dag.createDag(2, null, Integer.toString(value), false);
        Dag newDag = Dag.createDag(33, args, null, true);
        DagBuilder.putDag(newDag, cnt);
        return newDag;
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        int type = dag.getType();
        int backrefPosition = LexicalDagFactory.isABackref(dag, type);
        if (backrefPosition > 0) {
            this.writeBackref(sb, backrefPosition);
            return;
        }
        char ch = (char)(MapleNumbers.dotMOutputTable[33] + 33 - 1);
        sb.append(ch);
        int temp = Integer.parseInt(dag.getChild(0).getData());
        temp = temp < 0 ? -(temp * 2) + 1 : (temp *= 2);
        DagBuilder.writeShortInteger(sb, temp);
    }

    @Override
    public Dag normalize(Dag dag) {
        Dag result = null;
        Dag lexArg = null;
        if (dag != null && dag.getType() == 33) {
            if (!dag.isNormalized()) {
                lexArg = dag.getChild(0);
                int pos = Integer.parseInt(lexArg.getData());
                if (pos < 0) {
                    pos = -pos;
                }
                try {
                    result = ProcDagFactory.getLexical(2 * pos);
                    if (result != null) {
                        int type = result.getType();
                        switch (type) {
                            case 31: 
                            case 32: 
                            case 33: 
                            case 40: {
                                result = ProcDagFactory.getLexical(2 * pos - 1);
                            }
                        }
                        result = DagBuilder.normalize(result);
                    }
                    if (result == null) {
                        Dag[] args = new Dag[]{Dag.createDag(8, null, "lex", false), lexArg};
                        result = Dag.createDag(10, args, null, false);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (result != null && result.getType() == 11) {
                    result = result.getChild(0);
                }
                if (result != null) {
                    dag.setNormalized(result);
                }
            } else {
                result = dag.getNormalized();
            }
        }
        return result;
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        int pos = Integer.parseInt(dag.getChild(0).getData());
        if (pos < 0) {
            pos = -pos;
        }
        try {
            Dag temp = ProcDagFactory.getLexical(pos + pos);
            temp = temp != null && (temp.getType() == 32 || temp.getType() == 31) ? ProcDagFactory.getLexical(pos + pos - 1) : ProcDagFactory.getLexical(pos + pos);
            DagBuilder.linePrint(result, temp, options);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public int getPrecedence() {
        return 1;
    }
}

