/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class LocalDagFactory
extends AbstractDagFactory {
    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        int cnt = DagBuilder.dagCountPlus();
        int value = DagBuilder.parseShortInteger(is);
        Dag[] args = new Dag[]{Dag.createDag(2, null, Integer.toString(value - 2), false)};
        Dag newDag = Dag.createDag(31, args, null, true);
        DagBuilder.putDag(newDag, cnt);
        return newDag;
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        int type = dag.getType();
        int backrefPosition = LocalDagFactory.isABackref(dag, type);
        if (backrefPosition > 0) {
            this.writeBackref(sb, backrefPosition);
            return;
        }
        char ch = (char)(MapleNumbers.dotMOutputTable[31] + 33 - 1);
        sb.append(ch);
        String value = dag.getChild(0).getData();
        int iValue = Integer.parseInt(value) + 2;
        DagBuilder.writeShortInteger(sb, iValue);
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public Dag normalize(Dag dag) {
        Dag temp = null;
        Dag localArg = null;
        if (dag != null && dag.getType() == 31) {
            if (!dag.isNormalized()) {
                try {
                    localArg = dag.getChild(0);
                    int pos = Integer.parseInt(localArg.getData());
                    temp = ProcDagFactory.getLocal(pos);
                    if (temp != null && temp.getType() == 11) {
                        temp = temp.getChild(0);
                    }
                }
                catch (NumberFormatException pos) {
                }
                catch (ArrayIndexOutOfBoundsException pos) {
                    // empty catch block
                }
                if (temp == null) {
                    Dag[] args = new Dag[]{Dag.createDag(8, null, "loc", false), localArg};
                    temp = Dag.createDag(10, args, null, false);
                }
                if (temp != null) {
                    dag.setNormalized(temp);
                }
            } else {
                temp = dag.getNormalized();
            }
        }
        return temp;
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        int pos = Integer.parseInt(dag.getChild(0).getData());
        try {
            Dag temp = ProcDagFactory.getLocal(pos);
            if (temp != null && temp.getType() == 11) {
                DagBuilder.linePrint(result, temp.getChild(0), options);
            } else {
                DagBuilder.linePrint(result, temp, options);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        NotationLayoutBox b = null;
        int pos = Integer.parseInt(dag.getChild(0).getData());
        String value = "";
        try {
            Dag temp = ProcDagFactory.getLocal(pos);
            if (temp != null && temp.getType() == 11) {
                value = temp.getChild(0).getData();
            } else if (temp != null) {
                value = temp.getData();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        b = NotationLayoutBox.createCustomBox(f, value);
        return b;
    }
}

