/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class ModdefDagFactory
extends AbstractDagFactory {
    public static final int MODDEF_LENGTH = 10;
    public static final int PARAM_INDEX = 0;
    public static final int LOCAL_INDEX = 1;
    public static final int OPTION_INDEX = 2;
    public static final int EXPORT_INDEX = 3;
    public static final int STATSEQ_INDEX = 4;
    public static final int DESCRIPTION_INDEX = 5;
    public static final int GLOBAL_INDEX = 6;
    public static final int LEXICAL_INDEX = 7;
    public static final int NAME_INDEX = 8;

    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        return this.readDotm(is, 39, 10);
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        this.writeDotm(sb, dag, 39, false);
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        String sep = " ";
        result.append("module ");
        Dag child = dag.getChild(8);
        if (ModdefDagFactory.calculateLength(child) > 0) {
            DagBuilder.linePrint(result, child, options);
            result.append(sep);
        }
        result.append("(");
        result.append(") ");
        child = dag.getChild(5);
        if (!DagUtil.isNull(child) && child.getLength() > 0) {
            result.append("description ");
            DagBuilder.linePrint(result, child, options);
            result.append(";" + sep);
        }
        if ((child = dag.getChild(1)).getLength() > 0) {
            result.append("local ");
            DagBuilder.linePrint(result, child, options);
            result.append("; ");
        }
        if ((child = dag.getChild(3)).getLength() > 0) {
            result.append("export ");
            DagBuilder.linePrint(result, child, options);
            result.append(";");
            result.append(sep);
        }
        if ((child = dag.getChild(6)).getLength() > 0) {
            result.append("global ");
            DagBuilder.linePrint(result, child, options);
            result.append(";" + sep);
        }
        if ((child = dag.getChild(2)).getLength() > 0) {
            result.append("option ");
            DagBuilder.linePrint(result, child, options);
            result.append(";");
            result.append(sep);
        }
        ProcDagFactory.addToStacks(dag.getChild(0), dag.getChild(1), dag.getChild(7), dag.getChild(3));
        child = dag.getChild(4);
        if (child.getLength() > 0) {
            result.append(" ");
            DagBuilder.linePrint(result, child, options);
            result.append(" ");
        }
        result.append("end module");
        ProcDagFactory.removeStacks();
    }

    public static int calculateLength(Dag dag) {
        int length = 1;
        if (dag.getData() != null) {
            length = dag.getData().startsWith("_m") ? 0 : dag.getData().length();
        } else {
            length = dag.getLength();
            if (length > 0) {
                ++length;
            }
        }
        return length;
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter formatter, Dag dag) {
        String value = DagBuilder.lPrint(dag, new WmiLPrintOptions());
        NotationLayoutBox box = NotationLayoutBox.createCustomBox(formatter, value);
        return box;
    }
}

