/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AttributedLeafDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstructor;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.LeafDag;
import com.maplesoft.client.dag.TextDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.AbstractFormatter;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.encoder.KernelEncoder;
import java.util.HashSet;

public class NameDagFactory
extends TextDagFactory {
    public static final String NAME_QUOTE = "`";
    private static final DagConstructor constructor = new NameConstructor();
    private static final int DEFAULT_SHOW_ASSUMED = 0;
    private static int showAssumedValue = 0;
    private static HashSet quotedNames = new HashSet();
    private static HashSet nonQuotedNames = new HashSet();
    private static HashSet quotedOnlyInProcs = new HashSet();

    static {
        quotedNames.add("<,>");
        quotedNames.add("<|>");
        quotedNames.add("and");
        quotedNames.add("assuming");
        quotedNames.add("break");
        quotedNames.add("by");
        quotedNames.add("catch");
        quotedNames.add("description");
        quotedNames.add("do");
        quotedNames.add("done");
        quotedNames.add("elif");
        quotedNames.add("else");
        quotedNames.add("end");
        quotedNames.add("error");
        quotedNames.add("export");
        quotedNames.add("fi");
        quotedNames.add("finally");
        quotedNames.add("for");
        quotedNames.add("from");
        quotedNames.add("global");
        quotedNames.add("if");
        quotedNames.add("implies");
        quotedNames.add("in");
        quotedNames.add("intersect");
        quotedNames.add("local");
        quotedNames.add("minus");
        quotedNames.add("mod");
        quotedNames.add("next");
        quotedNames.add("not");
        quotedNames.add("od");
        quotedNames.add("option");
        quotedNames.add("options");
        quotedNames.add("or");
        quotedNames.add("quit");
        quotedNames.add("read");
        quotedNames.add("return");
        quotedNames.add("save");
        quotedNames.add("stop");
        quotedNames.add("subset");
        quotedNames.add("then");
        quotedNames.add("to");
        quotedNames.add("try");
        quotedNames.add("union");
        quotedNames.add("use");
        quotedNames.add("uses");
        quotedNames.add("while");
        quotedNames.add("xor");
        nonQuotedNames.add(" $");
        quotedOnlyInProcs.add("mod");
        quotedOnlyInProcs.add("RTABLE");
        quotedOnlyInProcs.add("");
    }

    public NameDagFactory() {
        super(8);
    }

    public static Dag createNameDag(String name) {
        return Dag.createDag(8, null, name, true);
    }

    @Override
    public DagConstructor getConstructor() {
        return constructor;
    }

    @Override
    public void updateContext(DagRenderContext context) {
        showAssumedValue = context.getInterfaceProperty("showassumed", 0);
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        LayoutBox b = null;
        if (dag.getLength() == 0) {
            String value = dag.getData();
            if (value.endsWith("~") && value.length() > 1) {
                if (showAssumedValue == 0 || showAssumedValue == 2) {
                    value = value.substring(0, value.length() - 1);
                }
                if (showAssumedValue == 2 && !f.containsJobForIdentifier(value)) {
                    f.addPostLayoutJob(value, new AbstractFormatter.AssumptionLabelJob(f, value));
                }
            }
            if (NameDagFactory.isQuotationNeeded(f, dag)) {
                StringBuffer valueQuoter = new StringBuffer(NAME_QUOTE);
                valueQuoter.append(value);
                valueQuoter.append(NAME_QUOTE);
                value = valueQuoter.toString();
            }
            b = this.createBox(f, value);
            b.setLineBreaker(LineBreakerFactory.newLineBreaker(8));
        }
        return b;
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        String name = dag.getDataOnly();
        KernelEncoder encoder = RuntimeLocale.getKernelEncoder();
        if (encoder != null) {
            name = encoder.fromUnicode(name, false);
        }
        Dag attributes = dag.getAttributes();
        char ch = '\u0000';
        int backrefPosition = NameDagFactory.isABackref(dag, this.type);
        if (backrefPosition > 0) {
            this.writeBackref(sb, backrefPosition);
            return;
        }
        if (attributes == null || attributes.getType() == 57 || dag instanceof AttributedLeafDag && dag == attributes) {
            ch = (char)(MapleNumbers.dotMOutputTable[this.type] + 33 - 1);
        } else {
            ch = (char)(MapleNumbers.dotMOutputTable[this.type + 57] + 33 - 1);
            if (ch == ' ') {
                ch = (char)(MapleNumbers.dotMOutputTable[this.type] + 33 - 1);
            }
        }
        sb.append(ch);
        int calculatedLength = name.length();
        DagBuilder.writeShortInteger(sb, calculatedLength);
        DagBuilder.writeNameAsDotm(sb, name);
        sb.append((char)(MapleNumbers.dotMOutputTable[57] + 33 - 1));
        if (attributes != null && attributes.getType() != 57) {
            if (dag instanceof AttributedLeafDag) {
                if (dag != attributes) {
                    DagBuilder.writeDotm(sb, attributes);
                }
            } else {
                DagBuilder.writeDotm(sb, attributes);
            }
        }
    }

    public static boolean isQuotationNeeded(Dag dag) {
        return NameDagFactory.isQuotationNeeded(null, dag);
    }

    public static boolean isQuotationNeeded(LayoutFormatter f, Dag dag) {
        boolean prettyprinting;
        boolean needsQuotes = false;
        String val = dag.getDataOnly();
        if (val == null || val.length() == 0) {
            return false;
        }
        if (val.charAt(0) == '\'' && val.charAt(val.length() - 1) == '\'') {
            return false;
        }
        boolean bl = prettyprinting = f != null;
        if (quotedNames.contains(val)) {
            return true;
        }
        if (nonQuotedNames.contains(val)) {
            return needsQuotes;
        }
        if (f != null && f.isInProc() && quotedOnlyInProcs.contains(val)) {
            return true;
        }
        if (val.equals("")) {
            needsQuotes = false;
        } else {
            int index = 0;
            char p = val.charAt(index);
            if (Character.isLetter(p) || p == '_') {
                ++index;
                while (index < val.length() && (Character.isLetterOrDigit(val.charAt(index)) || val.charAt(index) == '_' || val.charAt(index) == '~' || val.charAt(index) == ':')) {
                    ++index;
                }
            } else if (p == '%') {
                ++index;
                while (index < val.length() && (Character.isLetterOrDigit(val.charAt(index)) || val.charAt(index) == '_' || val.charAt(index) == '$' || val.charAt(index) == '?')) {
                    ++index;
                }
            } else if (p == '~' && prettyprinting && !f.isInOperatorProc()) {
                ++index;
                while (index < val.length() && (Character.isLetterOrDigit(val.charAt(index)) || val.charAt(index) == '$' || val.charAt(index) == '_')) {
                    ++index;
                }
            }
            if (p == '&') {
                needsQuotes = true;
                needsQuotes = prettyprinting && f.isInProc() || !prettyprinting;
            } else {
                boolean bl2 = needsQuotes = index != val.length();
                if (needsQuotes && prettyprinting) {
                    needsQuotes = f.isInProc();
                }
            }
        }
        return needsQuotes;
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        String out = dag.getDataOnly();
        if (out.length() > 1 && out.lastIndexOf(126) == out.length() - 1) {
            out = out.substring(0, out.length() - 1);
        }
        boolean quotingNeeded = (out.startsWith("Copyright") || NameDagFactory.isQuotationNeeded(dag) || out.length() == 0) && !options.isDropStringQuotes();
        StringBuffer thisResult = new StringBuffer();
        if (quotingNeeded) {
            thisResult.append(NAME_QUOTE);
        }
        thisResult.append(out);
        if (quotingNeeded) {
            thisResult.append(NAME_QUOTE);
        }
        if (!dag.getDataOnly().equals(dag.getData())) {
            result.append(((AttributedLeafDag)dag).getModuleName());
            result.append(":-");
        }
        result.append(thisResult);
    }

    private static class NameConstructor
    extends DagConstructor {
        private NameConstructor() {
        }

        @Override
        public Dag createDag(int type, Dag[] children, Object data, boolean attributed) {
            return attributed ? new AttributedLeafDag(type, data) : new LeafDag(type, data);
        }
    }
}

