/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class ParamDagFactory
extends AbstractDagFactory {
    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        int cnt = DagBuilder.dagCountPlus();
        int value = DagBuilder.parseShortInteger(is);
        Dag[] args = new Dag[]{Dag.createDag(2, null, Integer.toString(value - 2), false)};
        Dag newDag = Dag.createDag(32, args, null, true);
        DagBuilder.putDag(newDag, cnt);
        return newDag;
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        int type = dag.getType();
        int backrefPosition = ParamDagFactory.isABackref(dag, type);
        if (backrefPosition > 0) {
            this.writeBackref(sb, backrefPosition);
            return;
        }
        char ch = (char)(MapleNumbers.dotMOutputTable[32] + 33 - 1);
        sb.append(ch);
        int value = Integer.parseInt(dag.getChild(0).getData()) + 2;
        DagBuilder.writeShortInteger(sb, value);
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public Dag normalize(Dag dag) {
        Dag temp = null;
        Dag paramArg = null;
        if (dag != null && dag.getType() == 32) {
            if (!dag.isNormalized()) {
                paramArg = dag.getChild(0);
                int pos = Integer.parseInt(paramArg.getData());
                if (pos > 0) {
                    try {
                        temp = ProcDagFactory.getParameter(pos);
                        if (DagUtil.isAssignDag(temp)) {
                            temp = temp.getChild(0);
                        }
                        if (temp != null && temp.getType() == 11) {
                            temp = temp.getChild(0);
                        }
                        if (temp == null) {
                            Dag[] args = new Dag[]{Dag.createDag(8, null, "args", false), paramArg};
                            temp = Dag.createDag(10, args, null, false);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException args) {}
                } else {
                    String data = "";
                    data = pos == -5 ? "_nparams" : (pos == -4 ? "_params" : (pos == -3 ? "_nresults" : (pos == -7 ? "_nrest" : (pos == -6 ? "_rest" : (pos == -9 ? "_noptions" : (pos == -8 ? "_options" : (pos == -2 ? "procname" : (pos == -1 ? "args" : "nargs"))))))));
                    temp = Dag.createDag(8, null, data, true);
                }
                if (temp != null) {
                    if (temp.getType() == 30 && temp.getLength() > 0) {
                        temp = temp.getChild(0);
                    }
                    dag.setNormalized(temp);
                }
            } else {
                temp = dag.getNormalized();
            }
        }
        return temp;
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        int pos = Integer.parseInt(dag.getChild(0).getData());
        if (pos > 0) {
            try {
                Dag temp = ProcDagFactory.getParameter(pos);
                if (temp != null && temp.getType() == 11) {
                    DagBuilder.linePrint(result, temp.getChild(0), options);
                } else {
                    DagBuilder.linePrint(result, temp, options);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        String value;
        NotationLayoutBox b;
        block5: {
            b = null;
            int pos = Integer.parseInt(dag.getChild(0).getData());
            value = "";
            if (pos > 0) {
                try {
                    Dag temp = ProcDagFactory.getParameter(pos);
                    if (temp != null && temp.getType() == 11) {
                        value = temp.getChild(0).getData();
                        break block5;
                    }
                    value = temp.getData();
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            } else {
                value = pos == -2 ? "procname" : (pos == -1 ? "args" : "nargs");
            }
        }
        b = NotationLayoutBox.createCustomBox(f, value);
        return b;
    }

    static Dag createParamDag(int type) {
        int cnt = DagBuilder.dagCountPlus();
        Dag[] args = null;
        Dag newDag = null;
        if (type == 76) {
            args = new Dag[]{Dag.createDag(1, null, Integer.toString(-3), false)};
        } else if (type == 78) {
            args = new Dag[]{Dag.createDag(1, null, Integer.toString(-4), false)};
        } else if (type == 79) {
            args = new Dag[]{Dag.createDag(1, null, Integer.toString(-5), false)};
        } else if (type == 80) {
            args = new Dag[]{Dag.createDag(1, null, Integer.toString(-6), false)};
        } else if (type == 81) {
            args = new Dag[]{Dag.createDag(1, null, Integer.toString(-7), false)};
        } else if (type == 82) {
            args = new Dag[]{Dag.createDag(1, null, Integer.toString(-8), false)};
        } else if (type == 83) {
            args = new Dag[]{Dag.createDag(1, null, Integer.toString(-9), false)};
        }
        if (args != null) {
            newDag = Dag.createDag(32, args, null, true);
        }
        DagBuilder.putDag(newDag, cnt);
        return newDag;
    }
}

