/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.PowerDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.BinaryOperationTemplate;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.DivideTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class ProdDagFactory
extends AbstractDagFactory {
    public static Dag create(Dag[] dag) {
        return Dag.createDag(14, dag, null, false);
    }

    public static Dag create(Dag dag1, int sgn1, Dag dag2, int sgn2) {
        Dag[] kids = new Dag[]{dag1, sgn1 == 1 ? DagConstants.ONE : DagConstants.MINUS_ONE, dag2, sgn2 == 1 ? DagConstants.ONE : DagConstants.MINUS_ONE};
        return Dag.createDag(14, kids, null, false);
    }

    public static Dag create(Dag first, Dag second) {
        int firstLength = first.getLength();
        int secondLength = second.getLength();
        Dag[] kids = null;
        if (second.getType() == 14) {
            if (first.getType() == 14) {
                kids = new Dag[firstLength + secondLength];
                int n = 0;
                int i = 0;
                while (i < firstLength) {
                    kids[n++] = first.getChild(i);
                    ++i;
                }
                i = 0;
                while (i < secondLength) {
                    kids[n++] = second.getChild(i);
                    ++i;
                }
            } else {
                kids = new Dag[secondLength + 2];
                kids[0] = first;
                kids[1] = DagConstants.ONE;
                int i = 0;
                int n = 2;
                while (i < secondLength) {
                    kids[n++] = second.getChild(i);
                    ++i;
                }
            }
        } else {
            kids = new Dag[4];
            kids[0] = first;
            kids[2] = second;
            kids[1] = kids[3] = DagConstants.ONE;
        }
        return Dag.createDag(14, kids, null, false);
    }

    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        return this.readDotm(is, 14, DagBuilder.parseShortInteger(is));
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        this.writeDotm(sb, dag, 14, true);
    }

    @Override
    public int getPrecedence() {
        return 4;
    }

    public StringBuffer toString(Dag dag) {
        StringBuffer result = null;
        StringBuffer numerator = new StringBuffer();
        StringBuffer denominator = new StringBuffer();
        int numeratorSize = 0;
        int denominatorSize = 0;
        int length = dag.getLength();
        int i = 0;
        while (i < length) {
            Dag base = dag.getChild(i);
            Dag power = dag.getChild(i + 1);
            if (base.getType() != 2 || !base.getData().equals("1")) {
                if (power.getType() == 2) {
                    this.infixAppendBuffer(numerator, base, numeratorSize, new WmiLPrintOptions(), false);
                    ++numeratorSize;
                } else {
                    this.infixAppendBuffer(denominator, base, denominatorSize, new WmiLPrintOptions(), false);
                    ++denominatorSize;
                }
            }
            i += 2;
        }
        if (denominatorSize == 0) {
            result = numerator;
        } else {
            if (numeratorSize == 0) {
                result = new StringBuffer("1/");
            } else {
                result = numerator;
                result.append("/");
            }
            if (denominatorSize > 1) {
                result.append("(");
                result.append(denominator);
                result.append(")");
            } else {
                result.append(denominator);
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void infixLinePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        numerator = new StringBuffer();
        denominator = new StringBuffer();
        numeratorSize = 0;
        denominatorSize = 0;
        length = dag.getLength();
        needDenominatorBrackets = false;
        i = 0;
        while (i < length) {
            block16: {
                base = dag.getChild(i);
                power = dag.getChild(i + 1);
                if (base.getType() == 2 && base.getData().equals("1")) break block16;
                if (base.getType() != 18) ** GOTO lbl-1000
                name = base.getChild(0);
                args = base.getChild(1);
                if (name.getData() != null && name.getData().equals("/") && args.getLength() == 1) {
                    if (power.getType() == 2) {
                        this.infixAppendBuffer(denominator, args, denominatorSize, options, true);
                        ++denominatorSize;
                    } else {
                        this.infixAppendBuffer(numerator, args, numeratorSize, options, true);
                        if (base.getType() == 14) {
                            needDenominatorBrackets = true;
                        }
                        ++numeratorSize;
                    }
                } else if (power.getType() == 2) {
                    this.infixAppendBuffer(numerator, base, numeratorSize, options, false);
                    ++numeratorSize;
                } else {
                    this.infixAppendBuffer(denominator, base, denominatorSize, options, false);
                    if (base.getType() == 14) {
                        needDenominatorBrackets = true;
                    }
                    ++denominatorSize;
                }
            }
            i += 2;
        }
        if (denominatorSize == 0) {
            if (numerator.charAt(0) == '-' && result.length() > 0) {
                result.setLength(result.length() - 1);
            }
            result.append(numerator);
        } else {
            if (numeratorSize == 0) {
                result.append("1/");
            } else {
                result.append(numerator);
                result.append("/");
            }
            if (denominatorSize > 1 || needDenominatorBrackets) {
                result.append("(");
                result.append(denominator);
                result.append(")");
            } else {
                result.append(denominator);
            }
        }
    }

    private void prefixLinePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        StringBuffer numerator = new StringBuffer();
        StringBuffer denominator = new StringBuffer();
        int numeratorSize = 0;
        int denominatorSize = 0;
        int length = dag.getLength();
        int i = 0;
        while (i < length) {
            Dag base = dag.getChild(i);
            Dag power = dag.getChild(i + 1);
            if (base.getType() != 2 || !base.getData().equals("1")) {
                if (power.getType() == 2) {
                    if (numeratorSize > 0) {
                        numerator.append(", ");
                    }
                    numerator.append("`*`(");
                    DagBuilder.linePrint(numerator, base, options);
                    ++numeratorSize;
                } else {
                    if (denominatorSize > 0) {
                        denominator.append(", ");
                    }
                    denominator.append("`*`(");
                    DagBuilder.linePrint(denominator, base, options);
                    ++denominatorSize;
                }
            }
            i += 2;
        }
        i = 0;
        while (i < numeratorSize) {
            numerator.append(")");
            ++i;
        }
        i = 0;
        while (i < denominatorSize) {
            denominator.append(")");
            ++i;
        }
        if (denominatorSize == 0) {
            result.append(numerator);
        } else if (numeratorSize == 0) {
            result.append("`/`(1, ");
            result.append(denominator);
            result.append(")");
        } else {
            result.append("`/`(");
            result.append(numerator);
            result.append(", ");
            result.append(denominator);
            result.append(")");
        }
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        if (options.isInLineIfPossible()) {
            this.infixLinePrint(result, dag, options);
        } else {
            this.prefixLinePrint(result, dag, options);
        }
    }

    protected void infixAppendBuffer(StringBuffer sb, Dag dag, int size, WmiLPrintOptions options, boolean addBrackets) {
        if (size > 0) {
            sb.append("*");
        }
        if (addBrackets |= DagBuilder.getPrecedence(dag, options) >= 4) {
            sb.append("(");
        }
        DagBuilder.linePrint(sb, dag, options);
        if (addBrackets) {
            sb.append(")");
        }
    }

    @Override
    public Dag normalize(Dag dag) {
        boolean positive = true;
        Dag result = null;
        if (dag != null) {
            if (!dag.isNormalized()) {
                result = dag.copy();
                int length = dag.getLength();
                int i = 0;
                while (i < length) {
                    Dag base = dag.getChild(i);
                    Dag power = dag.getChild(i + 1);
                    if (base.getType() == 16 && DagUtil.isOne(power) && base.getLength() == 2 && DagUtil.isNegative(base.getChild(1))) {
                        positive = !positive;
                        base = DagUtil.negate(base);
                    }
                    if (DagUtil.isNegative(power)) {
                        if (DagUtil.isMinusOne(power)) {
                            result.setChild(i, base);
                            result.setChild(i + 1, power);
                        } else {
                            result.setChild(i, PowerDagFactory.create(base, DagUtil.negate(power)));
                            result.setChild(i + 1, DagConstants.MINUS_ONE);
                        }
                    } else if (DagUtil.isOne(power)) {
                        result.setChild(i, base);
                        result.setChild(i + 1, power);
                    } else {
                        result.setChild(i, PowerDagFactory.create(base, power));
                        result.setChild(i + 1, DagConstants.ONE);
                    }
                    i += 2;
                }
                if (!positive) {
                    Dag[] sumDags = new Dag[]{result, DagConstants.MINUS_ONE};
                    result = Dag.createDag(16, sumDags, null, false);
                }
                dag.setNormalized(result);
            } else {
                result = dag.getNormalized();
            }
        }
        return result;
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        String boxName = DagBuilder.ELEMENT_NAME[14];
        int length = dag.getLength();
        LayoutBox b = new ProdLayoutBox(boxName, 3);
        int beginIndex = 1;
        if (dag.getChild(0).getType() == 3) {
            beginIndex = 3;
        }
        ArrayList<Dag> numeratorDags = new ArrayList<Dag>();
        ArrayList<Dag> denominatorDags = new ArrayList<Dag>();
        int maxNumPrec = 4;
        int maxDenomPrec = 4;
        int i = beginIndex;
        while (i < length) {
            Dag base = dag.getChild(i - 1);
            Dag power = dag.getChild(i);
            int prec = DagBuilder.getPrecedence(base, f);
            if (power.getType() == 2) {
                numeratorDags.add(base);
                numeratorDags.add(power);
                maxNumPrec = Math.max(prec, maxNumPrec);
            } else {
                denominatorDags.add(base);
                denominatorDags.add(DagConstants.ONE);
                maxDenomPrec = Math.max(prec, maxDenomPrec);
            }
            i += 2;
        }
        if (denominatorDags.size() > 0 && dag.getChild(0).getType() == 3) {
            Dag rational = dag.getChild(0);
            Dag rationalNumerator = rational.getChild(0);
            if (!DagUtil.isOne(rationalNumerator)) {
                numeratorDags.add(0, rationalNumerator);
                numeratorDags.add(1, DagConstants.ONE);
            }
            denominatorDags.add(0, rational.getChild(1));
            denominatorDags.add(1, DagConstants.ONE);
            beginIndex = 1;
        }
        Dag numeratorDag = null;
        Dag denominatorDag = null;
        if (numeratorDags.size() > 0) {
            Dag[] numArray = numeratorDags.toArray(new Dag[0]);
            numeratorDag = ProdDagFactory.create(numArray);
        }
        if (denominatorDags.size() > 0) {
            Dag[] denomArray = denominatorDags.toArray(new Dag[0]);
            denominatorDag = ProdDagFactory.create(denomArray);
        }
        LayoutBox numeratorBox = null;
        LayoutBox denominatorBox = null;
        int operator = f.isInProc() ? 75 : 76;
        numeratorBox = this.buildNumerator(f, numeratorDag, denominatorDag, maxNumPrec, operator);
        denominatorBox = this.buildDenominator(f, denominatorDag, maxDenomPrec, operator);
        LayoutBox box = null;
        if (denominatorBox == null) {
            box = numeratorBox;
        } else {
            int mode = this.getLayoutMode(f, numeratorDags, true) | this.getLayoutMode(f, denominatorDags, false);
            double sizeLimit = f.getSafeBreakWidth();
            numeratorBox.applyLayout();
            denominatorBox.applyLayout();
            if (denominatorBox.getWidth() > sizeLimit || f.isInProc()) {
                mode |= 1;
            } else if (numeratorBox.getWidth() > sizeLimit) {
                ProdLayoutBox oneBox = new ProdLayoutBox("numereator", 1);
                oneBox.addChild(DagBuilder.createLayout(f, DagConstants.ONE));
                LayoutBox overBox = DivideTemplate.apply(f, oneBox, denominatorBox, 0);
                box = new InlineLayoutBox();
                box.addChild(overBox);
                box.addChild(NotationLayoutBox.createNotationBox(f, 76));
                if ((mode & 2) != 0) {
                    numeratorBox = BracketTemplate.apply(f, numeratorBox, 91, 92);
                }
                box.addChild(numeratorBox);
            } else {
                mode |= 0;
            }
            if (box == null) {
                box = DivideTemplate.apply(f, numeratorBox, denominatorBox, mode);
            }
            if (beginIndex != 1) {
                box = BracketTemplate.apply(f, box);
                box.setLineBreaker(LineBreakerFactory.newLineBreaker(1));
            }
        }
        if (beginIndex != 1) {
            b.addChild(DagBuilder.createLayout(f, dag.getChild(0)));
            b.addChild(NotationLayoutBox.createNotationBox(f, operator));
            b.addChild(box);
        } else {
            b = box;
        }
        return b;
    }

    private int getLayoutMode(LayoutFormatter formatter, ArrayList dags, boolean numerator) {
        int mode = 0;
        boolean changeMode = false;
        if (dags.size() == 3) {
            int prec = DagBuilder.getPrecedence((Dag)dags.get(1), formatter);
            if (prec >= 6) {
                changeMode = true;
            }
        } else {
            changeMode = true;
        }
        if (changeMode) {
            mode = numerator ? 2 : 4;
        }
        return mode;
    }

    private LayoutBox buildNumerator(LayoutFormatter f, Dag numeratorDag, Dag denominatorDag, int precedence, int operator) {
        ProdLayoutBox numeratorBox = null;
        if (numeratorDag != null) {
            int numeratorLength = numeratorDag.getLength();
            numeratorBox = new ProdLayoutBox("numerator", numeratorLength / 2);
            numeratorBox.setDag(numeratorDag);
            numeratorBox.setPrecedence(precedence);
            NotationLayoutBox op = null;
            if (numeratorLength == 2) {
                numeratorBox.addChild(DagBuilder.createLayout(f, numeratorDag.getChild(0)));
            } else {
                int i = 0;
                while (i < numeratorLength) {
                    op = NotationLayoutBox.createNotationBox(f, operator);
                    BinaryOperationTemplate.apply(f, (LayoutBox)numeratorBox, op, numeratorDag.getChild(i), 4);
                    i += 2;
                }
            }
        } else if (denominatorDag != null) {
            numeratorBox = new ProdLayoutBox("numerator", 1);
            numeratorBox.addChild(DagBuilder.createLayout(f, DagConstants.ONE));
        }
        return numeratorBox;
    }

    private LayoutBox buildDenominator(LayoutFormatter f, Dag denominatorDag, int precedence, int operator) {
        ProdLayoutBox denominatorBox = null;
        if (denominatorDag != null) {
            int length = denominatorDag.getLength();
            denominatorBox = new ProdLayoutBox("denominator", length / 2);
            denominatorBox.setDag(denominatorDag);
            denominatorBox.setPrecedence(precedence);
            NotationLayoutBox op = null;
            if (length == 2) {
                denominatorBox.addChild(DagBuilder.createLayout(f, denominatorDag.getChild(0)));
            } else {
                int i = 0;
                while (i < length) {
                    op = NotationLayoutBox.createNotationBox(f, operator);
                    BinaryOperationTemplate.apply(f, (LayoutBox)denominatorBox, op, denominatorDag.getChild(i), 4);
                    i += 2;
                }
            }
        }
        return denominatorBox;
    }

    public static boolean isQuotient(Dag dag) {
        int length;
        boolean q = false;
        if (dag.getType() == 14 && (length = dag.getLength()) > 0) {
            if (dag.getChild(0).getType() == 3) {
                q = true;
            } else {
                int i = 1;
                while (i < length) {
                    if (dag.getChild(i).getType() == 1) {
                        q = true;
                        break;
                    }
                    i += 2;
                }
            }
        }
        return q;
    }

    public static class ProdLayoutBox
    extends InlineLayoutBox {
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker(10);
        private int precedence = 4;

        public ProdLayoutBox(String s, int i) {
            super(s, i);
        }

        public ProdLayoutBox() {
        }

        @Override
        public void setLineBreaker(LineBreaker l) {
        }

        @Override
        public LineBreaker getLineBreaker() {
            return lb;
        }

        public void setPrecedence(int prec) {
            this.precedence = prec;
        }

        public int getPrecedence() {
            return this.precedence;
        }
    }
}

