/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractBinopDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.TTYFormatter;
import com.maplesoft.client.prettyprinter.template.DivideTemplate;

public class RationalDagFactory
extends AbstractBinopDagFactory {
    @Override
    public int getType() {
        return 3;
    }

    @Override
    public boolean isVariableLength() {
        return false;
    }

    @Override
    public String getStringOperator(WmiLPrintOptions options) {
        return "/";
    }

    @Override
    public int getPrecedence() {
        return 4;
    }

    @Override
    public int getPrecedence(Dag dag) {
        return DagUtil.isNegative(dag) ? 6 : 4;
    }

    public Dag toProduct(Dag dag) {
        Dag numerator = dag.getChild(0);
        Dag denominator = dag.getChild(1);
        Dag[] prodKids = new Dag[]{numerator, DagConstants.ONE, denominator, DagConstants.MINUS_ONE};
        return Dag.createDag(14, prodKids, null, false);
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        LayoutBox result = null;
        if (f.useInLine(dag) || f.isInProc() || f instanceof TTYFormatter && f.isInSuperscript()) {
            result = super.createLayout(f, dag);
        } else {
            Dag numeratorDag = dag.getChild(0);
            Dag denominatorDag = dag.getChild(1);
            double sizeLimit = f.getSafeBreakWidth();
            InlineLayoutBox numeratorBox = new InlineLayoutBox(1);
            InlineLayoutBox denominatorBox = new InlineLayoutBox(1);
            numeratorBox.addChild(DagBuilder.createLayout(f, numeratorDag));
            denominatorBox.addChild(DagBuilder.createLayout(f, denominatorDag));
            numeratorBox.applyLayout();
            denominatorBox.applyLayout();
            int mode = numeratorBox.getWidth() < sizeLimit && denominatorBox.getWidth() < sizeLimit ? 0 : 1;
            result = DivideTemplate.apply(f, numeratorBox, denominatorBox, mode);
        }
        return result;
    }

    @Override
    public NotationLayoutBox createNotationBox(LayoutFormatter f) {
        return NotationLayoutBox.createNotationBox(f, 19);
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        Dag numerator = dag.getChild(0);
        if (DagUtil.isNegative(numerator)) {
            dag = dag.copy();
            dag.setChild(0, DagUtil.negate(numerator));
            result.append("-");
        }
        super.linePrint(result, dag, options);
    }
}

