/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.RtableData;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class RtableDagData
extends RtableData {
    private Dag[] theData;
    private String theName;

    public RtableDagData() {
    }

    public RtableDagData(Dag[] theData, String theName, int[] sizes, int[] dims) {
        this.theDimensions = dims;
        this.sizes = sizes;
        this.theData = theData;
        this.theName = theName;
        this.calculatedMultipliers();
    }

    @Override
    public void readDotm(WmiByteArrayInputStream bs, int[] sizes, int[] dims) throws IOException {
        super.readDotm(bs, sizes, dims);
        this.theData = new Dag[sizes[0]];
        int i = 0;
        while (i < sizes[0]) {
            this.theData[i] = DagBuilder.create(bs);
            ++i;
        }
    }

    @Override
    public StringBuffer writeDotm() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.theData.length) {
            DagBuilder.writeDotm(sb, this.theData[i]);
            ++i;
        }
        return sb;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[ ");
        int i = 0;
        while (i < this.theData.length) {
            DagBuilder.linePrint(sb, this.theData[i]);
            if (i < this.theData.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("] ");
        return sb.toString();
    }

    @Override
    public int getIntegerAt(int[] positions) {
        int position = this.getPosition(positions);
        return DagUtil.parseInt(this.theData[position]);
    }

    @Override
    public double getDoubleAt(int[] positions) {
        int position = this.getPosition(positions);
        return DagUtil.parseDouble(this.theData[position]);
    }

    @Override
    public float getFloatAt(int[] positions) {
        int position = this.getPosition(positions);
        return DagUtil.parseFloat(this.theData[position]);
    }

    @Override
    public Dag getDagAt(int[] positions) {
        int position = this.getPosition(positions);
        return this.theData[position];
    }

    @Override
    public int getIntegerAt(int positions) {
        return DagUtil.parseInt(this.theData[positions]);
    }

    @Override
    public double getDoubleAt(int positions) {
        return DagUtil.parseDouble(this.theData[positions]);
    }

    @Override
    public float getFloatAt(int positions) {
        return DagUtil.parseFloat(this.theData[positions]);
    }

    @Override
    public Dag getDagAt(int position) {
        return position >= 0 && position < this.theData.length ? this.theData[position] : null;
    }

    @Override
    public String getNamedArray() {
        return this.theName;
    }

    @Override
    public Dag getDagAt(int x, int y) {
        int position = this.getPosition(x, y);
        return this.theData[position];
    }

    public void setDagAt(int[] position, Dag value) {
        int pos = this.getPosition(position);
        this.theData[pos] = value;
    }

    public void setDagAt(int x, int y, Dag value) {
        int pos = this.getPosition(x, y);
        this.theData[pos] = value;
    }

    @Override
    protected void calculatedMultipliers() {
        this.theMultipliers = new int[this.theDimensions.length];
        int i = 0;
        while (i < this.theDimensions.length) {
            if (i == this.theDimensions.length - 1) {
                this.theMultipliers[i] = 0;
            } else {
                this.theMultipliers[i] = 1;
                int j = i;
                while (j < this.theDimensions.length - 1) {
                    int n = i;
                    this.theMultipliers[n] = this.theMultipliers[n] * (this.sizes[2 * j + 2] - this.sizes[2 * j + 1] + 1);
                    ++j;
                }
            }
            ++i;
        }
    }
}

