/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.RtableComplexData;
import com.maplesoft.client.dag.RtableDag;
import com.maplesoft.client.dag.RtableDagData;
import com.maplesoft.client.dag.RtableData;
import com.maplesoft.client.dag.RtableDoubleData;
import com.maplesoft.client.dag.RtableIntData;
import com.maplesoft.client.dag.RtableShortData;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.dag.util.RTableElementAccessor;
import com.maplesoft.client.dag.util.RTableFlagConverter;
import com.maplesoft.client.prettyprinter.AbstractLayoutBox;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RtableDagFactory
extends AbstractDagFactory {
    public static final int RTABLE_DATA = 0;
    public static final int RTABLE_MAPLETYPE = 1;
    public static final int RTABLE_INDFN = 2;
    public static final int RTABLE_ATTRIB = 3;
    public static final int RTABLE_FLAGS = 4;
    public static final int RTABLE_NUMELEMS = 5;
    public static final int RTABLE_BOUNDS = 6;
    public static final int RTABLE_FLAG_COUNT = 7;
    private static final int RTABLE_NUMDIMS_LENGTH = 6;
    private static final int RTABLE_RESERVED_LENGTH = 10;
    private static final int RTABLE_EVAL_LENGTH = 1;
    private static final int RTABLE_LITERAL_LENGTH = 1;
    private static final int RTABLE_FOREIGN_LENGTH = 1;
    private static final int RTABLE_READONLY_LENGTH = 1;
    private static final int RTABLE_ORDER_LENGTH = 1;
    private static final int RTABLE_STORAGE_LENGTH = 4;
    private static final int RTABLE_SUBTYPE_LENGTH = 2;
    private static final int RTABLE_DATATYPE_LENGTH = 5;
    private static final int RTABLE_NUMDIMS_OFFSET = 0;
    private static final int RTABLE_RESERVED_OFFSET = 6;
    private static final int RTABLE_EVAL_OFFSET = 16;
    private static final int RTABLE_LITERAL_OFFSET = 17;
    private static final int RTABLE_FOREIGN_OFFSET = 18;
    private static final int RTABLE_READONLY_OFFSET = 19;
    private static final int RTABLE_ORDER_OFFSET = 20;
    private static final int RTABLE_STORAGE_OFFSET = 21;
    private static final int RTABLE_SUBTYPE_OFFSET = 25;
    private static final int RTABLE_DATATYPE_OFFSET = 27;
    private static final int RTABLE_NUMDIMS_MASK = 63;
    private static final int RTABLE_RESERVED_MASK = 65472;
    private static final int RTABLE_EVAL_MASK = 65536;
    private static final int RTABLE_LITERAL_MASK = 131072;
    private static final int RTABLE_FOREIGN_MASK = 262144;
    private static final int RTABLE_READONLY_MASK = 524288;
    private static final int RTABLE_ORDER_MASK = 0x100000;
    private static final int RTABLE_STORAGE_MASK = 0x1E00000;
    private static final int RTABLE_SUBTYPE_MASK = 0x6000000;
    private static final int RTABLE_DATATYPE_MASK = -134217728;
    private static final int RTABLE_FLAG_MASK = -65473;
    boolean shortOutput = false;

    public int getType() {
        return 38;
    }

    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        return this.readDotm(is, 38, DagBuilder.parseShortInteger(is));
    }

    @Override
    protected Dag readDotm(WmiByteArrayInputStream bs, int type, int length) throws IOException {
        int cnt = 0;
        if (type != 57 && type != 56) {
            cnt = DagBuilder.dagCountPlus();
        }
        RtableDag dag = new RtableDag();
        dag.setType(type);
        Object[] myDag = new Dag[length];
        Arrays.fill(myDag, DagConstants.EMPTY);
        dag.setChildren((Dag[])myDag);
        myDag[1] = DagBuilder.create(bs);
        myDag[2] = DagBuilder.create(bs);
        myDag[3] = DagBuilder.create(bs);
        int[] flags = new int[7];
        int flagType = DagBuilder.parseShortInteger(bs);
        if (flagType >> 6 == 7) {
            flags[0] = DagBuilder.parseShortInteger(bs);
            flags[1] = DagBuilder.parseShortInteger(bs);
            flags[2] = DagBuilder.parseShortInteger(bs);
            flags[3] = DagBuilder.parseShortInteger(bs);
            flags[4] = DagBuilder.parseShortInteger(bs);
            flags[5] = DagBuilder.parseShortInteger(bs);
            flags[6] = DagBuilder.parseShortInteger(bs);
        } else {
            int flagData = flagType;
            flags[6] = (flagData & 0x3F) >> 0;
            flags[0] = ((flagData >>= 1) & 0xF8000000) >> 27;
            flags[1] = (flagData & 0x6000000) >> 25;
            flags[2] = (flagData & 0x1E00000) >> 21;
            flags[3] = (flagData & 0x100000) >> 20;
            flags[4] = (flagData & 0x80000) >> 19;
            flags[5] = (flagData & 0xFFC0) >> 6;
        }
        dag.setFlags(flags);
        int[] sizes = new int[length - 6];
        int dimensionCount = flags[6];
        int i = 6;
        while (i < length) {
            sizes[i - 6] = DagBuilder.parseShortInteger(bs);
            ++i;
        }
        int[] dims = new int[dimensionCount];
        int i2 = 2;
        int j = 0;
        while (i2 <= dims.length * 2) {
            dims[j] = sizes[i2];
            i2 += 2;
            ++j;
        }
        dag.setSizes(sizes);
        RtableData ard = null;
        int dataType = flags[0];
        switch (dataType) {
            case 1: {
                break;
            }
            case 0: {
                ard = new RtableDagData();
                break;
            }
            case 2: {
                ard = new RtableShortData();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                ard = new RtableIntData();
                break;
            }
            case 8: {
                break;
            }
            case 6: {
                ard = new RtableDoubleData();
                break;
            }
            case 7: {
                ard = new RtableComplexData();
                break;
            }
        }
        if (ard != null) {
            ((RtableData)ard).readDotm(bs, sizes, dims);
            dag.setTableData(ard);
        }
        if (type != 57 && type != 56) {
            DagBuilder.putDag(dag, cnt);
        }
        return dag;
    }

    @Override
    public Dag readDotm(WmiByteArrayInputStream bs, int type) throws IOException {
        return this.readDotm(bs, 38, type);
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        RtableDag rtdag = (RtableDag)dag;
        int type = rtdag.getType();
        char ch = (char)(MapleNumbers.dotMOutputTable[type] + 33 - 1);
        sb.append(ch);
        int len = rtdag.getLength();
        DagBuilder.writeShortInteger(sb, len);
        DagBuilder.writeDotm(sb, rtdag.getChild(1));
        DagBuilder.writeDotm(sb, rtdag.getChild(2));
        DagBuilder.writeDotm(sb, rtdag.getChild(3));
        DagBuilder.writeShortInteger(sb, 448);
        DagBuilder.writeShortInteger(sb, rtdag.getDataType());
        DagBuilder.writeShortInteger(sb, rtdag.getSubType());
        DagBuilder.writeShortInteger(sb, rtdag.getStorage());
        DagBuilder.writeShortInteger(sb, rtdag.getOrder());
        DagBuilder.writeShortInteger(sb, rtdag.getReadOnly());
        DagBuilder.writeShortInteger(sb, 0);
        DagBuilder.writeShortInteger(sb, rtdag.getDimensionCount());
        int[] sizes = rtdag.getSizes();
        int i = 0;
        while (i < sizes.length) {
            DagBuilder.writeShortInteger(sb, sizes[i]);
            ++i;
        }
        if (rtdag.getDataType() != 0 || rtdag.getStorage() != 0) {
            rtdag.getStorage();
            RtableData ard = rtdag.getTableData();
            sb.append(ard.writeDotm());
        }
    }

    private static boolean isSparse(RtableDag rt) {
        return rt.getStorage() == 0;
    }

    private static boolean hasIndexingFunction(RtableDag rt) {
        Dag indexFuncDag = rt.getChild(2);
        return indexFuncDag.getLength() > 0;
    }

    private static int getIndexingFunctionCount(RtableDag rt) {
        Dag indexFuncDag = rt.getChild(2);
        return indexFuncDag.getLength();
    }

    private static Dag getIndexingFunctions(RtableDag rt) {
        int len;
        Dag indexFuncDag = rt.getChild(2);
        if (indexFuncDag.getChild((len = indexFuncDag.getLength()) - 1).getType() == 38) {
            --len;
        }
        Dag[] t = new Dag[len];
        int i = 0;
        while (i < len) {
            t[i] = indexFuncDag.getChild(i);
            ++i;
        }
        return DagUtil.createListDag(t);
    }

    private static void lPrintTableIndex(StringBuffer result, RtableDag rt, Dag index, WmiLPrintOptions options) {
        result.append("(");
        int i = 0;
        while (i < index.getLength()) {
            result.append(index.getChild(i).getData());
            if (i < index.getLength() - 1) {
                result.append(", ");
            }
            ++i;
        }
        result.append(")");
    }

    private static boolean lPrintTableData(StringBuffer result, RtableDag rt, int cur, Dag ind_seq, WmiLPrintOptions options) {
        Dag ind;
        boolean wroteAtLeastOneTerm = false;
        if (RtableDagFactory.isSparse(rt)) {
            result.append("{");
            result.append(" sparse_data ");
            result.append("}");
            return false;
        }
        int rank = rt.getDimensionCount();
        int ubound = rt.getRangeUpperBound(cur);
        int lbound = rt.getRangeLowerBound(cur);
        Dag dag = ind = ind_seq.getChild(cur) != null ? ind_seq.copy() : ind_seq;
        if (cur == 0) {
            result.append("{");
        }
        if (cur == rank - 1) {
            int i = lbound;
            while (i <= ubound) {
                ind.replaceChildren(cur, cur, DagUtil.createIntDag(i));
                Dag t = RTableElementAccessor.getTableElement(rt, ind);
                if (t != null) {
                    if (i > lbound && wroteAtLeastOneTerm) {
                        result.append(", ");
                    }
                    RtableDagFactory.lPrintTableIndex(result, rt, ind, options);
                    result.append(" = ");
                    RtableDagFactory.lPrintDescendant(t, result, options);
                    wroteAtLeastOneTerm = true;
                }
                ++i;
            }
        } else {
            int i = lbound;
            while (i <= ubound) {
                ind.replaceChildren(cur, cur, DagUtil.createIntDag(i));
                if (RtableDagFactory.lPrintTableData(result, rt, cur + 1, ind, options)) {
                    wroteAtLeastOneTerm = true;
                    if (i < ubound) {
                        result.append(", ");
                    }
                }
                ++i;
            }
        }
        if (cur == 0) {
            result.append("}");
        }
        return wroteAtLeastOneTerm;
    }

    private static void lPrintTableOptions(StringBuffer result, RtableDag rt, WmiLPrintOptions options) {
        Dag attribs;
        int dataType = rt.getDataType();
        int subType = rt.getSubType();
        int storageType = rt.getStorage();
        int order = rt.getOrder();
        boolean readOnly = rt.isReadOnly();
        if (dataType != 0) {
            result.append(", datatype = ");
            result.append(RTableFlagConverter.getDataTypeLabel(dataType));
        }
        if (storageType != 4) {
            result.append(", storage = ");
            result.append(RTableFlagConverter.getStorageLabel(storageType, rt));
        }
        if (order != 0) {
            result.append(", order = ");
            result.append(RTableFlagConverter.getOrderLabel(order));
        }
        if (readOnly) {
            result.append(", readonly");
        }
        if (!DagUtil.isNull(attribs = rt.getChild(3))) {
            result.append(", attributes = [");
            RtableDagFactory.lPrintDescendant(attribs, result, options);
            result.append("]");
        }
        if (subType != 0 && RtableDagFactory.hasIndexingFunction(rt)) {
            result.append(", shape = ");
            Dag indexFuncDag = RtableDagFactory.getIndexingFunctions(rt);
            RtableDagFactory.lPrintDescendant(indexFuncDag, result, options);
        }
    }

    private static void lPrintDescendant(Dag dag, StringBuffer result, WmiLPrintOptions options) {
        String indexFuncLPrint = DagBuilder.lPrint(dag, options);
        result.append(indexFuncLPrint);
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        Dag ind;
        int i;
        RtableDag s = (RtableDag)dag;
        int subtype = s.getSubType();
        switch (subtype) {
            case 0: {
                result.append("Array");
                result.append("(");
                int l = RtableDagFactory.getIndexingFunctionCount(s);
                Dag indexFuncDag = s.getChild(2);
                i = 1;
                while (i <= l) {
                    RtableDagFactory.lPrintDescendant(indexFuncDag.getChild(i), result, options);
                    result.append(",");
                    ++i;
                }
                break;
            }
            case 1: {
                result.append("Matrix");
                result.append("(");
                break;
            }
            case 3: {
                result.append("Vector[row]");
                result.append("(");
                break;
            }
            case 2: {
                result.append("Vector");
                result.append("(");
            }
        }
        if (subtype == 0) {
            ind = DagUtil.createExpSeqDag(null);
            i = 0;
            while (i < s.getDimensionCount()) {
                result.append(Integer.toString(s.getRangeLowerBound(i)));
                result.append("..");
                result.append(Integer.toString(s.getRangeUpperBound(i)));
                result.append(", ");
                ++i;
            }
        } else {
            ind = DagUtil.createExpSeqDag(null);
            i = 0;
            while (i < s.getDimensionCount()) {
                result.append(Integer.toString(s.getRangeUpperBound(i)));
                result.append(", ");
                ++i;
            }
        }
        ind = DagUtil.createExpSeqDag(new Dag[s.getDimensionCount()]);
        if (s.getDimensionCount() == 0) {
            result.append("fill = ");
            RtableDagFactory.lPrintDescendant(ind, result, options);
        } else {
            RtableDagFactory.lPrintTableData(result, s, 0, ind, options);
        }
        RtableDagFactory.lPrintTableOptions(result, s, options);
        result.append(")");
    }

    public Element export(Dag dag, Document doc) {
        Element result = null;
        int type = dag.getType();
        RtableDag rdag = (RtableDag)dag;
        result = doc.createElement(DagBuilder.ELEMENT_NAME[type]);
        RtableData rt = rdag.getTableData();
        result.setAttribute("data", rt.getNamedArray());
        return result;
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        int type = dag.getType();
        AbstractLayoutBox b = null;
        b = new DefaultLayoutBox(DagBuilder.ELEMENT_NAME[type]);
        this.shortOutput = true;
        StringBuffer value = new StringBuffer();
        this.linePrint(value, dag, new WmiLPrintOptions());
        b = NotationLayoutBox.createCustomBox(f, value.toString());
        SelectionData sd = new SelectionData(1);
        sd.setStandardEastWestArray(b);
        sd.setStandardNorthSouthArray();
        b.setSelectionData(sd);
        return b;
    }

    public static RtableDag createFromDoubleArray(double[] data) {
        RtableDag dag = new RtableDag();
        int len = 3;
        Dag[] myDags = new Dag[len + 3];
        int i = 0;
        while (i < len + 3) {
            myDags[i] = i == 1 ? Dag.createDag(8, null, "anything", false) : DagConstants.EMPTY;
            ++i;
        }
        dag.setChildren(myDags);
        int[] flags = new int[7];
        flags[0] = 6;
        flags[1] = 0;
        flags[2] = 4;
        flags[3] = 0;
        flags[6] = 1;
        dag.setFlags(flags);
        int[] sizes = new int[]{data.length, 0, data.length - 1};
        dag.setSizes(sizes);
        RtableDoubleData ard = new RtableDoubleData();
        ard.setDoubleData(data);
        dag.setTableData(ard);
        return dag;
    }
}

